package cz.cuni.amis.pogamut.defcon.ai;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.communication.mailbox.IMessage;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;

/**
 * Implementation of common features for all units.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public abstract class AbstractAI implements IUnitAI {

	public final DefConAgentLogicController<?> logic;
	public final int unitId;
	public final WorldObjectId worldObjectId;

	public AbstractAI(DefConAgentLogicController<?> logic,
			WorldObjectId worldObjectId) {

		this.logic = logic;
		this.worldObjectId = worldObjectId;
		this.unitId = Integer.parseInt(worldObjectId.getStringId());
	}

	@Override
	public void receiveMessage(IMessage message) {
		return;
	}

	@Override
	public WorldObjectId getId() {
		return worldObjectId;
	}

	/**
	 * Simplifies posting of commands.
	 * 
	 * @param command
	 */
	protected final void act(DefConCommand command) {
		logic.getAct().act(command);
	}

	@Override
	public void dispose() {
		logic.getMailBox().unregisterAI(this);
	}
}
