/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.agent.module.sensor;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DebugIsReplayingGameChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.GameRunningChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.GameSpeedChanged;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.VictoryTimerActiveChanged;
import cz.cuni.amis.pogamut.defcon.consts.GameSpeed;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.consts.state.IState;
import cz.cuni.amis.pogamut.defcon.utils.AdvancedFlagListener;
import cz.cuni.amis.pogamut.defcon.utils.SimpleFlag;
import cz.cuni.amis.pogamut.defcon.utils.SyncMethodExecContainer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javabot.JBot;
import javabot.JBotMethodsRepository;
import javabot.PogamutJBotSupport;
import javabot.events.IDefConBasicEvent;

public class GameInfo {
    private static final int MAX_FLEET_SIZE = 6;
    private final int[] territoryOwners = new int[6];
    private final double[] fleetDiameters = new double[6];
    private final Location[][] fleetMemberOffsets = new Location[6][];
    private Float gameTime = Float.valueOf(0.0f);
    private Integer gameTick = 0;
    private Float victoryTimer = Float.valueOf(0.0f);
    private int ownTeamId;
    private final SortedMap<Integer, List<Integer>> enemiesCityIds = new TreeMap<Integer, List<Integer>>();
    private final List<Integer> ownCityIds = new ArrayList<Integer>();
    private final SortedMap<Integer, Location> cityLocations = new TreeMap<Integer, Location>();
    private int[] enemyIds;
    private final SimpleFlag<Integer> defcon = new SimpleFlag<Integer>(5);
    private final AdvancedFlagListener<Integer> defconListener = new AdvancedFlagListener<Integer>(){

        @Override
        public void flagChanged(Integer oldValue, Integer changedValue) {
            GameInfo.this.events.add(new DefConChanged(oldValue, changedValue, GameInfo.this.getGameTime()));
        }
    };
    private final SimpleFlag<GameSpeed> gameSpeed = new SimpleFlag<GameSpeed>(GameSpeed.PAUSED);
    private final AdvancedFlagListener<GameSpeed> gameSpeedListener = new AdvancedFlagListener<GameSpeed>(){

        @Override
        public void flagChanged(GameSpeed oldValue, GameSpeed changedValue) {
            GameInfo.this.events.add(new GameSpeedChanged(oldValue, changedValue, GameInfo.this.getGameTime()));
        }
    };
    private final SimpleFlag<Boolean> victoryTimerActive = new SimpleFlag<Boolean>(false);
    private AdvancedFlagListener<Boolean> victoryTimerActiveListener = new AdvancedFlagListener<Boolean>(){

        @Override
        public void flagChanged(Boolean oldValue, Boolean changedValue) {
            GameInfo.this.events.add(new VictoryTimerActiveChanged(changedValue, GameInfo.this.getGameTime()));
        }
    };
    private final SimpleFlag<Boolean> debugIsReplayingGame = new SimpleFlag<Boolean>(false);
    private final AdvancedFlagListener<Boolean> debugIsReplayingGameListener = new AdvancedFlagListener<Boolean>(){

        @Override
        public void flagChanged(Boolean oldValue, Boolean changedValue) {
            GameInfo.this.events.add(new DebugIsReplayingGameChanged(changedValue, GameInfo.this.getGameTime()));
        }
    };
    private final SimpleFlag<Boolean> gameRunning = new SimpleFlag<Boolean>(false);
    private AdvancedFlagListener<Boolean> gameRunningListener = new AdvancedFlagListener<Boolean>(){

        @Override
        public void flagChanged(Boolean oldValue, Boolean changedValue) {
            if (changedValue.booleanValue()) {
                GameInfo.this.cacheOwnTeamId();
                GameInfo.this.populateTerritoryOwners();
                GameInfo.this.populateCityLocations();
            }
            GameInfo.this.events.add(new GameRunningChanged(changedValue, GameInfo.this.getGameTime()));
        }
    };
    private final BlockingQueue<IDefConBasicEvent> events = new LinkedBlockingQueue<IDefConBasicEvent>();
    private final LinkedList<Location> aiPlacementPoints = new LinkedList();
    private final LinkedList<Location> targetCoords = new LinkedList();
    private final float MIN_STEP = 5.0f;

    public GameInfo() {
        this.gameTime = Float.valueOf(JBot.GetGameTime());
        this.gameTick = JBot.GetGameTick();
        this.victoryTimer = Float.valueOf(0.0f);
        this.gameRunning.addStrongListener(this.gameRunningListener);
        this.defcon.addStrongListener(this.defconListener);
        this.gameSpeed.addStrongListener(this.gameSpeedListener);
        this.victoryTimerActive.addStrongListener(this.victoryTimerActiveListener);
        this.debugIsReplayingGame.addStrongListener(this.debugIsReplayingGameListener);
        this.populateFleetMemberOffsets();
        this.populateFleetDiameters();
    }

    private void populateCityLocations() {
        int[] cities;
        for (int cityId : cities = this.getCityIds()) {
            Location location = this.getObjectLocation(cityId);
            int territoryId = this.getTerritoryId(location);
            int teamId = this.territoryOwners[territoryId];
            this.cityLocations.put(cityId, location);
            if (teamId == -1) continue;
            if (teamId == this.getOwnTeamId()) {
                this.ownCityIds.add(cityId);
                continue;
            }
            ((List)this.enemiesCityIds.get(teamId)).add(cityId);
        }
    }

    private final void populateTerritoryOwners() {
        for (int i = 0; i < this.territoryOwners.length; ++i) {
            this.territoryOwners[i] = -1;
        }
        ArrayList<Integer> enemies = new ArrayList<Integer>();
        int own_id = this.getOwnTeamId();
        for (int teamId : JBot.GetTeamIds()) {
            if (teamId != own_id) {
                enemies.add(teamId);
                this.enemiesCityIds.put(teamId, new ArrayList());
            }
            for (int territoryId : this.getTeamTerritories(teamId)) {
                this.territoryOwners[territoryId] = teamId;
            }
        }
        this.enemyIds = new int[enemies.size()];
        int i = 0;
        Iterator i$ = enemies.iterator();
        while (i$.hasNext()) {
            int enemyId = (Integer)i$.next();
            this.enemyIds[i++] = enemyId;
        }
    }

    private final void populateFleetMemberOffsets() {
        for (int i = 0; i < 6; ++i) {
            this.fleetMemberOffsets[i] = new Location[i + 1];
            for (int j = 0; j <= i; ++j) {
                this.fleetMemberOffsets[i][j] = this.getFleetMemberOffsetWorker(i + 1, j);
            }
        }
    }

    private final void populateFleetDiameters() {
        for (int i = 0; i < 6; ++i) {
            this.fleetDiameters[i] = this.getFleetDiameterWorker(i + 1);
        }
    }

    private void cacheOwnTeamId() {
        this.ownTeamId = JBot.GetOwnTeamId();
    }

    public LinkedList<IDefConBasicEvent> getEvents() {
        this.gameTime = Float.valueOf(JBot.GetGameTime());
        this.gameTick = JBot.GetGameTick();
        this.victoryTimerActive.setFlag(JBot.IsVictoryTimerActive());
        if (this.victoryTimerActive.getFlag().booleanValue()) {
            this.victoryTimer = Float.valueOf(JBot.GetVictoryTimer());
        }
        this.gameRunning.setFlag(true);
        this.defcon.setFlag(JBot.GetDefcon());
        this.gameSpeed.setFlag(GameSpeed.getEnum(JBot.GetGameSpeed()));
        this.victoryTimerActive.setFlag(JBot.IsVictoryTimerActive());
        this.debugIsReplayingGame.setFlag(JBot.DebugIsReplayingGame());
        LinkedList<IDefConBasicEvent> output = new LinkedList<IDefConBasicEvent>();
        this.events.drainTo(output);
        return output;
    }

    private void populatePoints() {
        this.checkedAddToAIPlacementPoints(new Location(-177.890625, 34.73684310913086));
        this.checkedAddToAIPlacementPoints(new Location(-177.1875, 46.66666793823242));
        this.checkedAddToAIPlacementPoints(new Location(-156.09375, 45.96491241455078));
        this.checkedAddToAIPlacementPoints(new Location(-151.875, 35.438594818115234));
        this.checkedAddToAIPlacementPoints(new Location(-146.953125, 22.807018280029297));
        this.targetCoords.add(new Location(-142.03125, 45.96491241455078));
        this.targetCoords.add(new Location(-136.40625, 28.421052932739258));
        this.checkedAddToAIPlacementPoints(new Location(-133.59375, 20.701753616333008));
        this.checkedAddToAIPlacementPoints(new Location(-123.046875, 26.31578826904297));
        this.targetCoords.add(new Location(-118.828125, 9.473684310913086));
        this.checkedAddToAIPlacementPoints(new Location(-113.203125, -9.473684310913086));
        this.checkedAddToAIPlacementPoints(new Location(-106.171875, (double)6.666667f));
        this.checkedAddToAIPlacementPoints(new Location(-93.515625, (double)-6.666667f));
        this.targetCoords.add(new Location(-93.515625, (double)-0.350877f));
        this.checkedAddToAIPlacementPoints(new Location(-91.40625, -18.59649085998535));
        this.targetCoords.add(new Location(-88.59375, -27.719297409057617));
        this.targetCoords.add(new Location(-64.6875, 29.122806549072266));
        this.checkedAddToAIPlacementPoints(new Location(-56.25, 22.807018280029297));
        this.checkedAddToAIPlacementPoints(new Location(-55.546875, 35.438594818115234));
        this.targetCoords.add(new Location(-50.625, 16.491228103637695));
        this.targetCoords.add(new Location(-47.8125, 36.842105865478516));
        this.checkedAddToAIPlacementPoints(new Location(-44.296875, (double)31.22807f));
        this.targetCoords.add(new Location(-43.59375, 48.77193069458008));
        this.checkedAddToAIPlacementPoints(new Location(-42.890625, 41.75438690185547));
        this.checkedAddToAIPlacementPoints(new Location(-40.078125, 4.561404228210449));
        this.checkedAddToAIPlacementPoints(new Location(-37.96875, 22.105262756347656));
        this.checkedAddToAIPlacementPoints(new Location(-37.265625, -30.526315689086914));
        this.targetCoords.add(new Location(-31.640625, -17.894737243652344));
        this.checkedAddToAIPlacementPoints(new Location(-31.640625, 35.438594818115234));
        this.targetCoords.add(new Location(-30.234375, -35.438594818115234));
        this.checkedAddToAIPlacementPoints(new Location(-29.53125, 45.26315689086914));
        this.checkedAddToAIPlacementPoints(new Location(-28.828125, 9.473684310913086));
        this.checkedAddToAIPlacementPoints(new Location(-28.125, 24.912281036376953));
        this.checkedAddToAIPlacementPoints(new Location(-26.71875, (double)0.350877f));
        this.checkedAddToAIPlacementPoints(new Location(-25.3125, -17.894737243652344));
        this.targetCoords.add(new Location(-23.203125, 13.684210777282715));
        this.targetCoords.add(new Location(-22.5, (double)31.22807f));
        this.checkedAddToAIPlacementPoints(new Location(-21.796875, 38.94736862182617));
        this.checkedAddToAIPlacementPoints(new Location(-21.796875, (double)52.2807f));
        this.targetCoords.add(new Location(-21.09375, 45.26315689086914));
        this.checkedAddToAIPlacementPoints(new Location(-14.765625, 35.438594818115234));
        this.checkedAddToAIPlacementPoints(new Location(-14.0625, 47.3684196472168));
        this.checkedAddToAIPlacementPoints(new Location(-11.953125, -5.964911937713623));
        this.checkedAddToAIPlacementPoints(new Location(-10.546875, 60.0));
        this.targetCoords.add(new Location(-9.140625, 68.42105102539062));
        this.targetCoords.add(new Location(0.0, 69.12281036376953));
        this.targetCoords.add(new Location(1.40625, -4.561404228210449));
        this.checkedAddToAIPlacementPoints(new Location(2.8125, 73.33333587646484));
        this.checkedAddToAIPlacementPoints(new Location(3.515625, -19.298246383666992));
        this.checkedAddToAIPlacementPoints(new Location(4.21875, 67.01754760742188));
        this.targetCoords.add(new Location(6.328125, -31.929824829101562));
        this.checkedAddToAIPlacementPoints(new Location(12.65625, 71.92982482910156));
        this.checkedAddToAIPlacementPoints(new Location(28.828125, 76.14035034179688));
        this.targetCoords.add(new Location(35.859375, 75.4385986328125));
        this.checkedAddToAIPlacementPoints(new Location(38.671875, 74.7368392944336));
        this.checkedAddToAIPlacementPoints(new Location(48.515625, 75.4385986328125));
        this.targetCoords.add(new Location(49.21875, -5.263157844543457));
        this.checkedAddToAIPlacementPoints(new Location(56.953125, -10.17543888092041));
        this.checkedAddToAIPlacementPoints(new Location(58.359375, (double)1.754386f));
        this.targetCoords.add(new Location(64.6875, (double)8.77193f));
        this.targetCoords.add(new Location(70.3125, (double)-6.666667f));
        this.checkedAddToAIPlacementPoints(new Location(71.015625, (double)3.859649f));
        this.checkedAddToAIPlacementPoints(new Location(82.96875, (double)-3.859649f));
        this.targetCoords.add(new Location(90.0, (double)-2.45614f));
        this.checkedAddToAIPlacementPoints(new Location(94.921875, -12.280701637268066));
        this.targetCoords.add(new Location(132.890625, 21.40350914001465));
        this.targetCoords.add(new Location(134.296875, 10.17543888092041));
        this.checkedAddToAIPlacementPoints(new Location(144.84375, 27.01754379272461));
        this.checkedAddToAIPlacementPoints(new Location(149.0625, 15.087718963623047));
        this.targetCoords.add(new Location(150.46875, (double)31.22807f));
        this.checkedAddToAIPlacementPoints(new Location(154.6875, 34.03508758544922));
        this.checkedAddToAIPlacementPoints(new Location(157.5, 21.40350914001465));
        this.targetCoords.add(new Location(158.90625, 41.05263137817383));
        this.checkedAddToAIPlacementPoints(new Location(163.828125, 46.66666793823242));
        this.checkedAddToAIPlacementPoints(new Location(165.234375, (double)8.77193f));
        this.checkedAddToAIPlacementPoints(new Location(167.34375, 32.6315803527832));
        this.checkedAddToAIPlacementPoints(new Location(172.265625, 20.701753616333008));
        this.checkedAddToAIPlacementPoints(new Location(172.96875, 45.96491241455078));
    }

    private final void checkedAddToAIPlacementPoints(Location location) {
        if (JBot.IsValidTerritory(JBot.GetOwnTeamId(), (float)location.getX(), (float)location.getY(), true) || JBot.IsValidTerritory(JBot.GetOwnTeamId(), (float)location.getX(), (float)location.getY(), true)) {
            this.aiPlacementPoints.add(location);
        }
    }

    public final LinkedList<Location> getAIPlacementPoints() {
        return this.aiPlacementPoints;
    }

    public final LinkedList<Location> getTargetCoords() {
        return this.targetCoords;
    }

    public int getDefconLevel() {
        return this.defcon.getFlag();
    }

    public float getGameTime() {
        return this.gameTime.floatValue();
    }

    public int getGameTick() {
        return this.gameTick;
    }

    public GameSpeed getGameSpeed() {
        return this.gameSpeed.getFlag();
    }

    public float getVictoryTimer() {
        return this.victoryTimer.floatValue();
    }

    public boolean isVictoryTimerActive() {
        return this.victoryTimerActive.getFlag();
    }

    public int getOptionValue(String name) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetOptionValue(), new Object[]{name});
        return (Integer)container.syncCallInMainThread();
    }

    public boolean debugIsReplayingGame() {
        return this.debugIsReplayingGame.getFlag();
    }

    public int getTeamId(int id) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetTeamId(), new Object[]{id});
        return (Integer)container.syncCallInMainThread();
    }

    public int[] getOwnFleets() {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetOwnFleets(), null);
        return (int[])container.syncCallInMainThread();
    }

    public int[] getFleets(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetFleets(), new Object[]{teamId});
        return (int[])container.syncCallInMainThread();
    }

    public int[] getFleetMembers(int fleetId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetFleetMembers(), new Object[]{fleetId});
        return (int[])container.syncCallInMainThread();
    }

    public int getFleetId(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetFleetId(), new Object[]{unitId});
        return (Integer)container.syncCallInMainThread();
    }

    public float getStateTimer(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetStateTimer(), new Object[]{unitId});
        return ((Float)container.syncCallInMainThread()).floatValue();
    }

    public int[] getActionQueue(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetActionQueue(), new Object[]{unitId});
        return (int[])container.syncCallInMainThread();
    }

    public boolean isRetaliating(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsRetaliating(), new Object[]{unitId});
        return (Boolean)container.syncCallInMainThread();
    }

    public boolean isVisible(int unitId, int byTeamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsVisible(), new Object[]{unitId, byTeamId});
        return (Boolean)container.syncCallInMainThread();
    }

    public Location getVelocity(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetVelocity(), new Object[]{unitId});
        return new Location((float[])container.syncCallInMainThread());
    }

    public float getRange(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetRange(), new Object[]{unitId});
        return ((Float)container.syncCallInMainThread()).floatValue();
    }

    public int getRemainingUnits(UnitType typeId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetRemainingUnits(), new Object[]{typeId.id});
        return (Integer)container.syncCallInMainThread();
    }

    public boolean isValidPlacementLocation(float longitude, float latitude, UnitType typeId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsValidPlacementLocation(), new Object[]{Float.valueOf(longitude), Float.valueOf(latitude), typeId.id});
        Object return_value = container.syncCallInMainThread();
        return (Boolean)return_value;
    }

    public boolean isValidPlacementLocation(double longitude, double latitude, UnitType typeId) {
        return this.isValidPlacementLocation((float)longitude, (float)latitude, typeId);
    }

    public boolean isValidShipPlacementLocation(Location location) {
        return this.isValidPlacementLocation(location.getX(), location.getY(), UnitType.BATTLE_SHIP);
    }

    public boolean isValidShipPlacementLocation(double longitude, double latitude) {
        return this.isValidPlacementLocation(longitude, latitude, UnitType.BATTLE_SHIP);
    }

    public boolean isValidBuildingPlacementLocation(Location location) {
        return this.isValidBuildingPlacementLocation(location.getX(), location.getY());
    }

    public boolean isValidBuildingPlacementLocation(double longitude, double latitude) {
        return this.isValidPlacementLocation(longitude, latitude, UnitType.RADAR);
    }

    public boolean isValidFleetPlacementLocation(float longitude, float latitude, int fleetSize) {
        for (int i = 0; i < fleetSize; ++i) {
            Location offset = this.getFleetMemberOffset(fleetSize, i);
            if (this.isValidShipPlacementLocation((double)longitude + offset.getX(), (double)latitude + offset.getY())) continue;
            return false;
        }
        return true;
    }

    public int getUnitCredits() {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetUnitCredits(), null);
        Object return_value = container.syncCallInMainThread();
        return (Integer)return_value;
    }

    public int getUnitValue(UnitType typeId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetUnitValue(), new Object[]{typeId.id});
        return (Integer)container.syncCallInMainThread();
    }

    public float getSailDistance(Location locationA, Location locationB) {
        if (locationA == null) {
            throw new IllegalArgumentException("GetSailDistance requires non-null arguments. [locationA]");
        }
        if (locationB == null) {
            throw new IllegalArgumentException("GetSailDistance requires non-null arguments. [locationB]");
        }
        return this.getSailDistance(locationA.getX(), locationA.getY(), locationB.getX(), locationB.getY());
    }

    public float getSailDistance(double locationA_x, double locationA_y, double locationB_x, double locationB_y) {
        return this.getSailDistance((float)locationA_x, (float)locationA_y, (float)locationB_x, (float)locationB_y);
    }

    public float getSailDistance(float locationA_x, float locationA_y, float locationB_x, float locationB_y) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetSailDistance(), new Object[]{Float.valueOf(locationA_x), Float.valueOf(locationA_y), Float.valueOf(locationB_x), Float.valueOf(locationB_y)});
        Object return_value = container.syncCallInMainThread();
        return (return_value instanceof Float ? (Float)return_value : null).floatValue();
    }

    public LocationWithDistance getClosestSailTarget(Location location, List<Location> border) {
        if (border == null || border.size() == 0) {
            return null;
        }
        if (border.size() == 1) {
            return new LocationWithDistance(this.getSailDistance(location, border.get(0)), border.get(0));
        }
        Iterator<Location> front = border.iterator();
        Location last = null;
        Location current = front.next();
        Location best = null;
        Location tmp = null;
        Location tmp2 = null;
        Location tmp3 = null;
        double tmp_distance = 0.0;
        double tmp_distance2 = 0.0;
        double tmp_distance3 = 0.0;
        double min_distance = Double.MAX_VALUE;
        while (front.hasNext()) {
            last = current;
            current = front.next();
            tmp = last;
            tmp2 = current;
            while (tmp.getDistance2D(tmp2) > 5.0) {
                tmp3 = tmp2.sub(tmp).scale(0.5).add(tmp);
                tmp_distance = this.getSailDistance(location, tmp);
                tmp_distance2 = this.getSailDistance(location, tmp2);
                tmp_distance3 = this.getSailDistance(location, tmp3);
                if (tmp_distance2 < tmp_distance) {
                    tmp = tmp2;
                    tmp_distance = tmp_distance2;
                }
                if (tmp_distance3 > tmp_distance) break;
                tmp2 = tmp3;
                tmp_distance2 = tmp_distance3;
            }
            if (tmp_distance2 < tmp_distance) {
                tmp_distance = tmp_distance2;
                tmp = tmp2;
            }
            if (!(tmp_distance < min_distance)) continue;
            min_distance = tmp_distance;
            best = tmp;
        }
        return new LocationWithDistance(min_distance, best);
    }

    public LocationPair getClosestSailDistance(List<Location> borderA, List<Location> borderB) {
        double min_distance = Double.MAX_VALUE;
        LocationPair best = null;
        if (borderA == null || borderA.size() == 0) {
            return null;
        }
        Iterator<Location> front = borderA.iterator();
        Location current = front.next();
        Location last = null;
        LocationPair borderA_borderB = new LocationPair(current, borderB.get(0));
        LocationPair borderA_borderB_2 = new LocationPair(current, borderB.get(0));
        LocationPair borderA_borderB_candidate = null;
        double tmp_distance = 0.0;
        double tmp_distance2 = 0.0;
        double tmp_distance3 = 0.0;
        while (front.hasNext()) {
            last = current;
            current = front.next();
            borderA_borderB.A = last;
            borderA_borderB_2.A = current;
            LocationWithDistance loc_with_dist = this.getClosestSailTarget(borderA_borderB.A, borderB);
            tmp_distance = loc_with_dist.getDistance();
            borderA_borderB.B = loc_with_dist.getLocation();
            loc_with_dist = this.getClosestSailTarget(borderA_borderB_2.A, borderB);
            tmp_distance2 = loc_with_dist.getDistance();
            borderA_borderB_2.B = loc_with_dist.getLocation();
            while (borderA_borderB.A.getDistance2D(borderA_borderB_2.A) > 5.0) {
                Location half_way = borderA_borderB_2.A.sub(borderA_borderB.A).scale(0.5).add(borderA_borderB.A);
                loc_with_dist = this.getClosestSailTarget(half_way, borderB);
                borderA_borderB_candidate = new LocationPair(half_way, loc_with_dist.getLocation());
                tmp_distance3 = loc_with_dist.getDistance();
                if (tmp_distance2 < tmp_distance) {
                    borderA_borderB = borderA_borderB_2;
                    tmp_distance = tmp_distance2;
                }
                if (tmp_distance3 > tmp_distance) break;
                borderA_borderB_2 = borderA_borderB_candidate;
                tmp_distance2 = tmp_distance3;
            }
            if (tmp_distance2 < tmp_distance) {
                tmp_distance = tmp_distance2;
                borderA_borderB = borderA_borderB_2;
            }
            if (!(tmp_distance < min_distance)) continue;
            min_distance = tmp_distance;
            best = borderA_borderB;
        }
        System.gc();
        return best;
    }

    public boolean isValidTerritory(int teamId, float longitude, float latitude, boolean seaArea) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsValidTerritory(), new Object[]{teamId, Float.valueOf(longitude), Float.valueOf(latitude), seaArea});
        return (Boolean)container.syncCallInMainThread();
    }

    public boolean isValidTerritory(int teamId, double longitude, double latitude, boolean seaArea) {
        return this.isValidTerritory(teamId, (float)longitude, (float)latitude, seaArea);
    }

    public boolean isValidTerritory(int teamId, Location location, boolean seaArea) {
        return this.isValidTerritory(teamId, (float)location.getX(), (float)location.getY(), seaArea);
    }

    public boolean isBorder(float longitude, float latitude) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsBorder(), new Object[]{Float.valueOf(longitude), Float.valueOf(latitude)});
        return (Boolean)container.syncCallInMainThread();
    }

    public int getTerritoryId(float longitude, float latitude) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetTerritoryId(), new Object[]{Float.valueOf(longitude), Float.valueOf(latitude)});
        return (Integer)container.syncCallInMainThread();
    }

    public int getTerritoryId(double longitude, double latitude) {
        return this.getTerritoryId((float)longitude, (float)latitude);
    }

    public int getOwnTeamId() {
        return this.ownTeamId;
    }

    public int[] getTeamIds() {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetTeamIds(), null);
        return (int[])container.syncCallInMainThread();
    }

    public SortedMap<Integer, LinkedList<Integer>> getAlliancesWithTeamIds() {
        int[] teams = this.getTeamIds();
        TreeMap<Integer, LinkedList<Integer>> alliances = new TreeMap<Integer, LinkedList<Integer>>();
        for (int i : teams) {
            int alliance = this.getAllianceId(i);
            LinkedList<Integer> list = (LinkedList<Integer>)alliances.get(alliance);
            if (list == null) {
                list = new LinkedList<Integer>();
            }
            list.add(i);
            alliances.put(alliance, list);
        }
        return alliances;
    }

    public int[] getEnemyTeamIds() {
        return this.enemyIds;
    }

    public SortedMap<Integer, List<Integer>> getEnemiesCityIds() {
        return Collections.unmodifiableSortedMap(this.enemiesCityIds);
    }

    public List<Integer> getEnemyCityIds() {
        ArrayList<Integer> enemyCityIds = new ArrayList<Integer>(20);
        for (List<Integer> ids : this.enemiesCityIds.values()) {
            for (int id : ids) {
                enemyCityIds.add(id);
            }
        }
        return enemyCityIds;
    }

    public List<Integer> getEnemyCityIds(int enemyId) {
        return Collections.unmodifiableList((List)this.enemiesCityIds.get(enemyId));
    }

    public int getTeamTerritoriesCount(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetTeamTerritoriesCount(), new Object[]{teamId});
        return (Integer)container.syncCallInMainThread();
    }

    public int[] getTeamTerritories(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetTeamTerritories(), new Object[]{teamId});
        return (int[])container.syncCallInMainThread();
    }

    public int[] getOwnTeamTerritories() {
        return this.getTeamTerritories(this.getOwnTeamId());
    }

    public int getAllianceId(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetAllianceId(), new Object[]{teamId});
        return (Integer)container.syncCallInMainThread();
    }

    public int getDesiredGameSpeed(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetDesiredGameSpeed(), new Object[]{teamId});
        return (Integer)container.syncCallInMainThread();
    }

    public int getEnemyKills(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetEnemyKills(), new Object[]{teamId});
        return (Integer)container.syncCallInMainThread();
    }

    public int getFriendlyDeaths(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetFriendlyDeaths(), new Object[]{teamId});
        return (Integer)container.syncCallInMainThread();
    }

    public int getCollateralDamage(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetCollateralDamage(), new Object[]{teamId});
        return (Integer)container.syncCallInMainThread();
    }

    public String getTeamName(int teamId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetTeamName(), new Object[]{teamId});
        return (String)container.syncCallInMainThread();
    }

    public boolean isSharingRadar(int teamId1, int teamId2) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsSharingRadar(), new Object[]{teamId1, teamId2});
        return (Boolean)container.syncCallInMainThread();
    }

    public boolean isCeaseFire(int teamId1, int teamId2) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.IsCeaseFire(), new Object[]{teamId1, teamId2});
        return (Boolean)container.syncCallInMainThread();
    }

    public Location getFleetMemberOffset(int memberCount, int memberId) {
        return this.fleetMemberOffsets[memberCount - 1][memberId];
    }

    private Location getFleetMemberOffsetWorker(int memberCount, int memberId) {
        if (memberCount <= 0 || memberId >= memberCount) {
            throw new InvalidParameterException("GetFleetMemberOffset requires memberCount > 0 && memberId < membercount. memberCount: " + memberCount + " memberId: " + memberId);
        }
        return new Location(JBot.GetFleetMemberOffset(memberCount, memberId));
    }

    public boolean getRunning() {
        return this.gameRunning.getFlag();
    }

    public boolean isValidFleetPlacement(Location placement, int fleetSize) {
        for (int i = 0; i < fleetSize; ++i) {
            Location offset = this.getFleetMemberOffset(fleetSize, i);
            if (this.isValidPlacementLocation(placement.getX() + offset.getX(), placement.getY() + offset.getY(), UnitType.BATTLE_SHIP)) continue;
            return false;
        }
        return true;
    }

    private double getFleetDiameterWorker(int fleetSize) {
        double max = 0.0;
        for (int i = 0; i < fleetSize; ++i) {
            Location offset = this.getFleetMemberOffset(fleetSize, i);
            double length = offset.getLength();
            if (!(max < length)) continue;
            max = length;
        }
        return max + 1.0;
    }

    public double getFleetDiameter(int fleetSize) {
        return this.fleetDiameters[fleetSize - 1];
    }

    public LinkedList<Integer> getAllEnemyTerritories() {
        LinkedList<Integer> territoryIds = new LinkedList<Integer>();
        for (int enemyId : this.getEnemyTeamIds()) {
            for (int territoryId : this.getTeamTerritories(enemyId)) {
                territoryIds.add(territoryId);
            }
        }
        return territoryIds;
    }

    public boolean isValidStructureLocation(Location placement) {
        return this.isValidPlacementLocation(placement.getX(), placement.getY(), UnitType.AIR_BASE);
    }

    public int getNukeSupply(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetNukeSupply(), new Object[]{unitId});
        return (Integer)container.syncCallInMainThread();
    }

    public UnitType getType(int unitId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetType(), new Object[]{unitId});
        return UnitType.getEnum((Integer)container.syncCallInMainThread());
    }

    public int getStateCount(int unitId, IState state) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetStateCount(), new Object[]{unitId, state.getStateId()});
        return (Integer)container.syncCallInMainThread();
    }

    public int getStateCount(int unitId, int stateId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetStateCount(), new Object[]{unitId, stateId});
        return (Integer)container.syncCallInMainThread();
    }

    public int[] getTerritoryOwners() {
        return this.territoryOwners;
    }

    public int getTerritoryOwner(Location center) {
        return this.getTerritoryOwner(center.getX(), center.getY());
    }

    public int getTerritoryOwner(double longitude, double latitude) {
        return this.getTerritoryOwner(this.getTerritoryId(longitude, latitude));
    }

    public int getTerritoryOwner(int territoryId) {
        if (territoryId == -1) {
            return -1;
        }
        return this.territoryOwners[territoryId];
    }

    public int getTerritoryId(Location location) {
        return this.getTerritoryId(location.getX(), location.getY());
    }

    public int getTerritoriesCount() {
        return 6;
    }

    public int[] getCityIds() {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetCityIds(), null);
        return (int[])container.syncCallInMainThread();
    }

    public Location getObjectLocation(int objectId) {
        SyncMethodExecContainer container = new SyncMethodExecContainer(JBotMethodsRepository.GetLongitude(), new Object[]{objectId});
        float longitude = ((Float)container.syncCallInMainThread()).floatValue();
        container = new SyncMethodExecContainer(JBotMethodsRepository.GetLatitude(), new Object[]{objectId});
        float latitude = ((Float)container.syncCallInMainThread()).floatValue();
        return new Location((double)longitude, (double)latitude);
    }

    public boolean canCreateFleet(UnitType[] ships) {
        Hashtable<Integer, Integer> table = new Hashtable<Integer, Integer>();
        for (UnitType type : ships) {
            if (table.containsKey(type.id)) {
                int remaining;
                int newCount = (Integer)table.get(type.id) + 1;
                if (newCount > (remaining = this.getRemainingUnits(type))) {
                    return false;
                }
                table.put(type.id, newCount);
                continue;
            }
            table.put(type.id, 1);
        }
        table.clear();
        return true;
    }

    public double getSubNukeRange() {
        return 45.0;
    }

    public double getBomberRange() {
        return 180.0;
    }

    public double getRadarRange() {
        return 30.0;
    }

    public double getFighterRange() {
        return 40.0;
    }

    public double getSiloRange() {
        return 30.0;
    }

    public DefConLocation getCitiesGravityCenter(int teamId) {
        Location sum = new Location();
        List cityList = teamId == this.getOwnTeamId() ? this.ownCityIds : (List)this.enemiesCityIds.get(teamId);
        if (cityList == null) {
            PogamutJBotSupport.writeToConsole("cityList is empty: " + teamId + " " + this.enemiesCityIds);
        }
        Iterator i$ = cityList.iterator();
        while (i$.hasNext()) {
            int cityId = (Integer)i$.next();
            DefConLocation location = this.getCityLocation(cityId);
            sum.x += location.getX();
            sum.y += location.getY();
        }
        return new DefConLocation(sum.scale(1.0 / (double)cityList.size()));
    }

    public DefConLocation getCityLocation(int cityId) {
        return new DefConLocation((Location)this.cityLocations.get(cityId));
    }

    public class LocationPair {
        public Location A;
        public Location B;

        public LocationPair(Location A, Location B) {
            this.A = A;
            this.B = B;
        }
    }

    private static final class LocationWithDistance {
        private double distance;
        private Location location;

        public LocationWithDistance(double distance, Location location) {
            this.distance = distance;
            this.location = location;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final void setDistance(double distance) {
            this.distance = distance;
        }

        public final Location getLocation() {
            return this.location;
        }

        public final void setLocation(Location location) {
            this.location = location;
        }
    }
}

