package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGrid;

/**
 * Experimental grid implementation.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 * @param <AGENT>
 */
public class BasicGrid<AGENT extends DefConAgent>
		extends SensorModule<AGENT>
		implements IGrid<SymmetricGridCell, SymmetricGridCellId, BasicGridIterator> {


	protected float gridXStart;
	protected float gridYStart;
	protected float gridStep;
	protected int gridXCellCount;
	protected int gridYCellCount;
	
	// separator is x then y then x and so on, until epsilon is hit

		
	public BasicGrid(AGENT agent, float gridStep, int gridXCellCount, int gridYCellCount,
			int gridXStart, int gridYStart) {
		this(agent, gridStep, gridXCellCount, gridYCellCount, gridXStart, gridYStart, null);
	}
		
	public BasicGrid(DefConAgent agent, float gridStep, int gridXCellCount, int gridYCellCount,
			int gridXStart, int gridYStart, Logger log) {
		super((AGENT) agent, log);
		initGrid(gridStep, gridXCellCount, gridYCellCount, gridXStart, gridYStart);
	}
	
	protected void initGrid(float gridStep, int gridXCellCount, int gridYCellCount,
			float gridXStart, float gridYStart) {
		
		this.gridStep = gridStep;
		this.gridXCellCount = gridXCellCount;
		this.gridYCellCount = gridYCellCount;
		this.gridXStart = gridXStart;
		this.gridYStart = gridYStart;
		//SymmetricGridCell.setGrid(this);
	}

	@Override
	public SymmetricGridCell getCell(SymmetricGridCellId cellId) {
		return new SymmetricGridCell(cellId);
	}

	
	/**
	 * Assigns cell to a given cell position.
	 * @param cellId intended position of a cell
	 * @param cell the cell itself
	 * 
	 * @return true iff the assignment was successful.
	 */	
	/*
	@Override
	public boolean setCell(SymmetricGridCellId cellId, SymmetricGridCell cell) {
		CellIndices indices = getCellIndices(cellId);
		grid[indices.x][indices.y] = cell;
		return true;
	}*/
		
	public class CellIndices {
		private float x;
		private float y;
		
		public CellIndices(float x, float y) {
			this.x = x;
			this.y = y;
		}
		
		public CellIndices(CellIndices source) {
			x = source.getX();
			y = source.getY();
		}

		public float getX() {
			return x;
		}
		
		public float getY() {
			return y;
		}
		
		public float setX(int x) {
			return this.x = x;
		}
		
		public float setY(int y) {
			return this.y = y;
		}
		
		public CellIndices setIndices(SymmetricGridCellId cellId, BasicGrid grid) {
			x = (float)(Math.floor((cellId.getX() - gridXStart)/gridStep)*gridStep) + gridXStart;
			y = (float)(Math.floor((cellId.getY() - gridYStart)/gridStep)*gridStep) + gridYStart;
			return this;
		}

		@Override
		public boolean equals(Object o) {
			return (o instanceof BasicGrid.CellIndices) &&
				((CellIndices)o).getX() == x && ((CellIndices)o).getY() == y; 
		}
	}
	
	public CellIndices getCellIndices(SymmetricGridCellId cellId) {
		return new CellIndices((int)(Math.floor((cellId.getX() - gridXStart)/gridStep) + gridXStart),
		 (int)((Math.floor(cellId.getY() - gridYStart)/gridStep) + gridYStart));		
	}

	@Override
	public DefConWorldView getWorldView() {
		return (DefConWorldView) worldView;
	}

	public float getLowerXBound() {
		return gridXStart;
	}

	public float getUpperXBound() {
		return gridXCellCount * gridStep  - gridXStart;
	}
	
	public float getLowerYBound() {
		return gridYStart;
	}

	public float getUpperYBound() {
		return gridYCellCount * gridStep  - gridYStart;
	}	

	public float getGridStep() {
		return gridStep;
	}
		
	public int getXCount() {
		return gridXCellCount;
	}
	
	public int getYCount() {
		return gridYCellCount;
	}
	
	public SymmetricGridCell getCell(float x, float y) {
		if (y < gridYStart || y >= gridYCellCount - gridYStart)
			return null;
		
		return new SymmetricGridCell(new SymmetricGridCellId(
				(x - gridXStart)/gridStep % gridXCellCount + gridXStart, y));
	}

	@Override
	public BasicGridIterator getIterator(SymmetricGridCellId cellId) {
		return new BasicGridIterator(cellId, this);	
	}
}
