/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.closestpoints;

import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import cz.cuni.amis.pogamut.defcon.utils.closestpoints.ClosestPointsManager;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeBFSIterator;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.WidthLimitedQuadTreePostorderIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ClosestPointsLookUp {
    private GameInfo gameInfo;
    private Logger log;
    private SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> enemyQuadTrees;
    private SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> ownQuadTrees;
    private boolean isFinished = false;
    private Iterator<Map.Entry<Integer, Pair<List<QuadTree>, List<QuadTree>>>> enemyTerritoryIterator;
    private Iterator<QuadTree> enemyQuadTreeIterator;
    private Iterator<Map.Entry<Integer, Pair<List<QuadTree>, List<QuadTree>>>> ownTerritoriesIterator;
    private Map.Entry<Integer, Pair<List<QuadTree>, List<QuadTree>>> enemyTerritory;
    private QuadTree enemyQuadTree;
    private int enemyId;
    private final SortedMap<Integer, SortedMap<Integer, List<ClosestPoints>>> closestPointsToEnemyTerritories = new TreeMap<Integer, SortedMap<Integer, List<ClosestPoints>>>();
    private SortedMap<Integer, List<ClosestPoints>> closestPointsToAnEnemyTerritory;
    private int pointsLimit;

    public static final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> prepareEnemyQuadTrees(SortedMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>> enemyQuadTrees) {
        TreeMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> output = new TreeMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>();
        for (SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> territory : enemyQuadTrees.values()) {
            output.putAll(territory);
        }
        return output;
    }

    public ClosestPointsLookUp(GameInfo gameInfo, Logger log, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> enemyQuadTrees, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> ownQuadTrees) {
        this(gameInfo, log, enemyQuadTrees, ownQuadTrees, 20);
    }

    public ClosestPointsLookUp(GameInfo gameInfo, Logger log, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> enemyQuadTrees, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> ownQuadTrees, int pointsLimit) {
        this.gameInfo = gameInfo;
        this.log = log;
        this.enemyQuadTrees = enemyQuadTrees;
        this.ownQuadTrees = ownQuadTrees;
        this.enemyTerritoryIterator = enemyQuadTrees.entrySet().iterator();
        this.pointsLimit = pointsLimit;
    }

    public ClosestPointsManager getTickedClosestPoints() {
        this.tickGetClosestPointsWorker();
        return this.isFinished ? new ClosestPointsManager(this.closestPointsToEnemyTerritories, this.log) : null;
    }

    public ClosestPointsManager getClosestPoints() {
        for (Map.Entry<Integer, Pair<List<QuadTree>, List<QuadTree>>> enemy_territory : this.enemyQuadTrees.entrySet()) {
            this.enemyId = this.gameInfo.getTerritoryOwner(enemy_territory.getKey());
            this.closestPointsToAnEnemyTerritory = new TreeMap<Integer, List<ClosestPoints>>();
            this.closestPointsToEnemyTerritories.put(enemy_territory.getKey(), this.closestPointsToAnEnemyTerritory);
            for (QuadTree enemy_sea : (List)enemy_territory.getValue().first) {
                for (Map.Entry<Integer, Pair<List<QuadTree>, List<QuadTree>>> own_territory : this.ownQuadTrees.entrySet()) {
                    List<ClosestPoints> points;
                    if (this.closestPointsToAnEnemyTerritory.containsKey(own_territory.getKey())) {
                        points = (List)this.closestPointsToAnEnemyTerritory.get(own_territory.getKey());
                    } else {
                        points = new ArrayList();
                        this.closestPointsToAnEnemyTerritory.put(own_territory.getKey(), points);
                    }
                    for (QuadTree own_sea : (List)own_territory.getValue().first) {
                        ClosestPoints result = this.findClosestPointsBetweenTwoTrees(enemy_sea, own_sea);
                        if (result == null) continue;
                        boolean found = false;
                        for (ClosestPoints point : points) {
                            if (!point.getTarget().equals(result.getTarget())) continue;
                            found = true;
                            point.addOrigins(result.getCompleteOrigins());
                            break;
                        }
                        if (found) continue;
                        points.add(result);
                    }
                }
            }
        }
        return new ClosestPointsManager(this.closestPointsToEnemyTerritories, this.log);
    }

    private ClosestPoints findClosestPointsBetweenTwoTrees(QuadTree enemyTerritory, QuadTree myTerritory) {
        QuadTreeNode outer_closest = null;
        if (enemyTerritory.getRoot().getSize() <= 5.0) {
            return null;
        }
        if (myTerritory.getRoot().getSize() <= this.gameInfo.getFleetDiameter(6)) {
            return null;
        }
        QuadTreeBFSIterator nodeIterator = new QuadTreeBFSIterator(enemyTerritory);
        while (nodeIterator.hasNext()) {
            QuadTreeNode node = (QuadTreeNode)nodeIterator.next();
            if (!this.gameInfo.isValidTerritory(this.enemyId, node.getCenter(), true)) continue;
            outer_closest = node;
            break;
        }
        if (outer_closest == null) {
            return null;
        }
        ClosestPoints closest = new ClosestPoints(new DefConLocation(outer_closest.getCenter()));
        PriorityQueue<DistanceOrigin> origins = new PriorityQueue<DistanceOrigin>();
        WidthLimitedQuadTreePostorderIterator inner_iter = new WidthLimitedQuadTreePostorderIterator(myTerritory, this.gameInfo.getFleetDiameter(6));
        while (inner_iter.hasNext()) {
            QuadTreeNode inner_node = inner_iter.next();
            if (!inner_node.isLabeled() || !this.gameInfo.isValidFleetPlacement(inner_node.getCenter(), 6)) continue;
            double dist = this.gameInfo.getSailDistance(inner_node.getCenter(), outer_closest.getCenter());
            origins.add(new DistanceOrigin(dist, new DefConLocation(inner_node.getCenter())));
        }
        closest.initOrigins(origins);
        return closest;
    }

    private void tickGetClosestPointsWorker() {
        if (this.ownTerritoriesIterator != null && this.ownTerritoriesIterator.hasNext()) {
            List<ClosestPoints> points;
            Map.Entry<Integer, Pair<List<QuadTree>, List<QuadTree>>> ownTerritory = this.ownTerritoriesIterator.next();
            this.log.info("MyTerritory: " + ownTerritory.getKey());
            if (!this.closestPointsToAnEnemyTerritory.containsKey(ownTerritory.getKey())) {
                points = new ArrayList();
                this.closestPointsToAnEnemyTerritory.put(ownTerritory.getKey(), points);
            } else {
                points = (List)this.closestPointsToAnEnemyTerritory.get(ownTerritory.getKey());
            }
            for (QuadTree ownSea : (List)ownTerritory.getValue().first) {
                this.log.info("MyQTree");
                ClosestPoints return_value = this.findClosestPointsBetweenTwoTrees(this.enemyQuadTree, ownSea);
                if (return_value == null) continue;
                boolean found = false;
                for (ClosestPoints point : points) {
                    if (!point.getTarget().equals(return_value.getTarget())) continue;
                    found = true;
                    point.addOrigins(return_value.getCompleteOrigins());
                    break;
                }
                if (found) continue;
                points.add(return_value);
            }
            return;
        }
        if (this.enemyQuadTreeIterator != null && this.enemyQuadTreeIterator.hasNext()) {
            this.enemyQuadTree = this.enemyQuadTreeIterator.next();
            this.log.info("EnemyQTree " + this.enemyQuadTree.getRoot().getCenter());
            this.ownTerritoriesIterator = this.ownQuadTrees.entrySet().iterator();
            this.tickGetClosestPointsWorker();
        } else if (this.enemyTerritoryIterator.hasNext()) {
            this.enemyTerritory = this.enemyTerritoryIterator.next();
            this.enemyId = this.gameInfo.getTerritoryOwner(this.enemyTerritory.getKey());
            this.log.info("EnemyTerritory " + this.enemyTerritory.getKey() + " of " + this.enemyId);
            this.enemyQuadTreeIterator = ((List)this.enemyTerritory.getValue().first).iterator();
            this.closestPointsToAnEnemyTerritory = new TreeMap<Integer, List<ClosestPoints>>();
            this.closestPointsToEnemyTerritories.put(this.enemyTerritory.getKey(), this.closestPointsToAnEnemyTerritory);
            this.tickGetClosestPointsWorker();
        }
        if (!(this.enemyTerritoryIterator.hasNext() || this.enemyQuadTreeIterator != null && this.enemyQuadTreeIterator.hasNext() || this.ownTerritoriesIterator != null && this.ownTerritoriesIterator.hasNext())) {
            this.isFinished = true;
        }
    }

    public class DistanceOrigin
    implements Comparable<DistanceOrigin> {
        public double distance;
        public DefConLocation origin;

        public DistanceOrigin(double distance, DefConLocation origin) {
            this.distance = distance;
            this.origin = origin;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final DefConLocation getOrigin() {
            return this.origin;
        }

        @Override
        public int compareTo(DistanceOrigin o) {
            return Double.compare(this.distance, o.distance);
        }
    }

    public class ClosestPoints {
        private DefConLocation target;
        private List<DistanceOrigin> completeOrigins;
        private List<DefConLocation> origins;

        public ClosestPoints(DefConLocation target) {
            this.completeOrigins = new ArrayList<DistanceOrigin>(ClosestPointsLookUp.this.pointsLimit);
            this.origins = new ArrayList<DefConLocation>(ClosestPointsLookUp.this.pointsLimit);
            this.target = target;
        }

        public final DefConLocation getTarget() {
            return this.target;
        }

        public final List<DistanceOrigin> getCompleteOrigins() {
            return this.completeOrigins;
        }

        public final List<DefConLocation> getOrigins() {
            return this.origins;
        }

        public void initOrigins(Queue<DistanceOrigin> origins) {
            if (origins == null) {
                throw new IllegalArgumentException("Origins cannot be null.");
            }
            while (this.completeOrigins.size() < ClosestPointsLookUp.this.pointsLimit && !origins.isEmpty()) {
                DistanceOrigin origin = origins.poll();
                this.completeOrigins.add(origin);
                this.origins.add(origin.getOrigin());
            }
        }

        public void addOrigins(List<DistanceOrigin> origins) {
            if (origins == null) {
                throw new IllegalArgumentException("Origins cannot be null.");
            }
            ArrayList<DistanceOrigin> tmp = new ArrayList<DistanceOrigin>(10);
            this.origins.clear();
            int completeOriginsIndex = 0;
            int originsIndex = 0;
            for (int counter = 0; counter < ClosestPointsLookUp.this.pointsLimit && originsIndex < origins.size() && completeOriginsIndex < this.completeOrigins.size(); ++counter) {
                DistanceOrigin origin;
                if (origins.get(originsIndex).compareTo(this.completeOrigins.get(completeOriginsIndex)) < 0) {
                    origin = origins.get(originsIndex);
                    ++originsIndex;
                } else {
                    origin = this.completeOrigins.get(completeOriginsIndex);
                    ++completeOriginsIndex;
                }
                tmp.add(origin);
                this.origins.add(origin.getOrigin());
            }
            this.completeOrigins = tmp;
        }
    }
}

