package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridCellId;

/**
 * Id for a single square cell of the experimental grid.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class SymmetricGridCellId implements IGridCellId {

	protected final Location location;
	
	public SymmetricGridCellId(float x, float y) {
		location = new Location(x, y);
	}
	
	public SymmetricGridCellId(Location location) {
		this.location = location;
	}	
	
	@Override
	public float getX() {
		return (float)location.getX();
	}
	
	@Override
	public float getY() {
		return (float)location.getY();
	}
	
	@Override
	public Location getLocation() {
		return location;
	}
	
	@Override
	public void setX(float x) {
		location.x = x;
	}
	
	@Override
	public void setY(float y) {
		location.y = y;
	}
	
	@Override
	public void setLocation(float x, float y) {
		location.x = x;
		location.y = y;
	}
	
	@Override
	public void setLocation(Location location) {
		this.location.x = location.x;
		this.location.y = location.y;
	}	
}
