/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.BuildingPlacementQuadTreeLabellingMethod;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeLabeler;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.UnitPlacementQuadTreeLabellingMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class QuadTreesManager {
    private final SortedMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>> enemyQuadTrees = new TreeMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>>();
    private final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> ownQuadTrees = new TreeMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>();

    public QuadTreesManager(SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> ownTerritories, SortedMap<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> enemyTerritories, DefConWorldView worldview) {
        this(ownTerritories, enemyTerritories, worldview, null);
    }

    public QuadTreesManager(SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> ownTerritories, SortedMap<Integer, SortedMap<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>>> enemyTerritories, DefConWorldView worldview, Logger log) {
        for (Map.Entry<Integer, Pair<List<List<DefConLocation>>, List<List<DefConLocation>>>> entry : ownTerritories.entrySet()) {
            QuadTree tree;
            Pair qTreesPair = new Pair();
            this.ownQuadTrees.put(entry.getKey(), qTreesPair);
            ArrayList<QuadTree> qTreesList = new ArrayList<QuadTree>();
            qTreesPair.first = qTreesList;
            for (List sea : (List)entry.getValue().first) {
                tree = new QuadTree(sea);
                QuadTreeLabeler.label(tree, new UnitPlacementQuadTreeLabellingMethod(worldview, log));
                qTreesList.add(tree);
            }
            qTreesList = new ArrayList();
            qTreesPair.second = qTreesList;
            for (List land : (List)entry.getValue().second) {
                tree = new QuadTree(land);
                QuadTreeLabeler.label(tree, new BuildingPlacementQuadTreeLabellingMethod(worldview, log));
                qTreesList.add(tree);
            }
        }
        for (Map.Entry<Integer, Object> entry : enemyTerritories.entrySet()) {
            TreeMap enemy_territories = new TreeMap();
            this.enemyQuadTrees.put(entry.getKey(), enemy_territories);
            for (Map.Entry territory : ((SortedMap)entry.getValue()).entrySet()) {
                QuadTree tree;
                Pair qTreesPair = new Pair();
                enemy_territories.put(territory.getKey(), qTreesPair);
                ArrayList<QuadTree> qTreesList = new ArrayList<QuadTree>();
                qTreesPair.first = qTreesList;
                for (List sea : (List)((Pair)territory.getValue()).first) {
                    tree = new QuadTree(sea);
                    qTreesList.add(tree);
                }
                qTreesList = new ArrayList();
                qTreesPair.second = qTreesList;
                for (List land : (List)((Pair)territory.getValue()).second) {
                    tree = new QuadTree(land);
                    qTreesList.add(tree);
                }
            }
        }
    }

    public final SortedMap<Integer, SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>>> getEnemyQuadTrees() {
        return Collections.unmodifiableSortedMap(this.enemyQuadTrees);
    }

    public final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> getEnemyQuadTrees(int enemyId) {
        return Collections.unmodifiableSortedMap((SortedMap)this.enemyQuadTrees.get(enemyId));
    }

    public final SortedMap<Integer, Pair<List<QuadTree>, List<QuadTree>>> getOwnQuadTrees() {
        return Collections.unmodifiableSortedMap(this.ownQuadTrees);
    }
}

