/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.RectangularFillTester;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuadTreeNode {
    private final QuadTree quadTree;
    private final double EPSILON = 1.0;
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    private QuadTreeNode[] nodes = null;
    private QuadTreeNode parent;
    private LinkedList<List<Location>> subList;
    private Location center;
    private double inner_side;
    private boolean label = false;
    private static final Pattern pattern = Pattern.compile("\n");

    public QuadTreeNode(QuadTree quadTree, double x1, double y1, double x2, double y2, QuadTreeNode parent, List<List<Location>> subList) {
        this.quadTree = quadTree;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.parent = parent;
        this.inner_side = (x2 - x1) / 2.0;
        this.center = new Location(x1 + this.inner_side, y1 + this.inner_side);
        this.subList = this.findVerticesFormingIntersectingLines(subList);
        if (this.inner_side < 1.0) {
            return;
        }
        this.subdivide();
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getY2() {
        return this.y2;
    }

    private void subdivide() {
        if (this.subList.isEmpty()) {
            return;
        }
        if (RectangularFillTester.isSameRectangle(this.subList.getFirst(), this.x1, this.y1, this.x2, this.y2)) {
            return;
        }
        this.nodes = new QuadTreeNode[4];
        this.nodes[0] = new QuadTreeNode(this.quadTree, this.x1, this.y1, this.x1 + this.inner_side, this.y1 + this.inner_side, this, this.subList);
        this.nodes[1] = new QuadTreeNode(this.quadTree, this.x1 + this.inner_side, this.y1, this.x2, this.y1 + this.inner_side, this, this.subList);
        this.nodes[2] = new QuadTreeNode(this.quadTree, this.x1, this.y1 + this.inner_side, this.x1 + this.inner_side, this.y2, this, this.subList);
        this.nodes[3] = new QuadTreeNode(this.quadTree, this.x1 + this.inner_side, this.y1 + this.inner_side, this.x2, this.y2, this, this.subList);
    }

    private LinkedList<List<Location>> findVerticesFormingIntersectingLines(List<List<Location>> sections) {
        LinkedList<List<Location>> filteredVertices = new LinkedList<List<Location>>();
        if (sections.isEmpty()) {
            return filteredVertices;
        }
        LinkedList<Location> current = new LinkedList<Location>();
        for (List<Location> vertices : sections) {
            Location last = null;
            for (Location vertex : vertices) {
                if (last == null) {
                    last = vertex;
                    continue;
                }
                if (this.lineIntersectsRectangle(last.getX(), last.getY(), vertex.getX(), vertex.getY(), this.x1, this.y1, this.x2, this.y2)) {
                    if (current.isEmpty() || current.getLast() != last) {
                        current.add(last);
                    }
                    current.add(vertex);
                    this.label = true;
                } else if (!current.isEmpty()) {
                    filteredVertices.add(current);
                    current = new LinkedList();
                }
                last = vertex;
            }
            if (current.isEmpty()) continue;
            filteredVertices.add(current);
            current = new LinkedList();
        }
        if (!filteredVertices.isEmpty() && ((LinkedList)filteredVertices.getFirst()).getFirst() == ((LinkedList)filteredVertices.getLast()).getLast()) {
            LinkedList tmp = (LinkedList)filteredVertices.pollLast();
            tmp.pollLast();
            if (!filteredVertices.isEmpty()) {
                tmp.addAll((Collection)filteredVertices.pollFirst());
            }
            filteredVertices.addFirst(tmp);
        }
        return filteredVertices;
    }

    private boolean pointInRectangle(double px, double py, double x1, double y1, double x2, double y2) {
        return px >= x1 && px < x2 && py >= y1 && py < y2;
    }

    private boolean lineIntersectsRectangle(double lx1, double ly1, double lx2, double ly2, double x1, double y1, double x2, double y2) {
        if (this.pointInRectangle(lx1, ly1, x1, y1, x2, y2)) {
            return true;
        }
        if (this.pointInRectangle(lx2, ly2, x1, y1, x2, y2)) {
            return true;
        }
        if (ly2 - ly1 == 0.0) {
            return y1 <= ly1 && ly1 < y2 && (lx1 < x1 && x1 <= lx2 || lx2 < x1 && x1 <= lx1);
        }
        if (lx2 - lx1 == 0.0) {
            return x1 <= lx1 && lx1 < x2 && (ly1 < y1 && y1 <= ly2 || ly2 < y1 && y1 <= ly1);
        }
        double t = (lx2 - lx1) / (ly2 - ly1);
        double x = 0.0;
        double y = 0.0;
        if ((ly1 > y1 && ly2 <= y1 || ly1 <= y1 && ly2 > y1) && x1 <= (x = lx1 + t * (y1 - ly1)) && x < x2) {
            return true;
        }
        if ((ly1 > y2 && ly2 <= y2 || ly1 <= y2 && ly2 > y2) && x1 <= (x = lx1 + t * (y2 - ly1)) && x < x2) {
            return true;
        }
        return (lx1 > x1 && lx2 <= x1 || lx1 <= x1 && lx2 > x1) && y1 <= (y = ly1 + (x1 - lx1) / t) && y < y2;
    }

    public Location getCenter() {
        return this.center;
    }

    public final QuadTreeNode getFirst() {
        return this.nodes[0];
    }

    public final QuadTreeNode getSecond() {
        return this.nodes[1];
    }

    public final QuadTreeNode getThird() {
        return this.nodes[2];
    }

    public final QuadTreeNode getFourth() {
        return this.nodes[3];
    }

    public final QuadTreeNode[] getNodes() {
        return this.nodes;
    }

    public final QuadTreeNode getParent() {
        return this.parent;
    }

    public String toString() {
        Matcher matcher;
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("o{%.1f, %.1f, %.1f, %.1f}[", this.x1, this.y1, this.x2, this.y2));
        builder.append(this.label);
        if (this.nodes == null) {
            builder.append("]");
            return builder.toString();
        }
        builder.append("\n");
        if (this.nodes[0] != null) {
            matcher = pattern.matcher(this.nodes[0].toString());
            builder.append("    ");
            builder.append(matcher.replaceAll("\n    "));
            builder.append("\n");
        }
        if (this.nodes[1] != null) {
            matcher = pattern.matcher(this.nodes[1].toString());
            builder.append("    ");
            builder.append(matcher.replaceAll("\n    "));
            builder.append("\n");
        }
        if (this.nodes[2] != null) {
            matcher = pattern.matcher(this.nodes[2].toString());
            builder.append("    ");
            builder.append(matcher.replaceAll("\n    "));
            builder.append("\n");
        }
        if (this.nodes[3] != null) {
            matcher = pattern.matcher(this.nodes[3].toString());
            builder.append("    ");
            builder.append(matcher.replaceAll("\n    "));
            builder.append("\n");
        }
        if (this.subList != null && !this.subList.isEmpty()) {
            builder.append("    ");
            builder.append("{");
            builder.append(this.subList.toString());
            builder.append("}\n");
        }
        builder.append("]");
        return builder.toString();
    }

    public final boolean isLabeled() {
        return this.label;
    }

    public final void setLabel(boolean value) {
        this.label = value;
    }

    public double getSize() {
        return Math.abs(this.x2 - this.x1);
    }
}

