/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.bitmap;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.communication.worldview.AbstractMapSource;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class BitmapMapSource
extends AbstractMapSource {
    private final BufferedImage[] territories;
    private final BufferedImage sailable;
    private final SortedMap<Integer, BufferedImage> ownTerritories = new TreeMap<Integer, BufferedImage>();
    private final SortedMap<Integer, SortedMap<Integer, BufferedImage>> enemyTerritories = new TreeMap<Integer, SortedMap<Integer, BufferedImage>>();
    private final int LAND_THRESHOLD = 200;
    private final int SEA_THRESHOLD = 100;
    private final double X_SPAN = 180.0;
    private final double Y_SPAN = 100.0;
    private Logger log;

    public BitmapMapSource(BufferedImage[] territories, int[] ownTerritories, SortedMap<Integer, int[]> enemyIdsAndTerritories, BufferedImage sailable) {
        this(territories, ownTerritories, enemyIdsAndTerritories, sailable, null);
    }

    public BitmapMapSource(BufferedImage[] territories, int[] ownTerritories, SortedMap<Integer, int[]> enemyIdsAndTerritories, BufferedImage sailable, Logger log) {
        this.log = log;
        this.territories = territories;
        this.sailable = sailable;
        for (int ownTerritory : ownTerritories) {
            this.ownTerritories.put(ownTerritory, territories[ownTerritory]);
        }
        for (int enemyId : enemyIdsAndTerritories.keySet()) {
            TreeMap<Integer, BufferedImage> enemyTerritoriesList = new TreeMap<Integer, BufferedImage>();
            this.enemyTerritories.put(enemyId, enemyTerritoriesList);
            for (int territoryId : (int[])enemyIdsAndTerritories.get(enemyId)) {
                enemyTerritoriesList.put(territoryId, territories[territoryId]);
            }
        }
    }

    public void setTerritorry(int index, BufferedImage bitmap) {
        this.territories[index] = bitmap;
    }

    public BufferedImage getTerritorry(int index) {
        return this.territories[index];
    }

    public SortedMap<Integer, BufferedImage> getOwnTerritories() {
        return Collections.unmodifiableSortedMap(this.ownTerritories);
    }

    private boolean overThresh(BufferedImage image, int x, int y, int overThreshold) {
        return (image.getRGB(x, y) & 0xFF) > overThreshold;
    }

    private boolean underThresh(BufferedImage image, int x, int y, int underThreshold) {
        return !this.overThresh(image, x, y, underThreshold);
    }

    private Pair<Integer, Integer> convertToImageCoords(double x, double y, BufferedImage image) {
        Pair<Integer, Integer> result = new Pair<Integer, Integer>();
        result.first = (int)((x + 180.0) / 360.0 * (double)(image.getWidth() - 1));
        result.second = image.getHeight() - 1 - (int)((y + 100.0) / 200.0 * (double)(image.getHeight() - 1));
        return result;
    }

    @Override
    public boolean hasFlag(double x, double y, BasicFlag flag) {
        if (x < -180.0 || x > 180.0 || y < -100.0 || y > 100.0) {
            return false;
        }
        switch (flag) {
            case SEA: {
                Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, this.sailable);
                return this.overThresh(this.sailable, (Integer)coords.first, (Integer)coords.second, 10);
            }
            case LAND: {
                Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, this.sailable);
                return this.underThresh(this.sailable, (Integer)coords.first, (Integer)coords.second, 5);
            }
            case OWN_TERRITORY: {
                Boolean ok = false;
                for (BufferedImage ownTerritory : this.getOwnTerritories().values()) {
                    Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, ownTerritory);
                    ok = this.overThresh(ownTerritory, (Integer)coords.first, (Integer)coords.second, 10);
                    if (!ok.booleanValue()) continue;
                    break;
                }
                return ok;
            }
            case OWN_PLACEABLE_LAND: {
                Boolean ok = false;
                for (BufferedImage ownTerritory : this.getOwnTerritories().values()) {
                    Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, ownTerritory);
                    ok = this.overThresh(ownTerritory, (Integer)coords.first, (Integer)coords.second, 200);
                    if (!ok.booleanValue()) continue;
                    break;
                }
                return ok;
            }
            case OWN_PLACEABLE_SEA: {
                Boolean ok = false;
                for (BufferedImage ownTerritory : this.getOwnTerritories().values()) {
                    Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, ownTerritory);
                    ok = this.overThresh(ownTerritory, (Integer)coords.first, (Integer)coords.second, 100) && this.underThresh(ownTerritory, (Integer)coords.first, (Integer)coords.second, 200);
                    if (!ok.booleanValue()) continue;
                    break;
                }
                return ok;
            }
            case ENEMY_TERRITORY: {
                Boolean ok = false;
                for (int i = 0; i < this.territories.length; ++i) {
                    if (this.ownTerritories.containsKey(i)) continue;
                    Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, this.territories[i]);
                    ok = this.overThresh(this.territories[i], (Integer)coords.first, (Integer)coords.second, 10);
                    if (ok.booleanValue()) break;
                }
                return ok;
            }
            case ENEMY_PLACEABLE_SEA: {
                Boolean ok = false;
                for (int i = 0; i < this.territories.length; ++i) {
                    if (this.ownTerritories.containsKey(i)) continue;
                    Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, this.territories[i]);
                    ok = this.overThresh(this.territories[i], (Integer)coords.first, (Integer)coords.second, 100) && this.underThresh(this.territories[i], (Integer)coords.first, (Integer)coords.second, 200);
                    if (ok.booleanValue()) break;
                }
                return ok;
            }
            case ENEMY_PLACEABLE_LAND: {
                Boolean ok = false;
                for (int i = 0; i < this.territories.length; ++i) {
                    if (this.ownTerritories.containsKey(i)) continue;
                    Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, this.territories[i]);
                    ok = this.overThresh(this.territories[i], (Integer)coords.first, (Integer)coords.second, 200);
                    if (ok.booleanValue()) break;
                }
                return ok;
            }
        }
        return false;
    }

    @Override
    public boolean hasFlag(Location location, BasicFlag flag) {
        return this.hasFlag(location.getX(), location.getY(), flag);
    }

    @Override
    public boolean hasEnemyTerritoryFlag(Location location, int enemyId) {
        return this.hasEnemyTerritoryFlag(location.getX(), location.getY(), enemyId);
    }

    @Override
    public boolean hasEnemyTerritoryFlag(double x, double y, int enemyId) {
        if (x < -180.0 || x > 180.0 || y < -100.0 || y > 100.0) {
            return false;
        }
        boolean ok = false;
        for (BufferedImage territory : ((SortedMap)this.enemyTerritories.get(enemyId)).values()) {
            Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, territory);
            ok = this.overThresh(territory, (Integer)coords.first, (Integer)coords.second, 100);
            if (!ok) continue;
            break;
        }
        return ok;
    }

    @Override
    public boolean hasEnemyTerritoryFlag(Location location, int enemyId, boolean seaArea) {
        return this.hasEnemyTerritoryFlag(location.getX(), location.getY(), enemyId, seaArea);
    }

    @Override
    public boolean hasEnemyTerritoryFlag(double x, double y, int enemyId, boolean seaArea) {
        if (x < -180.0 || x > 180.0 || y < -100.0 || y > 100.0) {
            return false;
        }
        boolean ok = false;
        if (!this.enemyTerritories.containsKey(enemyId)) {
            if (this.log != null) {
                this.log.info("enemyId: " + enemyId);
            }
            return false;
        }
        if (seaArea) {
            for (BufferedImage territory : ((SortedMap)this.enemyTerritories.get(enemyId)).values()) {
                Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, territory);
                ok = this.overThresh(territory, (Integer)coords.first, (Integer)coords.second, 100) && this.underThresh(territory, (Integer)coords.first, (Integer)coords.second, 200);
                if (!ok) continue;
                break;
            }
            return ok;
        }
        for (BufferedImage territory : ((SortedMap)this.enemyTerritories.get(enemyId)).values()) {
            Pair<Integer, Integer> coords = this.convertToImageCoords(x, y, territory);
            ok = this.overThresh(territory, (Integer)coords.first, (Integer)coords.second, 200);
            if (!ok) continue;
            break;
        }
        return ok;
    }
}

