/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.messages.infos;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.communication.messages.Updatable;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConObject;
import cz.cuni.amis.utils.exception.PogamutException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefConObjectUpdate
implements IWorldObjectUpdatedEvent {
    private static Map<Class<?>, Updater> updaters = new HashMap();
    private double time = 0.0;
    private DefConObject source;

    public DefConObjectUpdate(DefConObject source) {
        this.source = source;
    }

    public static synchronized Updater getUpdater(Class<?> cls) {
        Updater updater = updaters.get(cls);
        if (updater != null) {
            return updater;
        }
        updater = new Updater(cls);
        updaters.put(cls, updater);
        return updater;
    }

    public DefConObject getSource() {
        return this.source;
    }

    public WorldObjectId getId() {
        return this.source == null ? null : this.source.getId();
    }

    public IWorldObjectUpdateResult update(IWorldObject obj) {
        if (this.source == null) {
            return null;
        }
        if (obj == null) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)this.source);
        }
        if (!obj.getClass().equals(this.source.getClass())) {
            throw new PogamutException("Can't update object of class " + obj.getClass().getName() + " with information from object of class " + this.source.getClass().getName(), (Object)this);
        }
        if (this.source.getDestroyed()) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.DESTROYED, obj);
        }
        DefConObjectUpdate.getUpdater(obj.getClass()).update(obj, this.source);
        return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, obj);
    }

    public double getLastSeenTime() {
        return this.time;
    }

    protected void setLastSeenTime(double time) {
        this.time = time;
    }

    public long getSimTime() {
        return (long)this.time;
    }

    private static class Updater {
        private Class<?> cls;
        private List<Field> fields = new ArrayList<Field>();

        public Updater(Class<?> cls) {
            this.cls = cls;
            do {
                for (Field field : cls.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Updatable.class)) continue;
                    this.fields.add(field);
                }
            } while ((cls = cls.getSuperclass()) != null);
        }

        public Class getUpdaterClass() {
            return this.cls;
        }

        public void update(Object oldObj, Object newObj) {
            if (!oldObj.getClass().equals(this.cls) || !newObj.getClass().equals(this.cls)) {
                throw new PogamutException("Can't update object of class " + oldObj.getClass().getName() + " with information from object of class " + newObj.getClass().getName() + " because they bot must be of class " + this.cls.getName(), (Object)this);
            }
            for (Field field : this.fields) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(newObj);
                    if (value == null) continue;
                    try {
                        field.set(oldObj, value);
                    }
                    catch (Exception e) {
                        throw new PogamutException("Could not set value " + value + " to the field '" + field.getName() + "' of the object " + newObj + " because: " + e.getMessage(), (Throwable)e, (Object)this);
                    }
                }
                catch (Exception e) {
                    throw new PogamutException("Could not obtain field '" + field.getName() + "' from object " + newObj + " because: " + e.getMessage(), (Throwable)e, (Object)this);
                }
                finally {
                    field.setAccessible(false);
                }
            }
        }
    }
}

