/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.factory;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentController;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.communication.translator.DefConMessageProducer;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.utils.token.IToken;
import java.lang.annotation.Annotation;
import javabot.PogamutJBotSupport;

public class DefConAgentModule
extends GuiceAgentModule<AgentParameters> {
    private Class<? extends DefConAgent> defConAgentClass;
    private Class<? extends IDefConAgentLogicController> defConAgentLogicControllerClass;
    private AdaptableProvider<ComponentDependencies> defConDependenciesProvider = new AdaptableProvider(null);

    public DefConAgentModule(Class<? extends DefConAgent> defConAgentClass, Class<? extends IDefConAgentLogicController> defConAgentLogicControllerClass) {
        this.defConAgentClass = defConAgentClass;
        this.defConAgentLogicControllerClass = defConAgentLogicControllerClass;
    }

    public Class<? extends DefConAgent> getDefConAgentClass() {
        return this.defConAgentClass;
    }

    public void newBindings(IAgentId agentId) {
        this.getAgentScope().clearScope();
        this.defConDependenciesProvider.set((Object)new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IToken)agentId));
    }

    protected void configureModules() {
        super.configureModules();
        PogamutJBotSupport.writeToConsole("DefConAgentModule configure modules()");
        this.addModule(new AbstractModule(){

            protected void configure() {
                this.bind(IAgent.class).to(IObservingAgent.class);
                this.bind(IObservingAgent.class).to(IEmbodiedAgent.class);
                this.bind(IEmbodiedAgent.class).to(IDefConAgent.class);
                this.bind(IDefConAgent.class).to(DefConAgent.class);
                if (DefConAgent.class != DefConAgentModule.this.defConAgentClass) {
                    this.bind(DefConAgent.class).to(DefConAgentModule.this.defConAgentClass);
                }
                this.bind(IWorldView.class).to(DefConWorldView.class);
                this.bind(IWorldChangeEventOutput.class).to(DefConMessageProducer.class);
                this.bind(IDefConAgentController.class).to(IDefConAgentLogicController.class);
                this.bind(IDefConAgentLogicController.class).to(DefConAgentModule.this.defConAgentLogicControllerClass);
                this.bind(ComponentDependencies.class).annotatedWith((Annotation)Names.named((String)"DefConWorldViewDependency")).toProvider((Provider)DefConAgentModule.this.defConDependenciesProvider);
            }
        });
    }
}

