/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.translator;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.EventBatchBegin;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.EventBatchEnd;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javabot.PogamutJBotSupport;
import javabot.events.DefConBasicUpdate;
import javabot.events.IDefConBasicEvent;

@AgentScoped
public class DefConMessageProducer
implements IWorldChangeEventOutput {
    public static final Token COMPONENT_ID = Tokens.get((String)"DefConMessageProducer");
    private LinkedList<IWorldChangeEvent> eventQueue = new LinkedList();
    private float startTime;
    private boolean defConStarted = false;
    private IComponentBus eventBus;
    private ComponentController controller;
    private LogCategory log;
    private GameInfo gameInfo;
    private IComponentControlHelper control = new ComponentControlHelper(){

        public void start() {
            DefConMessageProducer.this.eventQueue.clear();
            DefConMessageProducer.this.eventQueue.add(new EventBatchBegin(0.0));
            DefConMessageProducer.this.startTime = DefConMessageProducer.this.gameInfo.getGameTime();
            DefConMessageProducer.this.defConStarted = false;
        }

        public void reset() {
            this.start();
        }
    };

    @Inject
    public DefConMessageProducer(IComponentBus eventBus, IAgentLogger logger) {
        this.log = logger.getCategory(COMPONENT_ID.getToken());
        this.eventBus = eventBus;
        this.controller = new ComponentController((IComponent)this, this.control, this.eventBus, (Logger)this.log, new ComponentDependencies());
        this.gameInfo = new GameInfo();
    }

    public IWorldChangeEvent getEvent() throws CommunicationException {
        if (!this.defConStarted) {
            if (!this.gameInfo.getRunning()) {
                return null;
            }
            this.startTime = this.gameInfo.getGameTime();
            this.defConStarted = true;
        }
        if (this.eventQueue.size() != 0) {
            return this.eventQueue.poll();
        }
        return null;
    }

    private void populateQueue() {
        List<IDefConBasicEvent> events = PogamutJBotSupport.getEvents();
        for (IDefConBasicEvent event : events) {
            if (event instanceof DefConBasicUpdate) {
                this.eventQueue.addAll(this.gameInfo.getEvents());
                this.eventQueue.addAll(this.getUnitsUpdate());
                this.eventQueue.add(new EventBatchEnd(this.gameInfo.getGameTime()));
                this.eventQueue.add(new EventBatchBegin(this.gameInfo.getGameTime()));
                continue;
            }
            this.eventQueue.add(event);
        }
    }

    private List<IWorldChangeEvent> getUnitsUpdate() {
        return PogamutJBotSupport.getUnitsUpdate();
    }

    public String toString() {
        return "DefConMessageProducer[startTime=" + this.startTime + "]";
    }

    public IToken getComponentId() {
        return COMPONENT_ID;
    }

    public void update() {
        this.populateQueue();
    }

    public float getStartTime() {
        return this.startTime;
    }

    public float getCurrentTime() {
        return this.gameInfo.getGameTick();
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }
}

