package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Bombers.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum BomberState implements IState {
	
	ATTACK(JBot.STATE_BOMBERATTACK),    
    NUKE(JBot.STATE_BOMBERNUKE),
    IN_QUEUE(JBot.STATE_BOMBERINQUEUE);
	
	private static Map<Integer, BomberState> states = new HashMap<Integer, BomberState>();
	
	public static BomberState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (BomberState state : BomberState.values()) {
			states.put(state.getStateId(), state);
		}
	}
	
	public final int id;
	
	private BomberState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
