package cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.loaders.borders;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;

/**
 * Saves borders to given path.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class FilePrecomputedBordersSaver implements IPrecomputedBordersSaver {

	private String pathString;
	private File path;

	public FilePrecomputedBordersSaver(String pathString) {
		this.pathString = pathString;
		this.path = new File(pathString);

		if (!this.path.exists()) {
			this.path.mkdir();
		}

		if (!this.path.isDirectory())
			throw new IllegalArgumentException(
					"FilePrecomputedBordersSaver: pathString has to point to a directory");
	}

	@Override
	public void saveBorderOfTerritory(
			String fileName, List<List<DefConLocation>> territoryBorders)
			throws IOException {
		BufferedWriter output = new BufferedWriter(new FileWriter(new File(
				path, fileName)));

		for (List<DefConLocation> locations : territoryBorders) {
			output.write(locations.toString());
			output.write("\n");
		}
		output.close();
	}

	public final String getPathString() {
		return pathString;
	}
}
