/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestLocalObjectImpl;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class TestLocalObject
implements ILocalWorldObject {
    protected WorldObjectId id;
    protected long simTime;

    public abstract String getLocalString();

    public abstract long getLocalLong();

    protected TestLocalObject(WorldObjectId id, long simTime) {
        this.id = id;
        this.simTime = simTime;
    }

    public abstract TestLocalObject clone();

    public WorldObjectId getId() {
        return this.id;
    }

    public long getSimTime() {
        return this.simTime;
    }

    public Class getCompositeClass() {
        return TestCompositeObject.class;
    }

    public TestLocalObjectUpdatedEvent createUpdateEvent(long simTime) {
        return new TestLocalObjectUpdatedEvent(this, simTime);
    }

    public String toString() {
        return "TestLocalObject[id=" + this.getId() + ", time=" + this.getSimTime() + ", localString=" + this.getLocalString() + ", localLong=" + this.getLocalLong() + "]";
    }

    public static class TestLocalObjectUpdatedEvent
    implements ILocalWorldObjectUpdatedEvent {
        private TestLocalObject data;
        private long simTime;

        public TestLocalObjectUpdatedEvent(TestLocalObject data, long simTime) {
            this.data = data;
            this.simTime = simTime;
        }

        public long getSimTime() {
            return this.simTime;
        }

        public WorldObjectId getId() {
            return this.data.getId();
        }

        public IWorldObjectUpdateResult<ILocalWorldObject> update(ILocalWorldObject object) {
            if (object == null) {
                TestLocalObjectImpl ret = new TestLocalObjectImpl(this.data);
                this.data = ret;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, (IWorldObject)this.data);
            }
            if (!(object instanceof TestLocalObjectImpl)) {
                throw new PogamutException("Wrong object class provided for update, expected TestLocalObjectImpl", (Object)this);
            }
            TestLocalObjectImpl toUpdate = (TestLocalObjectImpl)object;
            boolean updated = false;
            if (toUpdate.longVal.longValue() != this.data.getLocalLong()) {
                toUpdate.longVal = this.data.getLocalLong();
                updated = true;
            }
            if (!toUpdate.stringVal.equals(this.data.getLocalString())) {
                toUpdate.stringVal = this.data.getLocalString();
                updated = true;
            }
            toUpdate.simTime = this.simTime;
            if (updated) {
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, (IWorldObject)toUpdate);
            }
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.SAME, (IWorldObject)toUpdate);
        }

        public String toString() {
            return "TestLocalObjectUpdatedEvent[id=" + this.getId() + ", time=" + this.getSimTime() + "]";
        }
    }
}

