/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.jasonBase;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.jasonInterface.IPogamutBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import jason.architecture.AgArch;
import jason.asSyntax.Literal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PogamutMainAgArchBase
extends AgArch {
    private List<Literal> messageBuffer = new ArrayList<Literal>();
    private final IWorldEventListener<?> allWorldEventsListener = new IWorldEventListener<IWorldEvent>(){

        public void notify(IWorldEvent message) {
            if (message == null || !(message instanceof InfoMessage)) {
                return;
            }
            PogamutMainAgArchBase.this.addMessageToBuffer((InfoMessage)message);
        }
    };
    private final IWorldObjectEventListener<IWorldObject, IWorldObjectEvent<IWorldObject>> allWorldUpdateEventsListener = new IWorldObjectEventListener<IWorldObject, IWorldObjectEvent<IWorldObject>>(){

        public void notify(IWorldObjectEvent<IWorldObject> objectEvent) {
            if (objectEvent == null || !(objectEvent.getObject() instanceof InfoMessage)) {
                return;
            }
            IWorldObject object = objectEvent.getObject();
            PogamutMainAgArchBase.this.addMessageToBuffer((InfoMessage)object);
        }
    };
    private List<Literal> percepts = Collections.synchronizedList(new ArrayList());
    protected Logger logger = Logger.getLogger("Jason");
    protected IPogamutBot pogamutBot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToBuffer(InfoMessage message) {
        if ((message = this.beforeAddMessageToBuffer(message)) == null) {
            return;
        }
        if (message instanceof BeginMessage) {
            return;
        }
        if (message instanceof EndMessage) {
            LinkedList<Literal> messages = null;
            List<Literal> list = this.messageBuffer;
            synchronized (list) {
                messages = new LinkedList<Literal>(this.messageBuffer);
                this.messageBuffer.clear();
            }
            this.addPercept(messages);
            return;
        }
        String messageLiteral = message.toJsonLiteral();
        if ((messageLiteral = messageLiteral.substring(0, 1).toLowerCase() + messageLiteral.substring(1)).contains("( ,")) {
            messageLiteral = messageLiteral.replace("( ,", "(");
        }
        if (messageLiteral.contains("( )")) {
            messageLiteral = messageLiteral.replace("( )", "");
        }
        if (messageLiteral.contains("(null, )")) {
            messageLiteral = messageLiteral.replace("(null, )", "");
        }
        if (messageLiteral.contains("(null, ,")) {
            messageLiteral = messageLiteral.replace("(null, ,", "");
        }
        this.logger.info(messageLiteral);
        this.messageBuffer.add(Literal.parseLiteral((String)messageLiteral));
    }

    public InfoMessage beforeAddMessageToBuffer(InfoMessage message) {
        return message;
    }

    public PogamutMainAgArchBase() {
        LogPublisher.FilePublisher publisher = new LogPublisher.FilePublisher(new File("PogamutAgArch.log"), (Formatter)new LogFormatter(true));
        LogHandler defaultHandler = new LogHandler((ILogPublisher)publisher);
        this.logger.addHandler((Handler)defaultHandler);
        for (int loggerIndex = 0; loggerIndex < this.logger.getHandlers().length; ++loggerIndex) {
            this.logger.getHandlers()[loggerIndex].setLevel(Level.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPercept(Literal percept) {
        List<Literal> list = this.percepts;
        synchronized (list) {
            this.percepts.add(percept);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPercept(LinkedList<Literal> percepts) {
        List<Literal> list = this.percepts;
        synchronized (list) {
            this.percepts.addAll(percepts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Literal> perceive() {
        LinkedList<Literal> result = null;
        List<Literal> list = this.percepts;
        synchronized (list) {
            result = new LinkedList<Literal>(this.percepts);
            this.percepts.clear();
        }
        return result;
    }

    public IPogamutBot getPogamutBot() {
        return this.pogamutBot;
    }

    public void setPogamutBot(IPogamutBot bot) {
        this.pogamutBot = bot;
        this.pogamutBot.getWorldView().addEventListener(IWorldEvent.class, this.allWorldEventsListener);
        this.pogamutBot.getWorldView().addObjectListener(IWorldObject.class, WorldObjectUpdatedEvent.class, this.allWorldUpdateEventsListener);
    }

    public void init() throws Exception {
        super.init();
        boolean successfullyStarted = false;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                this.startPogamutBot();
                successfullyStarted = true;
            }
            catch (ComponentCantStartException e) {
                this.logger.severe("Not able to connect to the server: " + e.getMessage());
                try {
                    this.logger.info("Sleep 5 seconds and try to start pogamut bot again. Attempt: " + attempt);
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
            if (successfullyStarted) break;
        }
    }

    protected abstract void startPogamutBot();
}

