/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.pddl;

import cz.cuni.amis.planning4j.pddl.PDDLObjectInstance;
import cz.cuni.amis.planning4j.pddl.PDDLParameter;
import cz.cuni.amis.planning4j.pddl.PDDLTypedObject;
import java.util.List;

public abstract class PDDLElementWithParameters {
    protected String name;
    protected List<PDDLParameter> parameters;

    public PDDLElementWithParameters(String name, List<PDDLParameter> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public List<PDDLParameter> getParameters() {
        return this.parameters;
    }

    public String stringAfterSubstitution(Object ... substituents) {
        if (substituents.length != this.getParameters().size()) {
            throw new IllegalArgumentException("Predicate " + this.getName() + " requires " + this.getParameters().size() + " parameters, got " + substituents.length);
        }
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.getParameters().size() > 0) {
            for (int i = 0; i < substituents.length; ++i) {
                sb.append(" ");
                if (substituents[i] instanceof String) {
                    sb.append(substituents[i]);
                    continue;
                }
                if (substituents[i] instanceof PDDLTypedObject) {
                    sb.append(((PDDLObjectInstance)substituents[i]).getNameForPDDL());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported substituent type: " + substituents[i].getClass());
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.name + "/" + this.parameters.size();
    }
}

