/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.utils;

import cz.cuni.amis.planning4j.ActionDescription;
import cz.cuni.amis.planning4j.IAsyncPlanner;
import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IDomainTranslator;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IPlanner;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.IProblemTranslator;
import cz.cuni.amis.planning4j.IValidationResult;
import cz.cuni.amis.planning4j.IValidator;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.impl.PDDLFileDomainProvider;
import cz.cuni.amis.planning4j.impl.PDDLFileProblemProvider;
import cz.cuni.amis.planning4j.impl.PDDLObjectDomainProvider;
import cz.cuni.amis.planning4j.impl.PDDLObjectProblemProvider;
import cz.cuni.amis.planning4j.impl.PDDLStringDomainProvider;
import cz.cuni.amis.planning4j.impl.PDDLStringProblemProvider;
import cz.cuni.amis.planning4j.impl.TranslatingAsyncPlanner;
import cz.cuni.amis.planning4j.impl.TranslatingPlanner;
import cz.cuni.amis.planning4j.impl.TranslatingValidator;
import cz.cuni.amis.planning4j.pddl.PDDLDomain;
import cz.cuni.amis.planning4j.pddl.PDDLProblem;
import cz.cuni.amis.planning4j.translators.domain.NoTranslationDomainTranslator;
import cz.cuni.amis.planning4j.translators.problem.NoTranslationProblemTranslator;
import java.io.File;
import java.util.List;
import java.util.ServiceLoader;

public class Planning4JUtils {
    private static ServiceLoader<IDomainTranslator> domainTranslatorLoader = ServiceLoader.load(IDomainTranslator.class);
    private static ServiceLoader<IProblemTranslator> problemTranslatorLoader = ServiceLoader.load(IProblemTranslator.class);

    public static String normalizeIdentifier(String identifier) {
        return identifier.toUpperCase().replace('-', '_');
    }

    public static <SOURCE_DOMAIN extends IDomainProvider, DESTINATION_DOMAIN extends IDomainProvider> IDomainTranslator<SOURCE_DOMAIN, DESTINATION_DOMAIN> findDomainTranslator(Class<SOURCE_DOMAIN> sourceDomainClass, Class<DESTINATION_DOMAIN> destinationDomainClass) {
        if (destinationDomainClass.isAssignableFrom(sourceDomainClass)) {
            return new NoTranslationDomainTranslator<DESTINATION_DOMAIN>(destinationDomainClass);
        }
        for (IDomainTranslator translator : domainTranslatorLoader) {
            if (!translator.getSourceDomainClass().equals(sourceDomainClass) || !translator.getDestinationDomainClass().equals(destinationDomainClass)) continue;
            return translator;
        }
        for (IDomainTranslator translator : domainTranslatorLoader) {
            if (!translator.getSourceDomainClass().isAssignableFrom(sourceDomainClass) || !translator.getDestinationDomainClass().isAssignableFrom(destinationDomainClass)) continue;
            return translator;
        }
        return null;
    }

    public static <SOURCE_DOMAIN extends IDomainProvider, DESTINATION_DOMAIN extends IDomainProvider> IDomainTranslator<SOURCE_DOMAIN, DESTINATION_DOMAIN> findDomainTranslatorThrowException(Class<SOURCE_DOMAIN> sourceDomainClass, Class<DESTINATION_DOMAIN> destinationDomainClass) {
        IDomainTranslator<SOURCE_DOMAIN, DESTINATION_DOMAIN> domainTranslator = Planning4JUtils.findDomainTranslator(sourceDomainClass, destinationDomainClass);
        if (domainTranslator == null) {
            throw new PlanningException("Could not find domain translator from " + sourceDomainClass + " to " + destinationDomainClass);
        }
        return domainTranslator;
    }

    public static <SOURCE_PROBLEM extends IProblemProvider, DESTINATION_PROBLEM extends IProblemProvider> IProblemTranslator<SOURCE_PROBLEM, DESTINATION_PROBLEM> findProblemTranslator(Class<SOURCE_PROBLEM> sourceProblemClass, Class<DESTINATION_PROBLEM> destinationProblemClass) {
        if (destinationProblemClass.isAssignableFrom(sourceProblemClass)) {
            return new NoTranslationProblemTranslator<DESTINATION_PROBLEM>(destinationProblemClass);
        }
        for (IProblemTranslator translator : problemTranslatorLoader) {
            if (!translator.getSourceProblemClass().equals(sourceProblemClass) || !translator.getDestinationProblemClass().equals(destinationProblemClass)) continue;
            return translator;
        }
        for (IProblemTranslator translator : problemTranslatorLoader) {
            if (!translator.getSourceProblemClass().isAssignableFrom(sourceProblemClass) || !translator.getDestinationProblemClass().isAssignableFrom(destinationProblemClass)) continue;
            return translator;
        }
        return null;
    }

    public static <SOURCE_PROBLEM extends IProblemProvider, DESTINATION_PROBLEM extends IProblemProvider> IProblemTranslator<SOURCE_PROBLEM, DESTINATION_PROBLEM> findProblemTranslatorThrowException(Class<SOURCE_PROBLEM> sourceProblemClass, Class<DESTINATION_PROBLEM> destinationProblemClass) {
        IProblemTranslator<SOURCE_PROBLEM, DESTINATION_PROBLEM> problemTranslator = Planning4JUtils.findProblemTranslator(sourceProblemClass, destinationProblemClass);
        if (problemTranslator == null) {
            throw new PlanningException("Could not find problem translator from " + sourceProblemClass + " to " + destinationProblemClass);
        }
        return problemTranslator;
    }

    public static <SOURCE_DOMAIN extends IDomainProvider, DESTINATION_DOMAIN extends IDomainProvider, SOURCE_PROBLEM extends IProblemProvider, DESTINATION_PROBLEM extends IProblemProvider> IAsyncPlanner<SOURCE_DOMAIN, SOURCE_PROBLEM> getTranslatingAsyncPlanner(IAsyncPlanner<DESTINATION_DOMAIN, DESTINATION_PROBLEM> original, Class<SOURCE_DOMAIN> sourceDomainClass, Class<SOURCE_PROBLEM> sourceProblemClass) {
        if (original.getDomainClass().isAssignableFrom(sourceDomainClass) && original.getProblemClass().isAssignableFrom(sourceProblemClass)) {
            return original;
        }
        return new TranslatingAsyncPlanner<SOURCE_DOMAIN, DESTINATION_DOMAIN, SOURCE_PROBLEM, DESTINATION_PROBLEM>(original, Planning4JUtils.findDomainTranslatorThrowException(sourceDomainClass, original.getDomainClass()), Planning4JUtils.findProblemTranslatorThrowException(sourceProblemClass, original.getProblemClass()));
    }

    public static <SOURCE_DOMAIN extends IDomainProvider, DESTINATION_DOMAIN extends IDomainProvider, SOURCE_PROBLEM extends IProblemProvider, DESTINATION_PROBLEM extends IProblemProvider> IPlanner<SOURCE_DOMAIN, SOURCE_PROBLEM> getTranslatingPlanner(IPlanner<DESTINATION_DOMAIN, DESTINATION_PROBLEM> original, Class<SOURCE_DOMAIN> sourceDomainClass, Class<SOURCE_PROBLEM> sourceProblemClass) {
        if (original.getDomainClass().isAssignableFrom(sourceDomainClass) && original.getProblemClass().isAssignableFrom(sourceProblemClass)) {
            return original;
        }
        return new TranslatingPlanner<SOURCE_DOMAIN, DESTINATION_DOMAIN, SOURCE_PROBLEM, DESTINATION_PROBLEM>(original, Planning4JUtils.findDomainTranslatorThrowException(sourceDomainClass, original.getDomainClass()), Planning4JUtils.findProblemTranslatorThrowException(sourceProblemClass, original.getProblemClass()));
    }

    public static IPlanner getTranslatingPlanner(IPlanner planner, IDomainProvider domain, IProblemProvider problem) {
        return Planning4JUtils.getTranslatingPlanner(planner, domain.getClass(), problem.getClass());
    }

    public static IAsyncPlanner getTranslatingAsyncPlanner(IAsyncPlanner planner, IDomainProvider domain, IProblemProvider problem) {
        return Planning4JUtils.getTranslatingAsyncPlanner(planner, domain.getClass(), problem.getClass());
    }

    public static IPlanningResult plan(IPlanner planner, IDomainProvider domain, IProblemProvider problem) {
        return Planning4JUtils.getTranslatingPlanner(planner, domain, problem).plan(domain, problem);
    }

    public static IPlanningResult plan(IPlanner planner, PDDLDomain domain, PDDLProblem problem) {
        return Planning4JUtils.plan(planner, new PDDLObjectDomainProvider(domain), new PDDLObjectProblemProvider(problem));
    }

    public static IPlanningResult planPDDL(IPlanner planner, File domainFile, File problemFile) {
        return Planning4JUtils.plan(planner, new PDDLFileDomainProvider(domainFile), new PDDLFileProblemProvider(problemFile));
    }

    public static IPlanningResult planPDDL(IPlanner planner, String domain, String problem) {
        return Planning4JUtils.plan(planner, new PDDLStringDomainProvider(domain), new PDDLStringProblemProvider(problem));
    }

    public static IPlanFuture<IPlanningResult> planAsync(IAsyncPlanner planner, IDomainProvider domain, IProblemProvider problem) {
        return Planning4JUtils.getTranslatingAsyncPlanner(planner, domain, problem).planAsync(domain, problem);
    }

    public static <SOURCE_DOMAIN extends IDomainProvider, DESTINATION_DOMAIN extends IDomainProvider, SOURCE_PROBLEM extends IProblemProvider, DESTINATION_PROBLEM extends IProblemProvider> IValidator<SOURCE_DOMAIN, SOURCE_PROBLEM> getTranslatingValidator(IValidator<DESTINATION_DOMAIN, DESTINATION_PROBLEM> original, Class<SOURCE_DOMAIN> sourceDomainClass, Class<SOURCE_PROBLEM> sourceProblemClass) {
        if (original.getDomainClass().isAssignableFrom(sourceDomainClass) && original.getProblemClass().isAssignableFrom(sourceProblemClass)) {
            return original;
        }
        return new TranslatingValidator<SOURCE_DOMAIN, DESTINATION_DOMAIN, SOURCE_PROBLEM, DESTINATION_PROBLEM>(original, Planning4JUtils.findDomainTranslatorThrowException(sourceDomainClass, original.getDomainClass()), Planning4JUtils.findProblemTranslatorThrowException(sourceProblemClass, original.getProblemClass()));
    }

    public static IValidator getTranslatingValidator(IValidator validator, IDomainProvider domain, IProblemProvider problem) {
        return Planning4JUtils.getTranslatingValidator(validator, domain.getClass(), problem.getClass());
    }

    public static IValidationResult validate(IValidator validator, IDomainProvider domain, IProblemProvider problem, List<ActionDescription> plan) {
        return Planning4JUtils.getTranslatingValidator(validator, domain, problem).validate(domain, problem, plan);
    }
}

