/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.impl;

import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IDomainTranslator;
import cz.cuni.amis.planning4j.IPlanner;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.IProblemTranslator;

public class TranslatingPlanner<SOURCE_DOMAIN extends IDomainProvider, DESTINATION_DOMAIN extends IDomainProvider, SOURCE_PROBLEM extends IProblemProvider, DESTINATION_PROBLEM extends IProblemProvider>
implements IPlanner<SOURCE_DOMAIN, SOURCE_PROBLEM> {
    IPlanner<DESTINATION_DOMAIN, DESTINATION_PROBLEM> originalPlanner;
    IDomainTranslator<SOURCE_DOMAIN, DESTINATION_DOMAIN> domainTranslator;
    IProblemTranslator<SOURCE_PROBLEM, DESTINATION_PROBLEM> problemTranslator;

    @Override
    public Class<SOURCE_DOMAIN> getDomainClass() {
        return this.domainTranslator.getSourceDomainClass();
    }

    @Override
    public Class<SOURCE_PROBLEM> getProblemClass() {
        return this.problemTranslator.getSourceProblemClass();
    }

    public TranslatingPlanner(IPlanner<DESTINATION_DOMAIN, DESTINATION_PROBLEM> originalPlanner, IDomainTranslator<SOURCE_DOMAIN, DESTINATION_DOMAIN> domainTranslator, IProblemTranslator<SOURCE_PROBLEM, DESTINATION_PROBLEM> problemTranslator) {
        this.originalPlanner = originalPlanner;
        this.domainTranslator = domainTranslator;
        this.problemTranslator = problemTranslator;
    }

    @Override
    public IPlanningResult plan(SOURCE_DOMAIN domainProvider, SOURCE_PROBLEM problemProvider) {
        return this.originalPlanner.plan(this.domainTranslator.translateDomain(domainProvider), this.problemTranslator.translateProblem(problemProvider));
    }

    public String toString() {
        return "TranslatingPlanner{originalPlanner=" + this.originalPlanner + ", domainTranslator=" + this.domainTranslator + ", problemTranslator=" + this.problemTranslator + '}';
    }

    @Override
    public String getName() {
        return this.originalPlanner.getName();
    }
}

