/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShapeException;
import math.geom2d.Vector2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.InvertedRay2D;
import math.geom2d.line.LinearShape2D;

public class Ray2D
extends AbstractLine2D
implements Cloneable {
    private static final long serialVersionUID = 1L;

    public Ray2D() {
        this(0.0, 0.0, 1.0, 0.0);
    }

    public Ray2D(Point2D point1, Point2D point2) {
        this(point1.getX(), point1.getY(), point2.getX() - point1.getX(), point2.getY() - point1.getY());
    }

    public Ray2D(double x1, double y1, double dx, double dy) {
        super(x1, y1, dx, dy);
    }

    public Ray2D(Point2D point, double dx, double dy) {
        this(point.getX(), point.getY(), dx, dy);
    }

    public Ray2D(Point2D point, Vector2D vector) {
        this(point.getX(), point.getY(), vector.getX(), vector.getY());
    }

    public Ray2D(Point2D point, double angle) {
        this(point.getX(), point.getY(), Math.cos(angle), Math.sin(angle));
    }

    public Ray2D(double x, double y, double angle) {
        this(x, y, Math.cos(angle), Math.sin(angle));
    }

    public Ray2D(LinearShape2D line) {
        super(line);
    }

    @Override
    public boolean containsParametric(double t) {
        return t >= 0.0;
    }

    public static final Ray2D create(Point2D origin, Vector2D direction) {
        return new Ray2D(origin, direction);
    }

    public static final Ray2D create(Point2D origin, Point2D target) {
        return new Ray2D(origin, target);
    }

    @Deprecated
    public void setRay(double x0, double y0, double dx, double dy) {
        this.x0 = x0;
        this.y0 = y0;
        this.dx = dx;
        this.dy = dy;
    }

    @Deprecated
    public void setRay(Point2D p1, Point2D p2) {
        this.x0 = p1.getX();
        this.y0 = p1.getY();
        this.dx = p2.getX() - this.x0;
        this.dy = p2.getY() - this.y0;
    }

    @Deprecated
    public void setRay(Point2D point, Vector2D vect) {
        this.x0 = point.getX();
        this.y0 = point.getY();
        this.dx = vect.getX();
        this.dy = vect.getY();
    }

    @Override
    public Ray2D getParallel(double d) {
        double dd = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        return new Ray2D(this.x0 + this.dy * d / dd, this.y0 - this.dx * d / dd, this.dx, this.dy);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        throw new UnboundedShapeException(this);
    }

    public GeneralPath getGeneralPath() {
        throw new UnboundedShapeException(this);
    }

    @Override
    public Point2D getFirstPoint() {
        return new Point2D(this.x0, this.y0);
    }

    @Override
    public Point2D getPoint(double t) {
        t = Math.max(t, 0.0);
        return new Point2D(this.x0 + t * this.dx, this.y0 + t * this.dy);
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public InvertedRay2D getReverseCurve() {
        return new InvertedRay2D(this.x0, this.y0, -this.dx, -this.dy);
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        if (!this.supportContains(x, y)) {
            return false;
        }
        double t = this.getPositionOnLine(x, y);
        return t > -1.0E-12;
    }

    @Override
    public Box2D getBoundingBox() {
        double t = Double.POSITIVE_INFINITY;
        return new Box2D(this.x0, this.x0 + t * this.dx, this.y0, this.y0 + t * this.dy);
    }

    @Override
    public Ray2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        double x1 = this.x0 * tab[0] + this.y0 * tab[1] + tab[2];
        double y1 = this.x0 * tab[3] + this.y0 * tab[4] + tab[5];
        return new Ray2D(x1, y1, this.dx * tab[0] + this.dy * tab[1], this.dx * tab[3] + this.dy * tab[4]);
    }

    public String toString() {
        return new String("Ray2D(" + this.x0 + "," + this.y0 + "," + this.dx + "," + this.dy + ")");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ray2D)) {
            return false;
        }
        Ray2D ray = (Ray2D)obj;
        if (Math.abs(this.x0 - ray.x0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y0 - ray.y0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dx - ray.dx) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.dy - ray.dy) > 1.0E-12);
    }

    @Override
    public Ray2D clone() {
        return new Ray2D(this.x0, this.y0, this.dx, this.dy);
    }
}

