/*
 * Decompiled with CFR 0.152.
 */
package math.bsp.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import math.bsp.BspOccupation;
import math.bsp.BspTree;
import math.bsp.node.AbstractBspNode;
import math.bsp.node.IBspNode;
import math.bsp.node.IConstBspInternalNode;

public class BspInternalNode<TData, TBoundary>
extends AbstractBspNode<TData, TBoundary>
implements IBspNode<TData, TBoundary>,
IConstBspInternalNode<TData, TBoundary> {
    private static final long serialVersionUID = 1L;
    protected TBoundary boundary;
    protected IBspNode<TData, TBoundary> positiveChild;
    protected IBspNode<TData, TBoundary> negativeChild;

    public BspInternalNode(BspTree<TData, TBoundary> tree) {
        super(tree);
    }

    @Override
    public TBoundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(TBoundary value) {
        this.boundary = value;
    }

    @Override
    public IBspNode<TData, TBoundary> getPositiveChild() {
        return this.positiveChild;
    }

    public void setPositiveChild(IBspNode<TData, TBoundary> value) {
        this.positiveChild = value;
    }

    @Override
    public IBspNode<TData, TBoundary> getNegativeChild() {
        return this.negativeChild;
    }

    public void setNegativeChild(IBspNode<TData, TBoundary> value) {
        this.negativeChild = value;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public TData getSubtreeData(BspOccupation filter) {
        ArrayList unjoined = Lists.newArrayList();
        if (filter.intersectsPositive()) {
            unjoined.add(this.positiveChild.getSubtreeData(filter));
        }
        if (filter.intersectsNegative()) {
            unjoined.add(this.negativeChild.getSubtreeData(filter));
        }
        if (unjoined.isEmpty()) {
            return null;
        }
        while (unjoined.size() > 1) {
            Object data1 = unjoined.remove(0);
            Object data2 = unjoined.remove(0);
            unjoined.add(this.tree.getStrategy().joinData(data1, data2));
        }
        return (TData)unjoined.get(0);
    }

    @Override
    public BspInternalNode<TData, TBoundary> asInternal() {
        return this;
    }

    @Override
    public IConstBspInternalNode<TData, TBoundary> asConst() {
        return this;
    }
}

