/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearBoundarySet2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.BoundarySet2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.MultiPolygon2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polyline2DUtils;

public abstract class Polygon2DUtils {
    public static final int windingNumber(Collection<Point2D> vertices, java.awt.geom.Point2D point) {
        int wn = 0;
        Point2D.Double previous = null;
        for (Point2D vertex : vertices) {
            previous = vertex;
        }
        double x1 = previous.getX();
        double y1 = previous.getY();
        double y = point.getY();
        for (Point2D p : vertices) {
            double x2 = p.getX();
            double y2 = p.getY();
            if (y1 <= y) {
                if (y2 > y && new LineSegment2D(x1, y1, x2, y2).isInside(point)) {
                    ++wn;
                }
            } else if (y2 <= y && !new LineSegment2D(x1, y1, x2, y2).isInside(point)) {
                --wn;
            }
            x1 = x2;
            y1 = y2;
        }
        return wn;
    }

    public static final Domain2D createBuffer(Polygon2D polygon, double d) {
        BoundarySet2D<BoundaryPolyCurve2D<SmoothOrientedCurve2D>> result = new BoundarySet2D<BoundaryPolyCurve2D<SmoothOrientedCurve2D>>();
        for (LinearRing2D linearRing2D : polygon.getBoundary()) {
            result.addCurve(Polyline2DUtils.createClosedParallel(linearRing2D, d));
        }
        return new GenericDomain2D(result);
    }

    public static final Polygon2D union(Polygon2D polygon1, Polygon2D polygon2) {
        ArrayList<LinearRing2D> boundary = new ArrayList<LinearRing2D>();
        CirculinearBoundarySet2D<? extends LinearRing2D> boundary1 = polygon1.getBoundary();
        CirculinearBoundarySet2D<? extends LinearRing2D> boundary2 = polygon2.getBoundary();
        ArrayList<Point2D> intersections = new ArrayList<Point2D>();
        for (LinearRing2D ring1 : boundary1.getCurves()) {
            for (LinearRing2D ring2 : boundary2.getCurves()) {
                intersections.addAll(Polyline2DUtils.intersect(ring1, ring2));
            }
        }
        if (intersections.size() == 0) {
            if (!polygon1.contains(boundary2.getFirstPoint())) {
                boundary.addAll(boundary2.getCurves());
            }
            if (!polygon2.contains(boundary1.getFirstPoint())) {
                boundary.addAll(boundary1.getCurves());
            }
            return new MultiPolygon2D(boundary);
        }
        TreeSet<Double> positions1 = new TreeSet<Double>();
        TreeSet<Double> positions2 = new TreeSet<Double>();
        for (Point2D p : intersections) {
            positions1.add(new Double(boundary1.getPosition(p)));
            positions2.add(new Double(boundary2.getPosition(p)));
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        Point2D refPoint = (Point2D)intersections.iterator().next();
        points.add(refPoint);
        double pos = boundary1.getPosition(refPoint);
        double nextPos = Polygon2DUtils.findNext(positions1, pos);
        double middlePos = Polygon2DUtils.chooseBetween(pos, nextPos);
        Point2D middlePoint = boundary1.getPoint(middlePos);
        CirculinearBoundarySet2D<? extends LinearRing2D> currentBoundary = polygon2.contains(middlePoint) ? boundary2 : boundary1;
        boolean isOnFirstBoundary = !polygon2.contains(middlePoint);
        Point2D point = refPoint;
        do {
            if (!isOnFirstBoundary) continue;
            nextPos = Polygon2DUtils.findNext(positions1, pos);
        } while (point != refPoint);
        return null;
    }

    private static final <T> T findNext(SortedSet<T> set, T element) {
        SortedSet<T> tail = set.tailSet(element);
        return tail.isEmpty() ? set.first() : tail.first();
    }

    private static final double chooseBetween(double pos1, double pos2) {
        if (pos2 > pos1) {
            return pos1 + (pos2 - pos1) / 2.0;
        }
        return pos2 / 2.0;
    }
}

