/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.awt.Graphics2D;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.Boundary2DUtils;
import math.geom2d.domain.Domain2D;

public class GenericDomain2D
implements Domain2D {
    protected Boundary2D boundary = null;

    public GenericDomain2D(Boundary2D boundary) {
        this.boundary = boundary;
    }

    @Override
    public Boundary2D getBoundary() {
        return this.boundary;
    }

    @Override
    public Domain2D complement() {
        return new GenericDomain2D((Boundary2D)this.boundary.getReverseCurve());
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return Math.max(this.boundary.getSignedDistance(p.getX(), p.getY()), 0.0);
    }

    @Override
    public double getDistance(double x, double y) {
        return Math.max(this.boundary.getSignedDistance(x, y), 0.0);
    }

    @Override
    public boolean isBounded() {
        if (!this.boundary.isBounded()) {
            return false;
        }
        Box2D box = this.boundary.getBoundingBox();
        Point2D point = new Point2D(box.getMinX(), box.getMinY());
        return !this.boundary.isInside(point);
    }

    @Override
    public boolean isEmpty() {
        return this.boundary.isEmpty() && !this.contains(0.0, 0.0);
    }

    @Override
    public Domain2D clip(Box2D box) {
        return new GenericDomain2D(Boundary2DUtils.clipBoundary(this.getBoundary(), box));
    }

    @Override
    public Box2D getBoundingBox() {
        if (this.isBounded()) {
            return this.boundary.getBoundingBox();
        }
        return new Box2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public GenericDomain2D transform(AffineTransform2D trans) {
        Boundary2D transformed = (Boundary2D)this.boundary.transform(trans);
        if (!trans.isDirect()) {
            transformed = (Boundary2D)transformed.getReverseCurve();
        }
        return new GenericDomain2D(transformed);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.boundary.getSignedDistance(x, y) <= 0.0;
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public void draw(Graphics2D g2) {
        this.boundary.draw(g2);
    }

    @Override
    public void fill(Graphics2D g2) {
        this.boundary.fill(g2);
    }
}

