/*
 * Decompiled with CFR 0.152.
 */
package math.utils;

public class Matrix {
    private int nRows;
    private int nCols;
    private double[][] el;

    public Matrix() {
        this(1, 1);
    }

    public Matrix(int nbRows, int nbCols) {
        this.nRows = nbRows;
        this.nCols = nbCols;
        this.el = new double[this.nRows][this.nCols];
        this.setToIdentity();
    }

    public Matrix(double[][] coef) {
        if (coef == null) {
            this.nRows = 1;
            this.nCols = 1;
            this.el = new double[this.nRows][this.nCols];
            this.setToIdentity();
            return;
        }
        this.nRows = coef.length;
        this.nCols = coef[0].length;
        this.el = new double[this.nRows][this.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                this.el[r][c] = coef[r][c];
            }
        }
    }

    public double getCoef(int row, int col) {
        return this.el[row - 1][col - 1];
    }

    public int getRows() {
        return this.nRows;
    }

    public int getColumns() {
        return this.nCols;
    }

    public boolean isSquare() {
        return this.nCols == this.nRows;
    }

    public void setCoef(int row, int col, double coef) {
        this.el[row - 1][col - 1] = coef;
    }

    public Matrix multiplyWith(Matrix matrix) {
        if (this.nCols != matrix.nRows) {
            System.out.println("Matrices size don't match !");
            return null;
        }
        Matrix m = new Matrix(this.nRows, matrix.nCols);
        for (int r = 0; r < m.nRows; ++r) {
            for (int c = 0; c < m.nCols; ++c) {
                double sum = 0.0;
                for (int i = 0; i < this.nCols; ++i) {
                    sum += this.el[r][i] * matrix.el[i][c];
                }
                m.el[r][c] = sum;
            }
        }
        return m;
    }

    public double[] multiplyWith(double[] coefs) {
        if (coefs == null) {
            System.out.println("no data to compute");
            return null;
        }
        if (coefs.length != this.nCols) {
            System.out.println("Matrices size don't match !");
            return null;
        }
        double[] res = new double[this.nRows];
        for (int r = 0; r < this.nRows; ++r) {
            double sum = 0.0;
            for (int c = 0; c < this.nCols; ++c) {
                sum += this.el[r][c] * coefs[c];
            }
            res[r] = sum;
        }
        return res;
    }

    public double[] multiplyWith(double[] src, double[] res) {
        if (src == null) {
            System.out.println("no data to compute");
            return null;
        }
        if (src.length != this.nCols) {
            System.out.println("Matrices size don't match !");
            return null;
        }
        if (src.length != res.length) {
            res = new double[this.nRows];
        }
        for (int r = 0; r < this.nRows; ++r) {
            double sum = 0.0;
            for (int c = 0; c < this.nCols; ++c) {
                sum += this.el[r][c] * src[c];
            }
            res[r] = sum;
        }
        return res;
    }

    public void transpose() {
        int tmp = this.nCols;
        this.nCols = this.nRows;
        this.nRows = tmp;
        double[][] oldData = this.el;
        this.el = new double[this.nRows][this.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                this.el[r][c] = oldData[c][r];
            }
        }
    }

    public Matrix getTranspose() {
        Matrix mat = new Matrix(this.nCols, this.nRows);
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                mat.el[c][r] = this.el[r][c];
            }
        }
        return mat;
    }

    public double[] solve(double[] vector) {
        if (vector == null) {
            throw new NullPointerException();
        }
        if (vector.length != this.nRows) {
            System.out.println("matrix and vector dimensions do not match!");
            return null;
        }
        if (this.nCols != this.nRows) {
            System.out.println("Try to invert non square Matrix.");
            return null;
        }
        double[] res = new double[vector.length];
        for (int i = 0; i < this.nRows; ++i) {
            res[i] = vector[i];
        }
        Matrix mat = new Matrix(this.el);
        for (int r = 0; r < this.nRows; ++r) {
            int r2;
            double tmp;
            int c;
            int p;
            for (p = r; Math.abs(mat.el[p][r]) < 1.0E-15 && p <= this.nRows; ++p) {
            }
            if (p == this.nRows) {
                System.out.println("Degenerated linear system :");
                return null;
            }
            for (c = 0; c < this.nRows; ++c) {
                tmp = mat.el[r][c];
                mat.el[r][c] = mat.el[p][c];
                mat.el[p][c] = tmp;
            }
            tmp = res[r];
            res[r] = res[p];
            res[p] = tmp;
            double pivot = mat.el[r][r];
            c = r + 1;
            while (c < this.nRows) {
                double[] dArray = mat.el[r];
                int n = c++;
                dArray[n] = dArray[n] / pivot;
            }
            int n = r;
            res[n] = res[n] / pivot;
            mat.el[r][r] = 1.0;
            for (r2 = 0; r2 < r; ++r2) {
                pivot = mat.el[r2][r];
                for (c = r + 1; c < this.nRows; ++c) {
                    double[] dArray = mat.el[r2];
                    int n2 = c;
                    dArray[n2] = dArray[n2] - pivot * mat.el[r][c];
                }
                int n3 = r2;
                res[n3] = res[n3] - pivot * res[r];
                mat.el[r2][r] = 0.0;
            }
            for (r2 = r + 1; r2 < this.nRows; ++r2) {
                pivot = mat.el[r2][r];
                for (c = r + 1; c < this.nRows; ++c) {
                    double[] dArray = mat.el[r2];
                    int n4 = c;
                    dArray[n4] = dArray[n4] - pivot * mat.el[r][c];
                }
                int n5 = r2;
                res[n5] = res[n5] - pivot * res[r];
                mat.el[r2][r] = 0.0;
            }
        }
        return res;
    }

    public void setToIdentity() {
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                this.el[r][c] = 0.0;
            }
        }
        for (int i = Math.min(this.nRows, this.nCols) - 1; i >= 0; --i) {
            this.el[i][i] = 1.0;
        }
    }

    public String toString() {
        String res = new String("");
        res = res.concat("Matrix size : " + Integer.toString(this.nRows) + " rows and " + Integer.toString(this.nCols) + " columns.\n");
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                res = res.concat(Double.toString(this.el[r][c])).concat(" ");
            }
            res = res.concat(new String("\n"));
        }
        return res;
    }
}

