/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.sposh.debugger;

import cz.cuni.sposh.debugger.BreakpointManager;
import cz.cuni.sposh.debugger.OpenLapDebugger;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;

public class WatchLapAction
extends BooleanStateAction {
    private static final String BP_GROUP_NAME = "Open windows for new engines";
    private final JPDABreakpointListener evaluateListener = new DebuggerCreator();
    private final BreakpointManager breakpointManager;

    WatchLapAction() {
        this.setBooleanState(false);
        this.breakpointManager = BreakpointManager.createLapEvaluation(BP_GROUP_NAME);
        this.breakpointManager.purge();
    }

    public void actionPerformed(ActionEvent e) {
        this.setBooleanState(!this.getBooleanState());
        if (this.getBooleanState()) {
            this.breakpointManager.addListener(this.evaluateListener);
        } else {
            this.breakpointManager.removeListener(this.evaluateListener);
            this.breakpointManager.purge();
        }
    }

    protected String iconResource() {
        return "cz/cuni/sposh/debugger/dbg_watch.png";
    }

    public String getName() {
        return NbBundle.getMessage(WatchLapAction.class, (String)"CTL_WatchLapAction");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private static class DebuggerCreator
    implements JPDABreakpointListener {
        private Set<JPDAThread> engines = new HashSet<JPDAThread>();

        private DebuggerCreator() {
        }

        public void breakpointReached(JPDABreakpointEvent jpdabe) {
            JPDADebugger debugger = jpdabe.getDebugger();
            JPDAThread engineThread = jpdabe.getThread();
            if (this.engines.contains(engineThread)) {
                return;
            }
            this.engines.add(engineThread);
            SwingUtilities.invokeLater(new OpenLapDebugger(debugger, engineThread));
        }
    }
}

