/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.BaseTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class Test10_SyncAccessToInt
extends BaseTest {
    private int bogus;
    private CountDownLatch latch;
    private Object valueMutex = new Object();
    private int value = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        int threads = 40;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            int jobs = 1000;
            int add = 1000;
            this.latch = new CountDownLatch(jobs);
            for (int i = 0; i < jobs; ++i) {
                executor.execute(new IncReadDecValueAsync(add));
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
            log.info("Checking value, expecting 0 ...");
            if (this.value != 0) {
                this.testFailed("value == " + this.value + " != 0");
            }
            this.testOk();
        }
        finally {
            executor.shutdownNow();
        }
    }

    private class IncReadDecValueAsync
    implements Runnable {
        private int count;

        public IncReadDecValueAsync(int count) {
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                Object object = Test10_SyncAccessToInt.this.valueMutex;
                synchronized (object) {
                    ++Test10_SyncAccessToInt.this.value;
                }
                object = Test10_SyncAccessToInt.this.valueMutex;
                synchronized (object) {
                    ++Test10_SyncAccessToInt.this.bogus;
                }
                object = Test10_SyncAccessToInt.this.valueMutex;
                synchronized (object) {
                    --Test10_SyncAccessToInt.this.value;
                    continue;
                }
            }
            CountDownLatch countDownLatch = Test10_SyncAccessToInt.this.latch;
            synchronized (countDownLatch) {
                Test10_SyncAccessToInt.this.latch.countDown();
                log.info("Jobs remaining: " + Test10_SyncAccessToInt.this.latch.getCount());
            }
        }
    }
}

