/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class FilePath {
    public static final String CLASSPATH_SEPARATOR = ";";
    private static final String ALLOWED_RELATIVE_PATH_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._-/";
    private static final Set<String> ALLOWED_RELATIVE_PATH_CHARS_SET = new HashSet<String>();

    public static void checkRelativePath(String path) {
        if (path.contains("..")) {
            throw new PogamutException("Path '" + path + "' contains '..' at position " + path.indexOf("..") + " which is forbidden!", FilePath.class);
        }
        if (path.startsWith("/")) {
            throw new PogamutException("Path '" + path + "' can't start with '/'.", FilePath.class);
        }
        for (int i = 0; i < path.length(); ++i) {
            if (ALLOWED_RELATIVE_PATH_CHARS_SET.contains(path.substring(i, i + 1))) continue;
            throw new PogamutException("Path '" + path + "' contains forbidden character at index " + i + " (0-based). Allowed chars are limited to: " + ALLOWED_RELATIVE_PATH_CHARS, FilePath.class);
        }
    }

    public static void makeDirsToFile(File file) {
        String parent = file.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        }
    }

    public static String concatPaths(String ... paths) {
        if (paths == null) {
            return null;
        }
        if (paths.length == 0) {
            return null;
        }
        String result = paths[0];
        for (int i = 1; i < paths.length; ++i) {
            result = FilePath.concatPaths(result, paths[i]);
        }
        return result;
    }

    public static String concatPaths(String path1, String path2) {
        path1.replace("\\", "/");
        path2.replace("\\", "/");
        if (path1 == null) {
            return path2;
        }
        if (path1.equals("./")) {
            if (path2 == null) {
                return path1;
            }
            if (path2.startsWith("/")) {
                throw new PogamutException("Can't contact path '" + path1 + "' with '" + path2 + "' as path2 starts with '/'.", FilePath.class);
            }
            return path2;
        }
        if (path1.endsWith("/")) {
            if (path2 == null) {
                return path1;
            }
            if (path2.startsWith("./")) {
                return path1 + path2.substring(2);
            }
            if (path2.startsWith("/")) {
                throw new PogamutException("Can't contact path '" + path1 + "' with '" + path2 + "' as path2 starts with '/'.", FilePath.class);
            }
            return path1 + path2;
        }
        if (path2 == null) {
            return path1;
        }
        if (path2.startsWith("./")) {
            return path1 + "/" + path2.substring(2);
        }
        if (path2.startsWith("/")) {
            throw new PogamutException("Can't contact path '" + path1 + "' with '" + path2 + "' as path2 starts with '/'.", FilePath.class);
        }
        return path1 + "/" + path2;
    }

    public static String makeUniform(String file) {
        if (file == null) {
            return null;
        }
        for (int i = 0; i < file.length(); ++i) {
            if (file.charAt(i) != '\\') continue;
            file = file.substring(0, i) + "/" + file.substring(i + 1);
        }
        file = file.replaceAll("//", "/");
        while (file.length() > 0 && file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
        }
        while (file.startsWith("./")) {
            file = file.substring(2);
        }
        if (file.length() == 0) {
            return null;
        }
        return file;
    }

    static {
        for (int i = 0; i < ALLOWED_RELATIVE_PATH_CHARS.length(); ++i) {
            ALLOWED_RELATIVE_PATH_CHARS_SET.add(ALLOWED_RELATIVE_PATH_CHARS.substring(i, i + 1));
        }
    }
}

