/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class WeakHashTriMap<PRIMARY_KEY, SECONDARY_KEY, TERTIARY_KEY, ITEM>
extends WeakHashMap<PRIMARY_KEY, Map<SECONDARY_KEY, Map<TERTIARY_KEY, ITEM>>> {
    private static final long serialVersionUID = 1L;
    private int secondaryCapacity;
    private int tertiaryCapacity;

    public WeakHashTriMap() {
        this.secondaryCapacity = 16;
        this.tertiaryCapacity = 16;
    }

    public WeakHashTriMap(int primaryCapacity, int secondaryCapacity, int tertiaryCapacity) {
        super(primaryCapacity);
        this.secondaryCapacity = secondaryCapacity;
        this.tertiaryCapacity = tertiaryCapacity;
    }

    @Override
    public Map<SECONDARY_KEY, Map<TERTIARY_KEY, ITEM>> get(Object primaryKey) {
        Map result = (Map)super.get(primaryKey);
        if (result != null) {
            return result;
        }
        result = Collections.synchronizedMap(new HashMapMap(this.secondaryCapacity, this.tertiaryCapacity));
        super.put(primaryKey, result);
        return result;
    }

    public Map<TERTIARY_KEY, ITEM> get(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey) {
        Map result = (Map)this.get(primaryKey).get(secondaryKey);
        if (result != null) {
            return result;
        }
        result = Collections.synchronizedMap(new HashMap(this.tertiaryCapacity));
        this.get(primaryKey).put(secondaryKey, result);
        return result;
    }

    public ITEM get(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey) {
        return this.get(primaryKey, secondaryKey).get(tertiaryKey);
    }

    public void put(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey, ITEM item) {
        this.get(primaryKey, secondaryKey).put(tertiaryKey, item);
    }

    @Override
    public Map<SECONDARY_KEY, Map<TERTIARY_KEY, ITEM>> remove(Object primaryKey) {
        Map result = (Map)super.remove(primaryKey);
        if (result != null) {
            return result;
        }
        return Collections.synchronizedMap(new HashMapMap(this.secondaryCapacity, this.tertiaryCapacity));
    }

    public Map<TERTIARY_KEY, ITEM> remove(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey) {
        Map result = (Map)this.get(primaryKey).remove(secondaryKey);
        if (result != null) {
            return result;
        }
        return Collections.synchronizedMap(new HashMap(this.tertiaryCapacity));
    }

    public ITEM remove(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey) {
        return this.get(primaryKey, secondaryKey).remove(tertiaryKey);
    }
}

