/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaintContext;

public class PatternPaint
implements Paint {
    private GraphicsNode node;
    private Rectangle2D patternRegion;
    private AffineTransform patternTransform;
    private Filter tile;
    private boolean overflow;

    public PatternPaint(GraphicsNode node, Rectangle2D patternRegion, boolean overflow, AffineTransform patternTransform) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (patternRegion == null) {
            throw new IllegalArgumentException();
        }
        this.node = node;
        this.patternRegion = patternRegion;
        this.overflow = overflow;
        this.patternTransform = patternTransform;
        CompositeGraphicsNode comp = new CompositeGraphicsNode();
        comp.getChildren().add(node);
        Filter gnr = comp.getGraphicsNodeRable(true);
        Rectangle2D padBounds = (Rectangle2D)patternRegion.clone();
        if (overflow) {
            Rectangle2D nodeBounds = comp.getBounds();
            padBounds.add(nodeBounds);
        }
        this.tile = new PadRable8Bit(gnr, padBounds, PadMode.ZERO_PAD);
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public Rectangle2D getPatternRect() {
        return (Rectangle2D)this.patternRegion.clone();
    }

    public AffineTransform getPatternTransform() {
        return this.patternTransform;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (this.patternTransform != null) {
            xform = new AffineTransform(xform);
            xform.concatenate(this.patternTransform);
            try {
                AffineTransform patternTransformInv = this.patternTransform.createInverse();
                userBounds = patternTransformInv.createTransformedShape(userBounds).getBounds2D();
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
        }
        return new PatternPaintContext(cm, xform, hints, this.tile, this.patternRegion, userBounds, this.overflow);
    }

    public int getTransparency() {
        return 3;
    }
}

