/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JPEGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-1, -40, -1, -32};
    static final String[] exts = new String[]{"jpeg", "jpg"};
    static final String[] mimeTypes = new String[]{"image/jpeg", "image/jpg"};

    public JPEGRegistryEntry() {
        super("JPEG", exts, mimeTypes, 0, signature);
    }

    public Filter handleStream(InputStream inIS, ParsedURL origURL, boolean needRawData) {
        Object[] errParam;
        String errCode;
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        if (origURL != null) {
            errCode = "url.format.unreadable";
            errParam = new Object[]{"JPEG", origURL};
        } else {
            errCode = "stream.format.unreadable";
            errParam = new Object[]{"JPEG"};
        }
        Thread t = new Thread(){

            public void run() {
                Filter filt;
                try {
                    JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)is);
                    BufferedImage image = decoder.decodeAsBufferedImage();
                    CachableRed cr = GraphicsUtil.wrap(image);
                    cr = new Any2sRGBRed(cr);
                    WritableRaster wr = (WritableRaster)cr.getData();
                    ColorModel cm = cr.getColorModel();
                    image = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    cr = GraphicsUtil.wrap(image);
                    filt = new RedRable(cr);
                }
                catch (IOException ioe) {
                    filt = ImageTagRegistry.getBrokenLinkImage(this, errCode, errParam);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

