/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class DistantLight
extends AbstractLight {
    private double azimuth;
    private double elevation;
    private double Lx;
    private double Ly;
    private double Lz;

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public DistantLight(double azimuth, double elevation, Color color) {
        super(color);
        this.azimuth = azimuth;
        this.elevation = elevation;
        this.Lx = Math.cos(Math.PI * azimuth / 180.0) * Math.cos(Math.PI * elevation / 180.0);
        this.Ly = Math.sin(Math.PI * azimuth / 180.0) * Math.cos(Math.PI * elevation / 180.0);
        this.Lz = Math.sin(Math.PI * elevation / 180.0);
    }

    public boolean isConstant() {
        return true;
    }

    public void getLight(double x, double y, double z, double[] L) {
        L[0] = this.Lx;
        L[1] = this.Ly;
        L[2] = this.Lz;
    }

    public double[][] getLightRow(double x, double y, double dx, int width, double[][] z, double[][] lightRow) {
        Object ret = lightRow;
        if (ret == null) {
            ret = new double[width][];
            double[] CL = new double[]{this.Lx, this.Ly, this.Lz};
            int i = 0;
            while (i < width) {
                ret[i] = CL;
                ++i;
            }
        } else {
            double lx = this.Lx;
            double ly = this.Ly;
            double lz = this.Lz;
            int i = 0;
            while (i < width) {
                ret[i][0] = lx;
                ret[i][1] = ly;
                ret[i][2] = lz;
                ++i;
            }
        }
        return ret;
    }
}

