/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleDeclaration {
    protected static final int INITIAL_LENGTH = 8;
    protected Value[] values = new Value[8];
    protected int[] indexes = new int[8];
    protected boolean[] priorities = new boolean[8];
    protected int count;

    public int size() {
        return this.count;
    }

    public Value getValue(int idx) {
        return this.values[idx];
    }

    public int getIndex(int idx) {
        return this.indexes[idx];
    }

    public boolean getPriority(int idx) {
        return this.priorities[idx];
    }

    public void remove(int idx) {
        --this.count;
        int i = idx;
        while (i < this.count) {
            this.values[i] = this.values[i + 1];
            this.indexes[i] = this.indexes[i + 1];
            this.priorities[i] = this.priorities[i + 1];
            ++i;
        }
    }

    public void put(int idx, Value v, int i, boolean prio) {
        this.values[idx] = v;
        this.indexes[idx] = i;
        this.priorities[idx] = prio;
    }

    public void append(Value v, int idx, boolean prio) {
        if (this.values.length == this.count) {
            Value[] newval = new Value[this.count * 2];
            int[] newidx = new int[this.count * 2];
            boolean[] newprio = new boolean[this.count * 2];
            int i = 0;
            while (i < this.count) {
                newval[i] = this.values[i];
                newidx[i] = this.indexes[i];
                newprio[i] = this.priorities[i];
                ++i;
            }
            this.values = newval;
            this.indexes = newidx;
            this.priorities = newprio;
        }
        this.values[this.count] = v;
        this.indexes[this.count] = idx;
        this.priorities[this.count] = prio;
        ++this.count;
    }

    public String toString(CSSEngine eng) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.count) {
            sb.append(eng.getPropertyName(this.indexes[i]));
            sb.append(": ");
            sb.append(this.values[i]);
            sb.append(";\n");
            ++i;
        }
        return sb.toString();
    }

    static {
        INITIAL_LENGTH = 8;
    }
}

