/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.core.UsernameToken;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.filter.ExportSamlAssertionFilter;
import com.sun.xml.wss.impl.filter.ImportSamlAssertionFilter;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.NonceContainer;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuthenticationTokenFilter {
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    public static void processUserNameToken(FilterProcessingContext context) throws XWSSecurityException {
        if (context.isInboundMessage()) {
            AuthenticationTokenFilter.getUserNameTokenFromMessage(context);
        } else {
            AuthenticationTokenFilter.addUserNameTokenToMessage(context);
        }
    }

    public static void processSamlToken(FilterProcessingContext context) throws XWSSecurityException {
        if (context.isInboundMessage()) {
            ImportSamlAssertionFilter.process(context);
        } else {
            ExportSamlAssertionFilter.process(context);
        }
    }

    private static void getUserNameTokenFromMessage(FilterProcessingContext context) throws XWSSecurityException {
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        UsernameToken token = null;
        if (context.getMode() == 0) {
            AuthenticationTokenPolicy policy;
            if (context.makeDynamicPolicyCallback()) {
                try {
                    policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
                    AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
                    userNamePolicy.isReadOnly(true);
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(true);
                    DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(userNamePolicy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    policy.setFeatureBinding((AuthenticationTokenPolicy.UsernameTokenBinding)dynamicCallback.getSecurityPolicy());
                }
                catch (Exception e) {
                    throw new XWSSecurityException(e);
                }
            }
            policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
            NodeList nodeList = wsseSecurity.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
            if (nodeList.getLength() <= 0) {
                log.log(Level.SEVERE, "WSS1400.nousername.found");
                throw new XWSSecurityException("No Username token found ,Receiver requirement not met");
            }
            if (nodeList.getLength() > 1) {
                log.log(Level.SEVERE, "WSS1401.morethanone.username.found");
                throw new XWSSecurityException("More than one Username token found, Receiver requirement not met");
            }
            SOAPElement userNameTokenElement = (SOAPElement)nodeList.item(0);
            token = new UsernameToken(userNameTokenElement, policy.isBSP());
            token.isBSP(policy.isBSP());
        } else {
            if (context.getMode() == 1) {
                log.log(Level.SEVERE, "WSS1402.error.posthoc");
                throw new XWSSecurityException("Internal Error: Called UsernameTokenFilter in POSTHOC Mode");
            }
            try {
                token = new UsernameToken(wsseSecurity.getCurrentHeaderElement());
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, "WSS1403.import.username.token");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Exception while importing Username Password Token", ex);
            }
        }
        String username = token.getUsername();
        String password = token.getPassword();
        String passwordDigest = token.getPasswordDigest();
        String passwordType = token.getPasswordType();
        String nonce = token.getNonce();
        String created = token.getCreated();
        boolean authenticated = false;
        if (context.getMode() == 0) {
            AuthenticationTokenPolicy policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
            AuthenticationTokenPolicy.UsernameTokenBinding utBinding = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
            if (utBinding.getDigestOn() && passwordDigest == null) {
                log.log(Level.SEVERE, "WSS1404.notmet.digested");
                throw new XWSSecurityException("Receiver Requirement for Digested Password has not been met");
            }
            if (!utBinding.getDigestOn() && passwordDigest != null) {
                log.log(Level.SEVERE, "WSS1405.notmet.plaintext");
                throw new XWSSecurityException("Receiver Requirement for Plain-Text Password has not been met, Received token has Password-Digest");
            }
            if (utBinding.getUseNonce() && nonce == null) {
                log.log(Level.SEVERE, "WSS1406.notmet.nonce");
                throw new XWSSecurityException("Receiver Requirement for nonce has not been met");
            }
            if (!utBinding.getUseNonce() && nonce != null) {
                log.log(Level.SEVERE, "WSS1407.notmet.nononce");
                throw new XWSSecurityException("Receiver Requirement for no nonce has not been met, Received token has a nonce specified");
            }
        }
        try {
            authenticated = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" == passwordType ? context.getSecurityEnvironment().authenticateUser(context.getExtraneousProperties(), username, password) : context.getSecurityEnvironment().authenticateUser(context.getExtraneousProperties(), username, passwordDigest, nonce, created);
            if (!authenticated) {
                log.log(Level.SEVERE, "WSS1408.failed.sender.authentication");
                XWSSecurityException xwse = new XWSSecurityException("Invalid Username Password Pair");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Authentication of Username Password Token Failed", xwse);
            }
            long maxClockSkew = 300000L;
            long freshnessLmt = 300000L;
            long maxNonceAge = 900000L;
            if (context.getMode() == 0) {
                AuthenticationTokenPolicy authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
                AuthenticationTokenPolicy.UsernameTokenBinding policy = (AuthenticationTokenPolicy.UsernameTokenBinding)authPolicy.getFeatureBinding();
                if (created != null) {
                    try {
                        TimestampPolicy tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                        maxClockSkew = tPolicy.getMaxClockSkew();
                        freshnessLmt = tPolicy.getTimestampFreshness();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                maxNonceAge = policy.getMaxNonceAge();
            }
            if (created != null) {
                context.getSecurityEnvironment().validateCreationTime(context.getExtraneousProperties(), created, maxClockSkew, freshnessLmt);
            }
            if (nonce != null) {
                if (context.getHandler() != null) {
                    StaticPolicyContext pc = context.getPolicyContext();
                    String applicationId = null;
                    if (pc != null && pc instanceof StaticApplicationContext) {
                        applicationId = ((StaticApplicationContext)pc).getApplicationContextRoot();
                    }
                    if (applicationId != null && !AuthenticationTokenFilter.validateAndCacheNonce(applicationId, nonce, created, maxNonceAge)) {
                        XWSSecurityException xwse = new XWSSecurityException("Invalid/Repeated Nonce value for Username Token");
                        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid/Repeated Nonce value for Username Token", xwse);
                    }
                } else if (!context.getSecurityEnvironment().validateAndCacheNonce(nonce, created, maxNonceAge)) {
                    XWSSecurityException xwse = new XWSSecurityException("Invalid/Repeated Nonce value for Username Token");
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Invalid/Repeated Nonce value for Username Token", xwse);
                }
            }
        }
        catch (XWSSecurityException xwsse) {
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, xwsse.getMessage(), xwsse);
        }
        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), username, password);
    }

    public static AuthenticationTokenPolicy.UsernameTokenBinding resolveUserNameTokenData(FilterProcessingContext context, UsernameToken token, AuthenticationTokenPolicy policy) throws XWSSecurityException {
        if (!context.makeDynamicPolicyCallback()) {
            AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
            String userName = userNamePolicy.getUsername();
            String password = userNamePolicy.getPassword();
            if (userName == null || "".equals(userName)) {
                userName = context.getSecurityEnvironment().getUsername(context.getExtraneousProperties());
            }
            if (userName == null || "".equals(userName)) {
                log.log(Level.SEVERE, "WSS1409.error.creating.usernametoken");
                throw new XWSSecurityException("Username has not been set");
            }
            token.setUsername(userName);
            if (password == null || "".equals(password)) {
                password = context.getSecurityEnvironment().getPassword(context.getExtraneousProperties());
            }
            token.setPassword(password);
            return userNamePolicy;
        }
        try {
            AuthenticationTokenPolicy.UsernameTokenBinding userNamePolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)policy.getFeatureBinding();
            userNamePolicy.isReadOnly(true);
            DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
            dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
            dynamicContext.inBoundMessage(false);
            DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(userNamePolicy, dynamicContext);
            ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
            HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
            AuthenticationTokenPolicy.UsernameTokenBinding resolvedPolicy = (AuthenticationTokenPolicy.UsernameTokenBinding)dynamicCallback.getSecurityPolicy();
            token.setUsername(resolvedPolicy.getUsername());
            token.setPassword(resolvedPolicy.getPassword());
            return resolvedPolicy;
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public static void addUserNameTokenToMessage(FilterProcessingContext context) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy;
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        SOAPPart soapPart = secureMessage.getSOAPPart();
        UsernameToken token = new UsernameToken((Document)soapPart, "");
        AuthenticationTokenPolicy.UsernameTokenBinding policy = AuthenticationTokenFilter.resolveUserNameTokenData(context, token, authPolicy = (AuthenticationTokenPolicy)context.getSecurityPolicy());
        if (policy.getUseNonce()) {
            token.setNonce(policy.getNonce());
        }
        if (policy.getDigestOn()) {
            token.setDigestOn();
        }
        if (policy.getUseNonce() || policy.getDigestOn()) {
            String creationTime = "";
            try {
                TimestampPolicy tPolicy = (TimestampPolicy)policy.getFeatureBinding();
                creationTime = tPolicy.getCreationTime();
            }
            catch (Exception e) {
                // empty catch block
            }
            token.setCreationTime(creationTime);
        }
        SecurityHeader wsseSecurity = secureMessage.findOrCreateSecurityHeader();
        String wsuId = policy.getUUID();
        if (wsuId != null && !wsuId.equals("")) {
            XMLUtil.setWsuIdAttr((Element)token.getAsSoapElement(), wsuId);
        }
        wsseSecurity.insertHeaderBlock(token);
    }

    public static boolean validateAndCacheNonce(String applicationId, String nonce, String created, long maxNonceAge) {
        return NonceContainer.validateAndCacheNonce(applicationId, nonce, created, maxNonceAge);
    }
}

