/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;
import servlet.ApplyXSLTException;
import servlet.ApplyXSLTListener;
import servlet.ApplyXSLTProperties;
import servlet.DefaultApplyXSLTProperties;
import servlet.OrderedProps;
import servlet.PIA;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplyXSLT
extends HttpServlet {
    protected ApplyXSLTProperties ourDefaultParameters = null;
    public static final String EOL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final String ROOT = System.getProperty("server.root");
    public static String CURRENTDIR;
    protected OrderedProps ourMediaProps = null;
    protected static final String STYLESHEET_ATTRIBUTE = "media";
    protected static final String HEADER_NAME = "user-Agent";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (ROOT != null) {
            CURRENTDIR = this.getServletContext().getRealPath("/WEB-INF/classes/servlet/") + FS;
            System.out.println(CURRENTDIR);
        } else {
            CURRENTDIR = System.getProperty("user.dir") + FS;
        }
        this.setDefaultParameters(config);
        this.setMediaProps(config.getInitParameter("mediaURL"));
    }

    protected void setDefaultParameters(ServletConfig config) {
        this.ourDefaultParameters = new DefaultApplyXSLTProperties(config);
    }

    protected void setMediaProps(String mediaURLstring) {
        if (mediaURLstring != null) {
            URL url = null;
            try {
                url = new URL(mediaURLstring);
            }
            catch (MalformedURLException mue1) {
                try {
                    url = new URL("file", "", CURRENTDIR + mediaURLstring);
                }
                catch (MalformedURLException mue2) {
                    this.writeLog("Unable to find the media properties file based on parameter 'mediaURL' = " + mediaURLstring, 202, (Throwable)mue2);
                    url = null;
                }
            }
            if (url != null) {
                try {
                    this.ourMediaProps = new OrderedProps(url.openStream());
                }
                catch (IOException ioe1) {
                    this.writeLog("Exception occurred while opening media properties file: " + mediaURLstring + ".  Media table may be invalid.", 202, (Throwable)ioe1);
                }
            }
        } else {
            String defaultProp = CURRENTDIR + "media.properties";
            try {
                this.ourMediaProps = new OrderedProps((InputStream)new FileInputStream(defaultProp));
            }
            catch (IOException ioe2) {
                this.writeLog("Default media properties file " + defaultProp + " not found.", 202, (Throwable)ioe2);
            }
        }
    }

    public String getMedia(HttpServletRequest request) {
        return this.ourMediaProps.getValue(request.getHeader("user-Agent"));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            this.process(tFactory, request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process(TransformerFactory tFactory, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SAXException {
        boolean debug = this.ourDefaultParameters.isDebug(request);
        long time = 0L;
        if (debug) {
            time = System.currentTimeMillis();
        }
        ApplyXSLTListener listener = new ApplyXSLTListener();
        listener.out.println("debug is " + debug);
        StreamSource xmlSource = null;
        StreamSource xslSource = null;
        try {
            xmlSource = this.getDocument(request, listener);
            if (xmlSource == null) {
                throw new ApplyXSLTException("getDocument() returned null", (Exception)new NullPointerException(), 404);
            }
        }
        catch (ApplyXSLTException axe) {
            axe.appendMessage(EOL + "getDocument() resulted in ApplyXSLTException" + EOL + listener.getMessage());
            if (debug) {
                this.writeLog(axe);
            }
            this.displayException(response, axe, debug);
            xmlSource = null;
        }
        if (xmlSource != null) {
            block23: {
                try {
                    xslSource = this.getStylesheet(tFactory, request, xmlSource, listener);
                    if (xslSource == null) {
                        throw new ApplyXSLTException("getStylesheet() returned null", (Exception)new NullPointerException(), 404);
                    }
                    xmlSource = this.getDocument(request, listener);
                }
                catch (ApplyXSLTException axe) {
                    axe.appendMessage(EOL + "getStylesheet() resulted in ApplyXSLTException" + EOL + listener.getMessage());
                    if (debug) {
                        this.writeLog(axe);
                    }
                    this.displayException(response, axe, debug);
                    xslSource = null;
                }
                if (xmlSource != null && xslSource != null) {
                    try {
                        listener.out.println("Performing transformation...");
                        Templates templates = tFactory.newTemplates(xslSource);
                        Transformer transformer = templates.newTransformer();
                        try {
                            block22: {
                                try {
                                    String contentType = null;
                                    contentType = this.getContentType(templates);
                                    if (contentType != null) {
                                        // empty if block
                                    }
                                    response.setContentType(contentType);
                                    if (transformer instanceof TransformerImpl) {
                                        TransformerImpl transformerImpl = (TransformerImpl)transformer;
                                        transformerImpl.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(request));
                                    }
                                    this.setStylesheetParams(transformer, request);
                                    transformer.transform(xmlSource, new StreamResult((OutputStream)response.getOutputStream()));
                                    if (!debug) break block22;
                                    this.writeLog(listener.getMessage(), 200);
                                }
                                catch (Exception exc) {
                                    ApplyXSLTException axe = new ApplyXSLTException("Exception occurred during Transformation:" + EOL + listener.getMessage() + EOL + exc.getMessage(), exc, 500);
                                    if (debug) {
                                        this.writeLog(axe);
                                    }
                                    this.displayException(response, axe, debug);
                                    Object var15_20 = null;
                                    break block23;
                                }
                            }
                            Object var15_19 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_21 = null;
                            throw throwable;
                        }
                    }
                    catch (Exception saxExc) {
                        ApplyXSLTException axe = new ApplyXSLTException("Exception occurred during ctor/Transformation:" + EOL + listener.getMessage() + EOL + saxExc.getMessage(), saxExc, 500);
                        if (debug) {
                            this.writeLog(axe);
                        }
                        this.displayException(response, axe, debug);
                    }
                }
            }
            if (debug) {
                time = System.currentTimeMillis() - time;
                this.writeLog("  No Conflict Warnings = " + this.ourDefaultParameters.isNoCW(request) + "  Transformation time: " + time + " ms", 200);
            }
        }
    }

    protected StreamSource getDocument(HttpServletRequest request, ApplyXSLTListener listener) throws ApplyXSLTException {
        try {
            String xmlURL = null;
            xmlURL = request.getPathInfo();
            if (xmlURL != null) {
                listener.out.println("Parsing XML Document from PathInfo: " + xmlURL);
                return new StreamSource(new URL("http", ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getLocalHost(), request.getServerPort(), xmlURL.replace('\\', '/')).openStream());
            }
            xmlURL = this.ourDefaultParameters.getXMLurl(request);
            if (xmlURL != null) {
                listener.out.println("Parsing XML Document from request parameter: " + xmlURL);
                return new StreamSource(new URL(xmlURL).openStream());
            }
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("text/xml")) {
                listener.out.println("Parsing XML Document from request chain");
                return new StreamSource((InputStream)request.getInputStream());
            }
        }
        catch (IOException ioe) {
            throw new ApplyXSLTException((Exception)ioe, 404);
        }
        catch (Exception e) {
            throw new ApplyXSLTException(e, 500);
        }
        return null;
    }

    protected StreamSource getStylesheet(TransformerFactory tFactory, HttpServletRequest request, StreamSource xmlSource, ApplyXSLTListener listener) throws ApplyXSLTException {
        try {
            String xslURL = ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getXSLRequestURL(request);
            if (xslURL != null) {
                listener.out.println("Parsing XSL Stylesheet Document from request parameter: " + xslURL);
            } else {
                if (xmlSource != null) {
                    listener.out.println("calling getXSLURLfromDoc and getMedia " + this.getMedia(request));
                    xslURL = ApplyXSLT.getXSLURLfromDoc((StreamSource)xmlSource, (String)"media", (String)this.getMedia(request), (TransformerFactory)tFactory);
                }
                if (xslURL != null) {
                    listener.out.println("Parsing XSL Stylesheet Document from XML Document tag: " + xslURL);
                } else {
                    xslURL = this.ourDefaultParameters.getXSLurl(null);
                    if (xslURL != null) {
                        listener.out.println("Parsing XSL Stylesheet Document from configuration: " + xslURL);
                    }
                }
            }
            return new StreamSource(xslURL);
        }
        catch (IOException ioe) {
            throw new ApplyXSLTException((Exception)ioe, 404);
        }
        catch (Exception e) {
            throw new ApplyXSLTException(e, 500);
        }
    }

    public String getContentType(Templates templates) {
        Properties oprops = templates.getOutputProperties();
        String encoding = oprops.getProperty("encoding");
        String media = oprops.getProperty("media-type");
        if (media != null) {
            if (encoding != null) {
                return media + "; charset=" + encoding;
            }
            return media;
        }
        String method = oprops.getProperty("method");
        if (method.equals("html")) {
            return "text/html";
        }
        if (method.equals("text")) {
            return "text/plain";
        }
        return "text/xml";
    }

    public void setStylesheetParams(Transformer transformer, HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            try {
                String[] paramVals = request.getParameterValues(paramName);
                if (paramVals == null) continue;
                transformer.setParameter(paramName, new XString(paramVals[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            transformer.setParameter("servlet-RemoteAddr", new XString(request.getRemoteAddr()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            transformer.setParameter("servlet-RemoteHost", new XString(request.getRemoteHost()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            transformer.setParameter("servlet-RemoteUser", new XString(request.getRemoteUser()));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void writeLog(ApplyXSLTException axe) {
        this.writeLog(axe.getMessage(), axe.getStatusCode(), (Throwable)axe.getException());
    }

    protected void writeLog(String msg, int statusCode, Throwable t) {
        if (t == null) {
            this.writeLog(msg, statusCode);
        } else {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes, true);
            System.out.println("Exception is " + t.getClass().getName());
            t.printStackTrace(writer);
            this.log("HTTP Status Code: " + statusCode + " - " + msg + EOL + bytes.toString());
        }
    }

    protected void writeLog(String msg, int statusCode) {
        this.log("HTTP Status Code: " + statusCode + " - " + msg);
    }

    protected void displayException(HttpServletResponse response, ApplyXSLTException xse, boolean debug) {
        String mesg = xse.getMessage();
        mesg = mesg == null ? "" : "<B>" + mesg + "</B>";
        StringTokenizer tokens = new StringTokenizer(mesg, EOL);
        StringBuffer strBuf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            strBuf.append(tokens.nextToken() + EOL + "<BR>");
        }
        mesg = strBuf.toString();
        if (debug) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes, true);
            xse.getException().printStackTrace(writer);
            mesg = mesg + " <PRE> " + bytes.toString() + " </PRE> ";
        }
        response.setContentType("text/html");
        try {
            response.sendError(xse.getStatusCode(), mesg);
        }
        catch (IOException ioe) {
            System.err.println("IOException is occurring when sendError is called");
        }
    }

    protected URLConnection toAcceptLanguageConnection(URL url, HttpServletRequest request) throws Exception {
        URLConnection tempConnection = url.openConnection();
        tempConnection.setRequestProperty("Accept-Language", request.getHeader("Accept-Language"));
        return tempConnection;
    }

    public static String getXSLURLfromDoc(StreamSource xmlSource, String attributeName, String attributeValue, TransformerFactory tFactory) {
        String tempURL = null;
        String returnURL = null;
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document sourceTree = docBuilder.parse(xmlSource.getInputStream());
            Node child = sourceTree.getFirstChild();
            while (null != child) {
                PIA pia;
                ProcessingInstruction pi;
                if (7 == child.getNodeType() && (pi = (ProcessingInstruction)child).getNodeName().equals("xml-stylesheet") && "text/xsl".equals((pia = new PIA(pi)).getAttribute("type"))) {
                    tempURL = pia.getAttribute("href");
                    String attribute = pia.getAttribute(attributeName);
                    if (attribute != null && attribute.indexOf(attributeValue) > -1) {
                        return tempURL;
                    }
                    if (!"yes".equals(pia.getAttribute("alternate"))) {
                        returnURL = tempURL;
                    }
                }
                child = child.getNextSibling();
            }
        }
        catch (Exception saxExc) {
            // empty catch block
        }
        return returnURL;
    }
}

