/*
 * Decompiled with CFR 0.152.
 */
package wicket.spring.common;

import java.util.Collection;
import wicket.spring.common.Contact;

public class ContactGenerator {
    private static ContactGenerator instance = new ContactGenerator();
    private static long nextId = 1L;
    private String[] firstNames = new String[]{"Jacob", "Emily", "Michael", "Sarah", "Matthew", "Brianna", "Nicholas", "Samantha", "Christopher", "Hailey", "Abner", "Abby", "Joshua", "Douglas", "Jack", "Keith", "Gerald", "Samuel", "Willie", "Larry", "Jose", "Timothy", "Sandra", "Kathleen", "Pamela", "Virginia", "Debra", "Maria", "Linda"};
    private String[] lastNames = new String[]{"Smiith", "Johnson", "Williams", "Jones", "Brown", "Donahue", "Bailey", "Rose", "Allen", "Black", "Davis", "Clark", "Hall", "Lee", "Baker", "Gonzalez", "Nelson", "Moore", "Wilson", "Graham", "Fisher", "Cruz", "Ortiz", "Gomez", "Murray"};

    public static ContactGenerator getInstance() {
        return instance;
    }

    private ContactGenerator() {
    }

    public synchronized long generateId() {
        return nextId++;
    }

    public Contact generate() {
        Contact contact = new Contact(this.randomString(this.firstNames), this.randomString(this.lastNames));
        contact.setId(this.generateId());
        contact.setHomePhone(this.generatePhoneNumber());
        contact.setCellPhone(this.generatePhoneNumber());
        return contact;
    }

    public void generate(Collection collection, int count) {
        for (int i = 0; i < count; ++i) {
            collection.add(this.generate());
        }
    }

    private String generatePhoneNumber() {
        return "" + this.rint(2, 9) + this.rint(0, 9) + this.rint(0, 9) + "-555-" + this.rint(1, 9) + this.rint(0, 9) + this.rint(0, 9) + this.rint(0, 9);
    }

    private int rint(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private String randomString(String[] choices) {
        return choices[this.rint(0, choices.length)];
    }
}

