/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag;

import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.analyzer.IUT2004AnalyzerObserver;
import cz.cuni.amis.pogamut.ut2004.analyzer.UT2004Analyzer;
import cz.cuni.amis.pogamut.ut2004.analyzer.stats.UT2004AnalyzerObsStats;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StartPlayers;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapFinished;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScoreMessage;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.tournament.botexecution.UT2004BotExecution;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlagConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag.UT2004CaptureTheFlagResult;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004Match;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchResult;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FilePath;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004CaptureTheFlag
extends UT2004Match<UT2004CaptureTheFlagConfig, UT2004CaptureTheFlagResult> {
    public UT2004CaptureTheFlag(UT2004CaptureTheFlagConfig config, LogCategory log) {
        super(false, config, log);
    }

    @Override
    protected UT2004MatchResult waitMatchFinish(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, long timeoutInMillis) {
        UT2004CaptureTheFlagResult uT2004CaptureTheFlagResult;
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Waiting for the match to finish...");
        }
        if ((long)(((UT2004CaptureTheFlagConfig)this.config).getTimeLimit() * 60 * 1000 + 300000) > timeoutInMillis) {
            timeoutInMillis = ((UT2004CaptureTheFlagConfig)this.config).getTimeLimit() * 60 * 1000 + 300000;
        }
        HashMap<IToken, 3> customBotObservers = new HashMap<IToken, 3>(((UT2004CaptureTheFlagConfig)this.config).getBots().size());
        FlagListener<IAgentState> serverObs = null;
        FlagListener<Boolean> uccObs = null;
        IWorldEventListener<PlayerScore> scoresListener = null;
        IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> teamScoresListener = null;
        IWorldEventListener<MapFinished> mapFinishedListener = null;
        final CountDownLatch waitLatch = new CountDownLatch(1);
        final AdaptableProvider oneOfBotsDiedOut = new AdaptableProvider((Object)false);
        final AdaptableProvider serverDiedOut = new AdaptableProvider((Object)false);
        final HashMap<UnrealId, PlayerScore> scores = new HashMap<UnrealId, PlayerScore>();
        final HashMap<Integer, TeamScore> teamScores = new HashMap<Integer, TeamScore>();
        boolean exception = false;
        try {
            teamScores.put(0, (TeamScore)new TeamScoreMessage(UnrealId.get((String)"TEAM0"), Integer.valueOf(0), Integer.valueOf(0)));
            teamScores.put(1, (TeamScore)new TeamScoreMessage(UnrealId.get((String)"TEAM1"), Integer.valueOf(1), Integer.valueOf(0)));
            serverDiedOut.set((Object)false);
            scoresListener = new IWorldEventListener<PlayerScore>(){

                public void notify(PlayerScore event) {
                    scores.put(event.getId(), event);
                }
            };
            ((UT2004WorldView)server.getWorldView()).addEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
            teamScoresListener = new IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>>(){

                public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
                    if (event.getObject() == null) {
                        return;
                    }
                    int team = ((TeamScore)event.getObject()).getTeam();
                    teamScores.put(team, event.getObject());
                }
            };
            ((UT2004WorldView)server.getWorldView()).addObjectListener(TeamScore.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)teamScoresListener);
            for (UT2004BotConfig botConfig : ((UT2004CaptureTheFlagConfig)this.config).getBots().values()) {
                FlagListener<Boolean> obs = new FlagListener<Boolean>(){

                    public void flagChanged(Boolean changedValue) {
                        if (!changedValue.booleanValue()) {
                            oneOfBotsDiedOut.set((Object)true);
                            waitLatch.countDown();
                        }
                    }
                };
                bots.bots.get(botConfig.getBotId()).getRunning().addListener((FlagListener)obs);
                customBotObservers.put(botConfig.getBotId(), obs);
                if (((Boolean)bots.bots.get(botConfig.getBotId()).getRunning().getFlag()).booleanValue()) continue;
                oneOfBotsDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("One of custom bots died out from the start, failure!", (Logger)this.log, (Object)this);
            }
            serverObs = new FlagListener<IAgentState>(){

                public void flagChanged(IAgentState changedValue) {
                    if (changedValue instanceof IAgentStateDown) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            server.getState().addListener((FlagListener)serverObs);
            mapFinishedListener = new IWorldEventListener<MapFinished>(){

                public void notify(MapFinished event) {
                    UT2004CaptureTheFlag.this.log.info("MapFinished event received.");
                    waitLatch.countDown();
                }
            };
            ((UT2004WorldView)server.getWorldView()).addEventListener(MapFinished.class, (IWorldEventListener)mapFinishedListener);
            if (server.notInState(new Class[]{IAgentStateUp.class})) {
                serverDiedOut.set((Object)true);
                waitLatch.countDown();
                throw new PogamutException("Server is dead from the start, failure!", (Logger)this.log, (Object)this);
            }
            uccObs = new FlagListener<Boolean>(){

                public void flagChanged(Boolean changedValue) {
                    if (changedValue.booleanValue()) {
                        serverDiedOut.set((Object)true);
                        waitLatch.countDown();
                    }
                }
            };
            ucc.getGameEnding().addListener((FlagListener)uccObs);
            waitLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            if (waitLatch.getCount() > 0L) {
                throw new PogamutException("TIMEOUT! The match did not end in " + timeoutInMillis / 1000L + " secs.", (Logger)this.log, (Object)this);
            }
            bots.matchEnd = System.currentTimeMillis();
            if (((Boolean)oneOfBotsDiedOut.get()).booleanValue()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while giving GB2004 time to tear down its connection.", (Logger)this.log, (Object)this);
                }
                try {
                    server.getAct().act((CommandMessage)new StartPlayers());
                }
                catch (Exception e) {
                    serverDiedOut.set((Object)true);
                }
                if (!((Boolean)serverDiedOut.get()).booleanValue()) {
                    this.log.warning("ONE OF BOTS HAS DIED OUT, BUT SERVER IS STILL RUNNING ... POSSIBLE MATCH FAILURE!");
                }
            }
            if (!((Boolean)serverDiedOut.get()).booleanValue() && server.inState(new Class[]{IAgentStateUp.class})) {
                server.kill();
            }
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ucc.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ArrayList<Integer> winners = new ArrayList<Integer>(1);
            int maxScore = 0;
            for (Map.Entry entry : teamScores.entrySet()) {
                if (entry.getValue() == null || ((TeamScore)entry.getValue()).getScore() == null) {
                    throw new PogamutException("There is a team '" + entry.getKey() + "' that has NULL score!", (Object)this);
                }
                if (((TeamScore)entry.getValue()).getScore() == maxScore) {
                    winners.add(((TeamScore)entry.getValue()).getTeam());
                    continue;
                }
                if (((TeamScore)entry.getValue()).getScore() <= maxScore) continue;
                winners.clear();
                winners.add(((TeamScore)entry.getValue()).getTeam());
                maxScore = ((TeamScore)entry.getValue()).getScore();
            }
            if (winners.size() == 0) {
                throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
            }
            if (winners.size() > 1) {
                StringBuffer sb = new StringBuffer();
                sb.append("There is more than one team with highest score == " + maxScore + ": ");
                boolean first = true;
                for (Integer id : winners) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("Team[" + id + "]");
                }
                sb.append(".");
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(sb.toString());
                }
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": MATCH FINISHED!");
            }
            uT2004CaptureTheFlagResult = this.processResults(ucc, server, analyzer, bots, winners, scores, teamScores);
        }
        catch (Exception e) {
            try {
                exception = true;
                throw new PogamutException("Failed to perform the match!", (Throwable)e, (Logger)this.log, (Object)this);
            }
            catch (Throwable throwable) {
                for (Map.Entry entry : customBotObservers.entrySet()) {
                    bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
                }
                server.getState().removeListener(serverObs);
                ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, scoresListener);
                throw throwable;
            }
        }
        for (Map.Entry entry : customBotObservers.entrySet()) {
            bots.bots.get(entry.getKey()).getRunning().removeListener((FlagListener)entry.getValue());
        }
        server.getState().removeListener((FlagListener)serverObs);
        ((UT2004WorldView)server.getWorldView()).removeEventListener(PlayerScore.class, (IWorldEventListener)scoresListener);
        return uT2004CaptureTheFlagResult;
    }

    protected UT2004CaptureTheFlagResult processResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, List<Integer> winners, Map<UnrealId, PlayerScore> finalScores, Map<Integer, TeamScore> teamScores) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Processing results...");
        }
        UT2004CaptureTheFlagResult result = new UT2004CaptureTheFlagResult();
        result.setMatchTimeEnd(((double)bots.matchEnd - (double)bots.matchStart) / 1000.0);
        for (Map.Entry<Integer, TeamScore> entry : teamScores.entrySet()) {
            result.getTeamScores().put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, TeamScore> entry : finalScores.entrySet()) {
            result.getFinalScores().put(bots.getBotId((UnrealId)entry.getKey()), (PlayerScore)entry.getValue());
        }
        for (Map.Entry<Integer, TeamScore> entry : bots.botObservers.entrySet()) {
            if (!(entry.getValue() instanceof UT2004AnalyzerObsStats)) {
                throw new PogamutException("There is an observer of wrong class, expecting UT2004AnalyzerObsStats, got " + ((IUT2004AnalyzerObserver)entry.getValue()).getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
            }
            result.getBotObservers().put((IToken)entry.getKey(), (UT2004AnalyzerObsStats)entry.getValue());
        }
        List<IToken> botIds = ((UT2004CaptureTheFlagConfig)this.config).getAllBotIds();
        for (IToken iToken : botIds) {
            result.getTotalKills().put(iToken, 0);
            result.getWasKilled().put(iToken, 0);
            result.getSuicides().put(iToken, 0);
            for (IToken botId2 : botIds) {
                result.getKillCounts().put((Object)iToken, (Object)botId2, (Object)0);
            }
        }
        for (Map.Entry<IToken, UT2004AnalyzerObsStats> entry : result.getBotObservers().entrySet()) {
            IToken botId = entry.getKey();
            UT2004AnalyzerObsStats obs = entry.getValue();
            AgentStats stats = obs.getStats();
            for (Map.Entry killed : stats.getKilled().entrySet()) {
                result.getKillCounts().get((Object)botId).put(bots.getBotId((UnrealId)killed.getKey()), killed.getValue());
            }
            for (Map.Entry killedBy : stats.getKilledBy().entrySet()) {
                if (!bots.isNativeBot((UnrealId)killedBy.getKey())) continue;
                result.getKillCounts().get((Object)bots.getBotId((UnrealId)killedBy.getKey())).put(botId, killedBy.getValue());
            }
            result.getSuicides().put(botId, stats.getSuicides());
            result.getKillCounts().put((Object)botId, (Object)botId, (Object)stats.getSuicides());
        }
        for (IToken iToken : ((UT2004CaptureTheFlagConfig)this.config).getNativeBots().keySet()) {
            for (IToken nativeBotId2 : ((UT2004CaptureTheFlagConfig)this.config).getNativeBots().keySet()) {
                if (iToken == nativeBotId2) continue;
                result.getKillCounts().get((Object)iToken).put(nativeBotId2, 0);
            }
            result.getSuicides().put(iToken, 0);
        }
        for (IToken iToken : botIds) {
            int totalKills = 0;
            int totalKilled = 0;
            for (IToken other : botIds) {
                if (iToken == other) continue;
                totalKills += ((Integer)result.getKillCounts().get((Object)iToken, (Object)other)).intValue();
                totalKilled += ((Integer)result.getKillCounts().get((Object)other, (Object)iToken)).intValue();
            }
            result.getTotalKills().put(iToken, totalKills);
            result.getWasKilled().put(iToken, totalKilled);
            if (!((UT2004CaptureTheFlagConfig)this.config).isNativeBot(iToken)) continue;
            result.getSuicides().put(iToken, result.getFinalScores().get(iToken).getDeaths() - totalKilled);
        }
        if (winners.size() <= 0) {
            throw new PogamutException("There is no winner, impossible! **puzzled**", (Logger)this.log, (Object)this);
        }
        if (winners.size() == 1) {
            result.setWinnerTeam(winners.get(0));
        } else {
            result.setDraw(true);
        }
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.warning(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Results processed, " + (result.isDraw() ? "DRAW!" : "winner is Team[" + winners.get(0) + "]."));
        }
        return result;
    }

    protected void outputResults_step1(UT2004CaptureTheFlagResult result, File outputDirectory) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Outputting match result into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + "-result.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            Formatter writer = new Formatter(file);
            writer.format("MatchId;ScoreLimit;TimeLimit;TimeEnd;Winner\n", new Object[0]);
            writer.format("%s;%d;%d;%.3f;%s", ((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken(), ((UT2004CaptureTheFlagConfig)this.config).getScoreLimit(), ((UT2004CaptureTheFlagConfig)this.config).getTimeLimit(), result.getMatchTimeEnd(), result.isDraw() ? "DRAW" : "TEAM" + String.valueOf(result.getWinnerTeam()));
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Match result output into " + file.getAbsolutePath() + ".");
        }
    }

    protected void outputResults_step2(UT2004CaptureTheFlagResult result, File outputDirectory) {
        Formatter writer;
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Outputting match scores into CSV file...");
        }
        File file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + "-team-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            writer = new Formatter(file);
            ArrayList<TeamScore> teams = new ArrayList<TeamScore>();
            for (TeamScore score : result.getTeamScores().values()) {
                teams.add(score);
            }
            Collections.sort(teams, new Comparator<TeamScore>(){

                @Override
                public int compare(TeamScore o1, TeamScore o2) {
                    return o1.getTeam().compareTo(o2.getTeam());
                }
            });
            writer.format("teamId", new Object[0]);
            writer.format(";score", new Object[0]);
            for (TeamScore score : teams) {
                writer.format("\n", new Object[0]);
                writer.format("%s", "TEAM" + score.getTeam());
                writer.format(";%d", score.getScore());
            }
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        file = new File(outputDirectory.getAbsolutePath() + File.separator + "match-" + ((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + "-bot-scores.csv");
        FilePath.makeDirsToFile((File)file);
        try {
            writer = new Formatter(file);
            ArrayList<IToken> bots = new ArrayList<IToken>(((UT2004CaptureTheFlagConfig)this.config).getBots().keySet());
            ArrayList<IToken> nativeBots = new ArrayList<IToken>(((UT2004CaptureTheFlagConfig)this.config).getNativeBots().keySet());
            Collections.sort(bots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            Collections.sort(nativeBots, new Comparator<IToken>(){

                @Override
                public int compare(IToken o1, IToken o2) {
                    return o1.getToken().compareTo(o2.getToken());
                }
            });
            result.setBots(bots);
            result.setNativeBots(nativeBots);
            writer.format("botId", new Object[0]);
            writer.format(";score;kills;killedByOthers;deaths;suicides", new Object[0]);
            for (IToken token : ((UT2004CaptureTheFlagConfig)this.config).getAllBotIds()) {
                writer.format(";", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
            }
            for (IToken token : ((UT2004CaptureTheFlagConfig)this.config).getAllBotIds()) {
                writer.format("\n", new Object[0]);
                writer.format(token.getToken(), new Object[0]);
                writer.format(";%d", result.getFinalScores().get(token).getScore());
                writer.format(";%d", result.getTotalKills().get(token));
                writer.format(";%d", result.getWasKilled().get(token));
                writer.format(";%d", result.getFinalScores().get(token).getDeaths());
                writer.format(";%d", result.getSuicides().get(token));
                for (IToken token2 : ((UT2004CaptureTheFlagConfig)this.config).getAllBotIds()) {
                    writer.format(";%d", result.getKillCounts().get((Object)token).get(token2));
                }
            }
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        catch (IOException e) {
            throw new PogamutIOException("Failed to write results!", (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Match scores output into " + file.getAbsolutePath() + ".");
        }
    }

    @Override
    protected void outputResults(UCCWrapper ucc, UT2004Server server, UT2004Analyzer analyzer, UT2004Match.Bots bots, UT2004MatchResult result, File outputDirectory) {
        if (!(result instanceof UT2004CaptureTheFlagResult)) {
            throw new PogamutException("Can't out results! Expected results of class UT2004CaptureTheFlagResult and got " + result.getClass().getSimpleName() + "!", (Logger)this.log, (Object)this);
        }
        this.outputResults_step1((UT2004CaptureTheFlagResult)result, outputDirectory);
        this.outputResults_step2((UT2004CaptureTheFlagResult)result, outputDirectory);
    }

    @Override
    public UT2004CaptureTheFlagResult execute() {
        try {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Executing!");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UCCWrapper ucc = null;
        UT2004Server server = null;
        UT2004Match.Bots bots = null;
        UT2004Analyzer analyzer = null;
        String recordFileName = ((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + "-replay-" + UT2004Match.getCurrentDate();
        boolean exception = false;
        try {
            this.setupLogger();
            this.validate();
            this.createGB2004Ini();
            ucc = this.startUCC();
            server = this.startControlServer(ucc);
            bots = this.startBots(ucc, server);
            analyzer = this.startAnalyzer(ucc, bots, this.getOutputPath("bots"), false);
            this.matchIsAboutToBegin(ucc, server, analyzer, bots);
            this.restartMatch(server, bots);
            this.recordReplay(server, recordFileName);
            UT2004CaptureTheFlagResult result = (UT2004CaptureTheFlagResult)this.waitMatchFinish(ucc, server, analyzer, bots, ((UT2004CaptureTheFlagConfig)this.config).getTimeLimit() * 1000 + 60000);
            this.copyReplay(ucc, recordFileName, this.getOutputPath());
            this.outputResults(ucc, server, analyzer, bots, result, this.getOutputPath());
            this.shutdownAll(ucc, server, analyzer, bots);
            ucc = null;
            server = null;
            analyzer = null;
            bots = null;
            UT2004CaptureTheFlagResult uT2004CaptureTheFlagResult = result;
            return uT2004CaptureTheFlagResult;
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": EXCEPTION!"), (Throwable)e));
            }
            exception = true;
            if (e instanceof PogamutException) {
                throw (PogamutException)e;
            }
            throw new PogamutException((Throwable)e, (Logger)this.log, (Object)this);
        }
        finally {
            try {
                if (this.log != null && this.log.isLoggable(Level.INFO)) {
                    this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Cleaning up...");
                }
            }
            catch (Exception e) {}
            if (ucc != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Killing UCC...");
                    }
                }
                catch (Exception e) {}
                try {
                    ucc.stop();
                }
                catch (Exception e) {}
            }
            if (server != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Killing UT2004Server...");
                    }
                }
                catch (Exception e) {}
                try {
                    server.kill();
                }
                catch (Exception e) {}
            }
            if (bots != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Killing Custom bots...");
                    }
                }
                catch (Exception e) {}
                for (UT2004BotExecution exec : bots.bots.values()) {
                    try {
                        exec.stop();
                    }
                    catch (Exception e) {}
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Killing Custom bot observers...");
                    }
                }
                catch (Exception e) {}
                for (IUT2004AnalyzerObserver obs : bots.botObservers.values()) {
                    try {
                        obs.kill();
                    }
                    catch (Exception e) {}
                }
            }
            if (analyzer != null) {
                try {
                    if (this.log != null && this.log.isLoggable(Level.INFO)) {
                        this.log.info(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Killing UT2004Analyzer...");
                    }
                }
                catch (Exception e) {}
                try {
                    analyzer.kill();
                }
                catch (Exception e) {}
            }
            try {
                this.restoreGB2004IniBackup();
            }
            catch (Exception e) {}
            try {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    if (exception) {
                        this.log.warning(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Cleaned up, MATCH FAILED!");
                    } else {
                        this.log.warning(((UT2004CaptureTheFlagConfig)this.config).getMatchId().getToken() + ": Cleaned up, match finished successfully.");
                    }
                }
            }
            catch (Exception e) {}
            try {
                this.closeLogger();
            }
            catch (Exception e) {}
        }
    }
}

