/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch1v1;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class UT2004DeathMatch1v1Console {
    private static final char ARG_UT2004_HOME_DIR_SHORT = 'u';
    private static final String ARG_UT2004_HOME_DIR_LONG = "ut2004-home-dir";
    private static final char ARG_BOT1_JAR_SHORT = 'a';
    private static final String ARG_BOT1_JAR_LONG = "bot1-jar";
    private static final char ARG_BOT1_NAME_SHORT = 'b';
    private static final String ARG_BOT1_NAME_LONG = "bot1-name";
    private static final char ARG_BOT2_JAR_SHORT = 'c';
    private static final String ARG_BOT2_JAR_LONG = "bot2-jar";
    private static final char ARG_BOT2_NAME_SHORT = 'd';
    private static final String ARG_BOT2_NAME_LONG = "bot2-name";
    private static final char ARG_MAP_NAME_SHORT = 'm';
    private static final String ARG_MAP_NAME_LONG = "map-name";
    private static final char ARG_MATCH_NAME_SHORT = 'n';
    private static final String ARG_MATCH_NAME_LONG = "match-name";
    private static final char ARG_RESULT_DIR_SHORT = 'r';
    private static final String ARG_RESULT_DIR_LONG = "result-directory";
    private static final char ARG_SERVER_NAME_SHORT = 's';
    private static final String ARG_SERVER_NAME_LONG = "server-name";
    private static final char ARG_FRAG_LIMIT_SHORT = 'f';
    private static final String ARG_FRAG_LIMIT_LONG = "frag-limit";
    private static final char ARG_TIMEOUT_MINUTES_SHORT = 't';
    private static final String ARG_TIMEOUT_MINUTES_LONG = "timeout-minutes";
    private static final char ARG_HUMAN_LIKE_LOG_SHORT = 'h';
    private static final String ARG_HUMAN_LIKE_LOG_LONG = "human-like-log";
    private static final char ARG_UT2004_PORT_SHORT = 'p';
    private static final String ARG_UT2004_PORT_LONG = "ut2004-port";
    private static JSAP jsap;
    private static boolean headerOutput;
    private static String ut2004HomeDir;
    private static String bot1Jar;
    private static String bot1Name;
    private static String bot2Jar;
    private static String bot2Name;
    private static String map;
    private static String serverName;
    private static String resultDir;
    private static String matchName;
    private static int fragLimit;
    private static int timeoutMinutes;
    private static JSAPResult config;
    private static File ut2004HomeDirFile;
    private static File bot1JarFile;
    private static File bot2JarFile;
    private static File mapsDirFile;
    private static File mapFile;
    private static File ut2004SystemDirFile;
    private static File ut2004IniFile;
    private static boolean humanLikeLog;
    private static int ut2004Port;

    private static void fail(String errorMessage) {
        UT2004DeathMatch1v1Console.fail(errorMessage, null);
    }

    private static void fail(String errorMessage, Throwable e) {
        UT2004DeathMatch1v1Console.header();
        System.out.println("ERROR: " + errorMessage);
        System.out.println();
        if (e != null) {
            e.printStackTrace();
            System.out.println("");
        }
        System.out.println("Usage: java -jar ut2004-tournament-1v1....jar ");
        System.out.println("                " + jsap.getUsage());
        System.out.println();
        System.out.println(jsap.getHelp());
        System.out.println();
        throw new RuntimeException("FAILURE: " + errorMessage);
    }

    private static void header() {
        if (headerOutput) {
            return;
        }
        System.out.println();
        System.out.println("=================================");
        System.out.println("Pogamut UT2004 1v1 Match Executor");
        System.out.println("=================================");
        System.out.println();
        headerOutput = true;
    }

    private static void initJSAP() throws JSAPException {
        jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption(ARG_UT2004_HOME_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('u').setLongFlag(ARG_UT2004_HOME_DIR_LONG);
        opt1.setHelp("UT2004 home directory containing GameBots2004 (System/GameBots2004.u) present.");
        jsap.registerParameter((Parameter)opt1);
        FlaggedOption opt2 = new FlaggedOption(ARG_BOT1_JAR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('a').setLongFlag(ARG_BOT1_JAR_LONG);
        opt2.setHelp("PATH/TO/JAR/file containing the 1st bot.");
        jsap.registerParameter((Parameter)opt2);
        FlaggedOption opt3 = new FlaggedOption(ARG_BOT1_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('b').setLongFlag(ARG_BOT1_NAME_LONG);
        opt3.setHelp("Name that should be given to the 1st bot.");
        jsap.registerParameter((Parameter)opt3);
        FlaggedOption opt4 = new FlaggedOption(ARG_BOT2_JAR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('c').setLongFlag(ARG_BOT2_JAR_LONG);
        opt4.setHelp("PATH/TO/JAR/file containing the 2nd bot.");
        jsap.registerParameter((Parameter)opt4);
        FlaggedOption opt5 = new FlaggedOption(ARG_BOT2_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('d').setLongFlag(ARG_BOT2_NAME_LONG);
        opt5.setHelp("Name that should be given to the 2nd bot.");
        jsap.registerParameter((Parameter)opt5);
        FlaggedOption opt6 = new FlaggedOption(ARG_MAP_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('m').setLongFlag(ARG_MAP_NAME_LONG);
        opt6.setHelp("Map where the game should be played (e.g. DM-1on1-Albatross).");
        jsap.registerParameter((Parameter)opt6);
        FlaggedOption opt7 = new FlaggedOption(ARG_MATCH_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('n').setLongFlag(ARG_MATCH_NAME_LONG).setDefault("DMMatch1v1");
        opt7.setHelp("Name of the match == output folder for the results.");
        jsap.registerParameter((Parameter)opt7);
        FlaggedOption opt8 = new FlaggedOption(ARG_RESULT_DIR_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('r').setLongFlag(ARG_RESULT_DIR_LONG).setDefault(".");
        opt8.setHelp("PATH/TO/directory where to output results (does not need to exist).");
        jsap.registerParameter((Parameter)opt8);
        FlaggedOption opt9 = new FlaggedOption(ARG_SERVER_NAME_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('s').setLongFlag(ARG_SERVER_NAME_LONG).setDefault("DMMatch1v1");
        opt9.setHelp("Server name that should be advertised via LAN.");
        jsap.registerParameter((Parameter)opt9);
        FlaggedOption opt10 = new FlaggedOption(ARG_FRAG_LIMIT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('f').setLongFlag(ARG_FRAG_LIMIT_LONG).setDefault("20");
        opt10.setHelp("Frag limit for the match.");
        jsap.registerParameter((Parameter)opt10);
        FlaggedOption opt11 = new FlaggedOption(ARG_TIMEOUT_MINUTES_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('t').setLongFlag(ARG_TIMEOUT_MINUTES_LONG).setDefault("20");
        opt11.setHelp("Match timeout in minutes.");
        jsap.registerParameter((Parameter)opt11);
        Switch opt12 = new Switch(ARG_HUMAN_LIKE_LOG_LONG).setShortFlag('h').setLongFlag(ARG_HUMAN_LIKE_LOG_LONG).setDefault("false");
        opt12.setHelp("Whether to produce log for 'HumanLike Project' analysis.");
        jsap.registerParameter((Parameter)opt12);
        FlaggedOption opt13 = new FlaggedOption(ARG_UT2004_PORT_LONG).setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('p').setLongFlag(ARG_UT2004_PORT_LONG).setDefault("7777");
        opt13.setHelp("UT2004 port for the dedicated server (1-32000).");
        jsap.registerParameter((Parameter)opt13);
    }

    private static void readConfig(String[] args) {
        System.out.println("Parsing command arguments.");
        try {
            config = jsap.parse(args);
        }
        catch (Exception e) {
            UT2004DeathMatch1v1Console.fail(e.getMessage());
            System.out.println("");
            e.printStackTrace();
            throw new RuntimeException("FAILURE!");
        }
        if (!config.success()) {
            UT2004DeathMatch1v1Console.fail("Invalid arguments specified.");
        }
        ut2004HomeDir = config.getString(ARG_UT2004_HOME_DIR_LONG);
        bot1Jar = config.getString(ARG_BOT1_JAR_LONG);
        bot1Name = config.getString(ARG_BOT1_NAME_LONG);
        bot2Jar = config.getString(ARG_BOT2_JAR_LONG);
        bot2Name = config.getString(ARG_BOT2_NAME_LONG);
        map = config.getString(ARG_MAP_NAME_LONG);
        serverName = config.getString(ARG_SERVER_NAME_LONG);
        resultDir = config.getString(ARG_RESULT_DIR_LONG);
        matchName = config.getString(ARG_MATCH_NAME_LONG);
        fragLimit = config.getInt(ARG_FRAG_LIMIT_LONG);
        timeoutMinutes = config.getInt(ARG_TIMEOUT_MINUTES_LONG);
        humanLikeLog = config.getBoolean(ARG_HUMAN_LIKE_LOG_LONG);
        ut2004Port = config.getInt(ARG_UT2004_PORT_LONG);
    }

    private static void sanityChecks() {
        System.out.println("Sanity checks...");
        ut2004HomeDirFile = new File(ut2004HomeDir);
        if (!ut2004HomeDirFile.exists() || !ut2004HomeDirFile.isDirectory()) {
            UT2004DeathMatch1v1Console.fail("UT2004 directory was not found at '" + ut2004HomeDirFile.getAbsolutePath() + "', path resolved from configuration read as '" + ut2004HomeDir + "'.");
        }
        System.out.println("-- UT2004 directory found at '" + ut2004HomeDirFile.getAbsolutePath() + "'");
        ut2004SystemDirFile = new File(ut2004HomeDirFile, "System");
        if (!ut2004SystemDirFile.exists() || !ut2004SystemDirFile.isDirectory()) {
            UT2004DeathMatch1v1Console.fail("UT2004/System directory was not found at '" + ut2004SystemDirFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/System directory found at '" + ut2004SystemDirFile.getAbsolutePath() + "'");
        ut2004IniFile = new File(ut2004SystemDirFile, "UT2004.ini");
        if (!ut2004IniFile.exists() || !ut2004IniFile.isFile()) {
            UT2004DeathMatch1v1Console.fail("UT2004/System/UT2004.ini file was not found at '" + ut2004IniFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/System/UT2004.ini file found at '" + ut2004SystemDirFile.getAbsolutePath() + "'");
        bot1JarFile = new File(bot1Jar);
        if (!bot1JarFile.exists() || !bot1JarFile.isFile()) {
            UT2004DeathMatch1v1Console.fail("Bot1 jar file was not found at '" + bot1JarFile.getAbsolutePath() + "', path resolved from configuration read as '" + bot1Jar + "'.");
        }
        System.out.println("-- Bot1 jar file found at '" + bot1JarFile.getAbsolutePath() + "'");
        bot2JarFile = new File(bot2Jar);
        if (!bot2JarFile.exists() || !bot2JarFile.isFile()) {
            UT2004DeathMatch1v1Console.fail("Bot2 jar file was not found at '" + bot2JarFile.getAbsolutePath() + "', path resolved from configuration read as '" + bot2Jar + "'.");
        }
        System.out.println("-- Bot2 jar file found at '" + bot2JarFile.getAbsolutePath() + "'");
        if (bot1Name == null || bot1Name.isEmpty()) {
            UT2004DeathMatch1v1Console.fail("Bot1 invalid name '" + bot1Name + "' specified.");
        }
        System.out.println("-- Bot1 name set as '" + bot1Name + "'");
        if (bot2Name == null || bot2Name.isEmpty()) {
            UT2004DeathMatch1v1Console.fail("Bot2 invalid name '" + bot1Name + "' specified.");
        }
        System.out.println("-- Bot2 name set as '" + bot2Name + "'");
        if (bot1Name.equalsIgnoreCase(bot2Name)) {
            UT2004DeathMatch1v1Console.fail("Bot1 has the name '" + bot1Name + "', which is the same (case-insensitive) as Bot2 name '" + bot2Name + "'.");
        }
        System.out.println("-- Bot1+2 names ok");
        mapsDirFile = new File(ut2004HomeDirFile, "Maps");
        if (!mapsDirFile.exists() || !mapsDirFile.isDirectory()) {
            UT2004DeathMatch1v1Console.fail("UT2004/Maps directory was not found at '" + mapsDirFile.getAbsolutePath() + "', invalid UT2004 installation.");
        }
        System.out.println("-- UT2004/Maps directory found at '" + mapsDirFile.getAbsolutePath() + "'");
        mapFile = new File(mapsDirFile, map + ".ut2");
        if (!mapFile.exists() || !mapFile.isFile()) {
            UT2004DeathMatch1v1Console.fail("Specified map '" + map + "' was not found within UT2004/Maps dir at '" + mapFile.getAbsoluteFile() + "', could not execute the match.");
        }
        System.out.println("-- Map '" + map + "' found at '" + mapFile.getAbsolutePath() + "'");
        if (matchName == null || matchName.isEmpty()) {
            UT2004DeathMatch1v1Console.fail("Invalid match name '" + matchName + "' specified.");
        }
        System.out.println("-- Match name set as '" + matchName + "'");
        if (serverName == null || serverName.isEmpty()) {
            UT2004DeathMatch1v1Console.fail("Invalid server name '" + serverName + "' specified.");
        }
        System.out.println("-- Server name set as '" + serverName + "'");
        if (fragLimit < 1) {
            UT2004DeathMatch1v1Console.fail("Invalid frag limit '" + fragLimit + "' specified, must be >= 1.");
        }
        System.out.println("-- Frag limit set as '" + fragLimit + "'");
        if (timeoutMinutes < 1) {
            UT2004DeathMatch1v1Console.fail("Invalid time limit '" + timeoutMinutes + "' specified, must be >= 1.");
        }
        System.out.println("-- Timeout set as '" + timeoutMinutes + "' minutes.");
        if (ut2004Port < 1 || ut2004Port > 32000) {
            UT2004DeathMatch1v1Console.fail("Invalid UT2004 port specified '" + ut2004Port + "', must be 1 <= port <= 32000.");
        }
        System.out.println("-- UT2004 port set as '" + ut2004Port + "'");
        System.out.println("Sanity checks OK!");
    }

    private static void setUT2004Ini() {
        List lines;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        File ut2004IniBackup = new File(ut2004SystemDirFile, "UT2004.ini." + sdf.format(date) + ".bak");
        System.out.println("Backing up '" + ut2004IniFile.getAbsolutePath() + "' into '" + ut2004IniBackup.getAbsolutePath() + "' ...");
        try {
            FileUtils.copyFile((File)ut2004IniFile, (File)ut2004IniBackup);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to backup UT2004.ini", e);
        }
        System.out.println("Reading '" + ut2004IniFile.getAbsolutePath() + "' ...");
        try {
            lines = FileUtils.readLines((File)ut2004IniFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read UT2004.ini", e);
        }
        System.out.println(lines.size() + " lines read.");
        System.out.println("Searching for UT2004 Port and ServerName ...");
        int state = 0;
        Pattern patternSection = Pattern.compile("^\\s*\\[\\s*[^]]*\\s*\\]\\s*$");
        Pattern patternSectionURL = Pattern.compile("^\\s*\\[\\s*URL\\s*\\]\\s*$");
        Pattern patternSectionEngineGameReplicationInfo = Pattern.compile("^\\s*\\[\\s*Engine.GameReplicationInfo\\s*\\]\\s*$");
        Pattern patternPort = Pattern.compile("^\\s*Port\\s*=\\s*.*$");
        Pattern patternServerName = Pattern.compile("^\\s*ServerName\\s*=\\s*.*$");
        Pattern patternShortName = Pattern.compile("^\\s*ShortName\\s*=\\s*.*$");
        boolean portFound = false;
        boolean nameFound = false;
        boolean shortNameFound = false;
        block16: for (int lineNum = 0; !(lineNum > lines.size() || portFound && nameFound && shortNameFound); ++lineNum) {
            String line;
            String string = line = lineNum < lines.size() ? ((String)lines.get(lineNum)).trim() : null;
            if (lineNum < lines.size() && line == null) continue;
            if (lineNum == lines.size() || patternSection.matcher(line).matches()) {
                switch (state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (portFound) break;
                        lines.add(lineNum, "Port=" + ut2004Port);
                        portFound = true;
                        ++lineNum;
                        break;
                    }
                    case 2: {
                        if (!nameFound) {
                            lines.add(lineNum, "ServerName=" + serverName);
                            nameFound = true;
                            ++lineNum;
                        }
                        if (shortNameFound) break;
                        lines.add(lineNum, "ShortName=" + serverName);
                        shortNameFound = true;
                        ++lineNum;
                    }
                }
                if (lineNum == lines.size()) break;
                if (line == null) continue;
                if (patternSectionURL.matcher(line).matches()) {
                    state = 1;
                    continue;
                }
                if (patternSectionEngineGameReplicationInfo.matcher(line).matches()) {
                    state = 2;
                    continue;
                }
                state = 0;
                continue;
            }
            switch (state) {
                case 0: {
                    continue block16;
                }
                case 1: {
                    if (portFound || !patternPort.matcher(line).matches()) continue block16;
                    lines.set(lineNum, "Port=" + ut2004Port);
                    portFound = true;
                    continue block16;
                }
                case 2: {
                    if (!nameFound && patternServerName.matcher(line).matches()) {
                        lines.set(lineNum, "ServerName=" + serverName);
                        nameFound = true;
                        continue block16;
                    }
                    if (shortNameFound || !patternShortName.matcher(line).matches()) continue block16;
                    lines.set(lineNum, "ShortName=" + serverName);
                    shortNameFound = true;
                    continue block16;
                }
                default: {
                    continue block16;
                }
            }
        }
        if (!portFound) {
            throw new RuntimeException("Failed to set UT2004 port!");
        }
        if (!nameFound) {
            throw new RuntimeException("Failed to set UT2004 ServerName!");
        }
        System.out.println("UT2004 Port and ServerName set.");
        System.out.println("Rewriting '" + ut2004IniFile.getAbsolutePath() + "' ...");
        try {
            FileUtils.writeLines((File)ut2004IniFile, (Collection)lines);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write UT2004.ini", e);
        }
        System.out.println("UT2004 Port and ServerName set.");
    }

    private static void executeMatch() {
        UT2004DeathMatch1v1 match = new UT2004DeathMatch1v1(ut2004HomeDir, map, bot1Name, bot1Jar, bot2Name, bot2Jar);
        match.setOutputDir(resultDir);
        match.setMatchName(matchName);
        match.setFragLimit(fragLimit);
        match.setTimeLimitInMinutes(timeoutMinutes);
        match.setHumanLikeLogEnabled(humanLikeLog);
        match.getLog().setLevel(Level.WARNING);
        match.getLog().addConsoleHandler();
        System.out.println("EXECUTING MATCH!");
        match.run();
    }

    public static void main(String[] args) throws JSAPException {
        UT2004DeathMatch1v1Console.initJSAP();
        UT2004DeathMatch1v1Console.header();
        UT2004DeathMatch1v1Console.readConfig(args);
        UT2004DeathMatch1v1Console.sanityChecks();
        UT2004DeathMatch1v1Console.setUT2004Ini();
        UT2004DeathMatch1v1Console.executeMatch();
    }

    static {
        headerOutput = false;
    }
}

