/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.match;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.ut2004.tournament.GameBots2004Ini;
import cz.cuni.amis.pogamut.ut2004.tournament.match.IUT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.UT2004TournamentProperty;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UT2004MatchConfig {
    protected File outputDirectory = new File("./results/matches");
    protected IToken matchId = Tokens.get((String)"DMMatch");
    protected UCCWrapperConf uccConf = new UCCWrapperConf();
    protected GameBots2004Ini gb2004Ini = new GameBots2004Ini();
    protected Map<IToken, UT2004BotConfig> bots = new HashMap<IToken, UT2004BotConfig>();
    protected Map<IToken, UT2004NativeBotConfig> nativeBots = new HashMap<IToken, UT2004NativeBotConfig>();
    protected final StringBuffer validationBuffer = new StringBuffer();
    protected boolean validationError = false;

    public UT2004MatchConfig() {
        String unrealHome = Pogamut.getPlatform().getProperty(UT2004TournamentProperty.UT2004_DIR.getKey());
        if (unrealHome != null) {
            this.uccConf.setUnrealHome(unrealHome);
        }
    }

    public UT2004MatchConfig(UT2004MatchConfig orig) {
        this.matchId = orig.matchId;
        this.uccConf = new UCCWrapperConf(orig.getUccConf());
        this.gb2004Ini = new GameBots2004Ini(orig.getGb2004Ini());
        for (Map.Entry<IToken, UT2004BotConfig> entry : orig.getBots().entrySet()) {
            this.bots.put(entry.getKey(), new UT2004BotConfig(entry.getValue()));
        }
        for (Map.Entry<IToken, IUT2004BotConfig> entry : orig.getNativeBots().entrySet()) {
            this.nativeBots.put(entry.getKey(), new UT2004NativeBotConfig((UT2004NativeBotConfig)entry.getValue()));
        }
    }

    public int hashCode() {
        return this.matchId == null ? super.hashCode() : this.matchId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UT2004MatchConfig)) {
            return false;
        }
        return SafeEquals.equals((Object)this.matchId, (Object)((UT2004MatchConfig)obj).getMatchId());
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public IToken getMatchId() {
        return this.matchId;
    }

    public void setMatchId(IToken matchId) {
        this.matchId = matchId;
    }

    public void setMatchId(String matchId) {
        this.matchId = Tokens.get((String)matchId);
    }

    public UCCWrapperConf getUccConf() {
        return this.uccConf;
    }

    public GameBots2004Ini getGb2004Ini() {
        return this.gb2004Ini;
    }

    public Map<IToken, UT2004BotConfig> getBots() {
        return this.bots;
    }

    public Map<IToken, UT2004NativeBotConfig> getNativeBots() {
        return this.nativeBots;
    }

    public List<IToken> getAllBotIds() {
        ArrayList<IToken> bots = new ArrayList<IToken>(this.getBots().keySet());
        ArrayList<IToken> nativeBots = new ArrayList<IToken>(this.getNativeBots().keySet());
        Collections.sort(bots, new Comparator<IToken>(){

            @Override
            public int compare(IToken o1, IToken o2) {
                return o1.getToken().compareTo(o2.getToken());
            }
        });
        Collections.sort(nativeBots, new Comparator<IToken>(){

            @Override
            public int compare(IToken o1, IToken o2) {
                return o1.getToken().compareTo(o2.getToken());
            }
        });
        ArrayList<IToken> botIds = new ArrayList<IToken>(bots);
        botIds.addAll(nativeBots);
        return botIds;
    }

    public UT2004MatchConfig setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public UT2004MatchConfig setUccConf(UCCWrapperConf uccConf) {
        this.uccConf = uccConf;
        return this;
    }

    public UT2004MatchConfig setGb2004Ini(GameBots2004Ini gb2004Ini) {
        this.gb2004Ini = gb2004Ini;
        return this;
    }

    public UT2004MatchConfig setBots(Map<IToken, UT2004BotConfig> bots) {
        this.bots = bots;
        return this;
    }

    public UT2004MatchConfig setNativeBots(Map<IToken, UT2004NativeBotConfig> nativeBots) {
        this.nativeBots = nativeBots;
        return this;
    }

    public UT2004MatchConfig clearBots() {
        this.bots.clear();
        return this;
    }

    public UT2004MatchConfig clearNativeBots() {
        this.nativeBots.clear();
        return this;
    }

    public UT2004MatchConfig addBot(UT2004BotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004BotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.bots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing custom bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            if (this.nativeBots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing native bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            this.bots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public UT2004MatchConfig setBot(UT2004BotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004BotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.nativeBots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing native bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            this.bots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public UT2004MatchConfig addNativeBot(UT2004NativeBotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004NativeBotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.bots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing custom bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            if (this.nativeBots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing native bot configuration under this ID. If you need to override it, use setNativeBot().", (Object)this);
            }
            this.nativeBots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public UT2004MatchConfig setNativeBot(UT2004NativeBotConfig ... bots) {
        if (bots == null) {
            return this;
        }
        for (UT2004NativeBotConfig bot : bots) {
            NullCheck.check((Object)bot.getBotId(), (String)"bot.getBotId()");
            if (this.bots.containsKey(bot.getBotId())) {
                throw new PogamutException("Can't add another bot under the id " + bot.getBotId().getToken() + ", there is already an existing custom bot configuration under this ID. If you need to override it, use setBot().", (Object)this);
            }
            this.nativeBots.put(bot.getBotId(), bot);
        }
        return this;
    }

    public boolean isNativeBot(IToken botId) {
        return this.nativeBots.containsKey(botId);
    }

    protected void validateInner() {
        if (this.matchId == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("Match ID is NULL");
        }
        for (UT2004BotConfig uT2004BotConfig : this.bots.values()) {
            if (uT2004BotConfig.getBotId() == null) {
                this.validationError = true;
                this.validationBuffer.append(Const.NEW_LINE);
                this.validationBuffer.append("One of custom bots has NULL bot-id.");
            }
            if (uT2004BotConfig.getPathToBotJar() == null) {
                this.validationError = true;
                this.validationBuffer.append(Const.NEW_LINE);
                this.validationBuffer.append(uT2004BotConfig.getBotId() == null ? "One of custom bots" : "Bot " + uT2004BotConfig.getBotId().getToken() + " has NULL path-to-jar.");
                continue;
            }
            if (uT2004BotConfig.isBotJarExist()) continue;
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append(uT2004BotConfig.getBotId() == null ? "One of custom bots" : "Bot " + uT2004BotConfig.getBotId().getToken() + " has path-to-jar pointing to non-existing file " + uT2004BotConfig.getJarFile().getAbsolutePath());
        }
        for (UT2004NativeBotConfig uT2004NativeBotConfig : this.nativeBots.values()) {
            if (uT2004NativeBotConfig.getBotId() != null) continue;
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("One of native bots has NULL bot-id.");
        }
        if (this.gb2004Ini == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("GameBots2004Ini is NULL.");
        }
        if (this.uccConf == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("UccWrapper is NULL.");
        } else if (this.uccConf.getUnrealHome() == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("UccWrapper does not have UnrealHome set, is NULL.");
        } else {
            File uccHome = new File(this.uccConf.getUnrealHome());
            if (!uccHome.exists() || !uccHome.isDirectory()) {
                this.validationError = true;
                this.validationBuffer.append(Const.NEW_LINE);
                this.validationBuffer.append("UccWrapper.UnrealHome does not point to directory, used path: " + uccHome.getAbsolutePath());
            } else {
                File file = new File(this.uccConf.getUnrealHome() + File.separator + "System");
                if (!file.exists() || !file.isDirectory()) {
                    this.validationError = true;
                    this.validationBuffer.append(Const.NEW_LINE);
                    this.validationBuffer.append("UccWrapper.UnrealHome" + File.separator + "System does not point to directory, used path: " + file.getAbsolutePath());
                } else {
                    File gb = new File(this.uccConf.getUnrealHome() + File.separator + "System" + File.separator + "GameBots2004.u");
                    if (!gb.exists() || !gb.isFile()) {
                        this.validationError = true;
                        this.validationBuffer.append(Const.NEW_LINE);
                        this.validationBuffer.append("GameBots2004 was not installed into specified UT2004, the file GameBots2004.u was not found at: " + gb.getAbsolutePath());
                    }
                }
            }
        }
        if (this.bots.size() + this.nativeBots.size() < 2) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("There are not enough bot specified for the match. Custom bots: " + this.bots.size() + ", native bots: " + this.nativeBots.size() + ". There must be at least 2 bots to perform the match!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate() {
        StringBuffer stringBuffer = this.validationBuffer;
        synchronized (stringBuffer) {
            this.validationError = false;
            if (this.validationBuffer.length() > 0) {
                this.validationBuffer.delete(0, this.validationBuffer.length());
            }
            this.validateInner();
            if (this.validationError) {
                throw new PogamutException(this + " validation error!" + this.validationBuffer.toString(), (Object)this);
            }
        }
    }
}

