package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import java.io.File;
import java.util.logging.Level;

import org.junit.AfterClass;
import org.junit.Test;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.UT2004TournamentProperty;

public class UT2004TournamentTest06_UT2004DeathMatch_MichalVsPyroh {
	
	@AfterClass
	public static void tearDown() {
		Pogamut.getPlatform().close();
	}
	
	public static UT2004DeathMatch createMatch() {
		return
			new UT2004DeathMatch1v1(
					Pogamut.getPlatform().getProperty(UT2004TournamentProperty.UT2004_DIR.getKey()),
					"DM-1on1-Albatross",
					"MichalBot",
					"bots" + File.separator + "KnightHunter" + File.separator + "KnightHunter.jar",
					"PyrohBot",
					"bots" + File.separator + "TobRetnuh" + File.separator + "TobRetnuh.jar"
			).createMatch();
	}
	
	@Test
	public void test() {
		UT2004DeathMatch match = createMatch();
		match.getLog().setLevel(Level.FINE);
		match.getLog().addConsoleHandler();
		match.cleanUp();
		match.run();
		System.out.println("---/// TEST OK ///---");
	}

}
