/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Orientation;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.WritableWorkbookImpl;

public abstract class ExcelReport {
    public void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    public void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    public void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    protected void produceExcel(File outputFile) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            WorkbookSettings settings = new WorkbookSettings();
            WritableWorkbookImpl workbook = new WritableWorkbookImpl((OutputStream)outputStream, false, settings);
            WritableSheet sheet = workbook.createSheet("TABLE", 0);
            this.produceExcel(outputFile, workbook, sheet);
            workbook.write();
            workbook.close();
        }
        catch (Exception e) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputFile.delete();
            throw new RuntimeException("Failed to generate the result.", e);
        }
    }

    protected abstract void produceExcel(File var1, WritableWorkbookImpl var2, WritableSheet var3) throws Exception;

    protected Label newStringCell(String column, int row, String content) {
        int col = this.getColumnNumber(column);
        return this.newStringCell(col, row, content);
    }

    protected Label newStringCell(int col, int row, String content) {
        return new Label(col, row, content);
    }

    protected Number newIntCell(String column, int row, int num) throws WriteException {
        int col = this.getColumnNumber(column);
        return this.newIntCell(col, row, num);
    }

    protected Number newIntCell(int col, int row, int num) throws WriteException {
        WritableCellFormat integerFormat = new WritableCellFormat(NumberFormats.INTEGER);
        integerFormat.setShrinkToFit(true);
        return new Number(col, row, (double)num, (CellFormat)integerFormat);
    }

    protected WritableCell textVertical(WritableCell cell) throws WriteException {
        WritableCellFormat format = new WritableCellFormat(cell.getCellFormat());
        format.setOrientation(Orientation.PLUS_90);
        cell.setCellFormat((CellFormat)format);
        return cell;
    }

    protected WritableCell center(WritableCell cell) throws WriteException {
        WritableCellFormat format = new WritableCellFormat(cell.getCellFormat());
        format.setAlignment(Alignment.CENTRE);
        cell.setCellFormat((CellFormat)format);
        return cell;
    }

    protected int getColumnNumber(String column) {
        if ((column = column.toUpperCase()).length() == 1) {
            char c = column.charAt(0);
            int num = c - 65;
            return num;
        }
        throw new RuntimeException("Invalid column " + column);
    }
}

