/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.dm.table.report;

import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSV {
    private String delimiter;
    public List<String> keys;
    public List<CSVRow> rows = new ArrayList<CSVRow>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSV(File file, String delimiter, boolean containsHeaderRow) throws FileNotFoundException, IOException {
        this.delimiter = delimiter;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            Object[] line = this.nextLine(reader);
            if (line == null) {
                throw new RuntimeException("File '" + file.getAbsolutePath() + "' does not contain any line!");
            }
            if (containsHeaderRow) {
                this.keys = MyCollections.asList((Object[])line, (IFilter)null);
            } else {
                this.keys = new ArrayList<String>();
                for (int i = 0; i < line.length; ++i) {
                    this.keys.add(String.valueOf(i));
                }
                this.processLine((String[])line);
            }
            while (reader.ready()) {
                this.processLine(this.nextLine(reader));
            }
        }
        finally {
            reader.close();
        }
    }

    private String[] nextLine(BufferedReader reader) throws IOException {
        if (reader.ready()) {
            String line = reader.readLine();
            return line.split(this.delimiter);
        }
        return null;
    }

    private CSVRow processLine(String[] line) {
        CSVRow result = new CSVRow();
        for (int i = 0; i < line.length; ++i) {
            if (i >= this.keys.size()) {
                this.keys.add(String.valueOf(i));
            }
            String key = this.keys.get(i);
            String value = line[i];
            result.add(key, value);
        }
        this.rows.add(result);
        return result;
    }

    public static class CSVRow {
        private Map<String, String> row = new HashMap<String, String>();

        protected void add(String key, String value) {
            this.row.put(key, value);
        }

        public String getString(String name) {
            String val = this.row.get(name);
            if (val == null) {
                return "";
            }
            return val;
        }

        public Integer getInt(String name) {
            try {
                int number = Integer.parseInt(this.getString(name));
                return number;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public Double getDouble(String name) {
            try {
                double number = Double.parseDouble(this.getString(name));
                return number;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

