/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.bot;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerJoinsGame;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.pogamut.ut2004.hideandseek.bot.HSEvents;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSBotState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameConfig;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSMessagesTranslator;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSAssignSeeker;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSBotStateChanged;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSGameEnd;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSGameStart;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSPlayerScoreChanged;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundEnd;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundStart;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRoundState;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerCaptured;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerFouled;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSafe;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSpotted;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSRunnerSurvived;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.HSBotRecord;
import cz.cuni.amis.pogamut.ut2004.hideandseek.server.UT2004HSServer;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HSBotModule
extends SensorModule<UT2004Bot> {
    private AgentInfo info;
    private Players players;
    private HSMessagesTranslator hsTranslator;
    private HSEvents hsEvents;
    private IWorldEventListener<BeginMessage> beginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            HSBotModule.this.beginMessage(event);
        }
    };
    private IWorldEventListener<BotKilled> botKilledMessageListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            HSBotModule.this.botKilled(event);
        }
    };
    private IWorldEventListener<Spawn> spawnMessageListener = new IWorldEventListener<Spawn>(){

        public void notify(Spawn event) {
            HSBotModule.this.spawn(event);
        }
    };
    private IWorldEventListener<PlayerJoinsGame> myPlayerJoinsGameMessageListener = new IWorldEventListener<PlayerJoinsGame>(){

        public void notify(PlayerJoinsGame event) {
            HSBotModule.this.playerJoinsGame(event);
        }
    };
    private IWorldEventListener<PlayerLeft> myPlayerLeftMessageListener = new IWorldEventListener<PlayerLeft>(){

        public void notify(PlayerLeft event) {
            HSBotModule.this.playerLeft(event);
        }
    };
    private IWorldObjectListener<PlayerMessage> myPlayerListener = new IWorldObjectListener<PlayerMessage>(){

        public void notify(IWorldObjectEvent<PlayerMessage> event) {
            HSBotModule.this.playerUpdate(event);
        }
    };
    private HSGameConfig gameConfig;
    private Flag<Boolean> gameRunning = new Flag((Object)false);
    private Flag<Boolean> roundRunning = new Flag((Object)false);
    private Flag<HSGameState> gameState = new Flag((Object)HSGameState.NOT_RUNNING);
    private Map<UnrealId, HSBotRecord<Player>> records = new LazyMap<UnrealId, HSBotRecord<Player>>(){

        protected HSBotRecord<Player> create(UnrealId key) {
            return new HSBotRecord<Player>(key);
        }
    };
    private HSBotRecord<Player> seeker;
    private HSRoundState roundState;
    private long simTimeCurrent;
    private boolean alive = false;

    public HSBotModule(UT2004Bot agent, AgentInfo info, Players players) {
        super((IObservingAgent)agent);
        this.info = info;
        if (info == null) {
            info = new UT2004AgentInfo(agent);
        }
        this.players = players;
        if (this.players == null) {
            this.players = new Players(agent);
        }
        this.hsTranslator = new HSMessagesTranslator((IWorldView)agent.getWorldView(), false);
        this.hsEvents = new HSEvents((IWorldView)agent.getWorldView()){

            @Override
            public void hsAssignSeeker(HSAssignSeeker event) {
                HSBotModule.this.hsAssignSeeker(event);
            }

            @Override
            public void hsBotStateChanged(HSBotStateChanged event) {
                HSBotModule.this.hsBotStateChanged(event);
            }

            @Override
            public void hsGameEnd(HSGameEnd event) {
                HSBotModule.this.hsGameEnd(event);
            }

            @Override
            public void hsGameStart(HSGameStart event) {
                HSBotModule.this.hsGameStart(event);
            }

            @Override
            public void hsPlayerScoreChanged(HSPlayerScoreChanged event) {
                HSBotModule.this.hsPlayerScoreChanged(event);
            }

            @Override
            public void hsRoundEnd(HSRoundEnd event) {
                HSBotModule.this.hsRoundEnd(event);
            }

            @Override
            public void hsRoundStart(HSRoundStart event) {
                HSBotModule.this.hsRoundStart(event);
            }

            @Override
            public void hsRoundState(HSRoundState event) {
                HSBotModule.this.hsRoundState(event);
            }

            @Override
            public void hsRunnerCaptured(HSRunnerCaptured event) {
                HSBotModule.this.hsRunnerCaptured(event);
            }

            @Override
            public void hsRunnerFouled(HSRunnerFouled event) {
                HSBotModule.this.hsRunnerFouled(event);
            }

            @Override
            public void hsRunnerSafe(HSRunnerSafe event) {
                HSBotModule.this.hsRunnerSafe(event);
            }

            @Override
            public void hsRunnerSpotted(HSRunnerSpotted event) {
                HSBotModule.this.hsRunnerSpotted(event);
            }

            @Override
            public void hsRunnerSurvived(HSRunnerSurvived event) {
                HSBotModule.this.hsRunnerSurvived(event);
            }
        };
        agent.getWorldView().addEventListener(BeginMessage.class, this.beginMessageListener);
        agent.getWorldView().addEventListener(BotKilled.class, this.botKilledMessageListener);
        agent.getWorldView().addEventListener(Spawn.class, this.spawnMessageListener);
        agent.getWorldView().addEventListener(PlayerJoinsGame.class, this.myPlayerJoinsGameMessageListener);
        agent.getWorldView().addEventListener(PlayerLeft.class, this.myPlayerLeftMessageListener);
        agent.getWorldView().addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.myPlayerListener);
    }

    public UnrealId getId() {
        return this.info.getId();
    }

    public boolean isGameRunning() {
        return (Boolean)this.gameRunning.getFlag();
    }

    public ImmutableFlag<Boolean> getGameRunningFlag() {
        return this.gameRunning.getImmutable();
    }

    public boolean isRoundRunning() {
        return (Boolean)this.gameRunning.getFlag() != false && (Boolean)this.roundRunning.getFlag() != false;
    }

    public ImmutableFlag<Boolean> getRoundRunningFlag() {
        return this.roundRunning.getImmutable();
    }

    public HSGameState getGameState() {
        return (HSGameState)((Object)this.gameState.getFlag());
    }

    public ImmutableFlag<HSGameState> getGameStateFlag() {
        return this.gameState.getImmutable();
    }

    public boolean isMeAlive() {
        return this.isRoundRunning() && this.alive;
    }

    public boolean isMeSeeker() {
        return this.isSeeker(this.getId());
    }

    public boolean isMeRunner() {
        return this.isRunner(this.getId());
    }

    public HSBotState getMyState() {
        return this.getBotState(this.getId());
    }

    public int getMyScore() {
        return this.records.get(this.getId()).getScore();
    }

    public boolean isSeeker(UnrealId botId) {
        return this.isRoundRunning() ? this.records.get(botId).getBotState() == HSBotState.SEEKER : false;
    }

    public boolean isSeeker(Player bot) {
        return this.isSeeker(bot.getId());
    }

    public boolean isRunner(UnrealId botId) {
        return this.isRoundRunning() ? this.records.get(botId).getBotState() != HSBotState.SEEKER : false;
    }

    public boolean isRunner(Player bot) {
        return this.isRunner(bot.getId());
    }

    public boolean canCaptureRunner() {
        return this.getSpottedRunnerRecords().size() > 0;
    }

    public List<HSBotRecord<Player>> getSpottedRunnerRecords() {
        return this.getBotRecords(HSBotState.RUNNER_SPOTTED);
    }

    public List<HSBotRecord<Player>> getBotRecords(HSBotState botWhoAreInThisState) {
        ArrayList<HSBotRecord<Player>> result = new ArrayList<HSBotRecord<Player>>();
        for (HSBotRecord<Player> record : this.records.values()) {
            if (!record.isBot() || record.getBotState() != botWhoAreInThisState) continue;
            result.add(record);
        }
        return result;
    }

    public HSBotState getBotState(UnrealId botId) {
        return this.isRoundRunning() ? this.records.get(botId).getBotState() : null;
    }

    public boolean isSeekerSpawned() {
        return this.isRoundRunning() ? this.gameState.getFlag() == HSGameState.RESTRICTED_AREA_ACTIVE || this.gameState.getFlag() == HSGameState.ROUND_RUNNING : false;
    }

    public boolean isHidingTime() {
        return this.isRoundRunning() ? this.gameState.getFlag() == HSGameState.HIDING_TIME : false;
    }

    public double getRemainingHidingTime() {
        double simTimeDelta;
        double d = simTimeDelta = this.simTimeCurrent > this.roundState.getSimTime() ? (double)(this.simTimeCurrent - this.roundState.getSimTime()) / 1000.0 : 0.0;
        return this.isRoundRunning() ? (this.isHidingTime() ? this.roundState.getHideTimeLeftUT() - simTimeDelta : 0.0) : Double.POSITIVE_INFINITY;
    }

    public boolean isRestrictedAreaActivated() {
        return this.isRoundRunning() ? this.gameState.getFlag() == HSGameState.RESTRICTED_AREA_ACTIVE || this.gameState.getFlag() == HSGameState.SPAWNING_SEEKER : false;
    }

    public double getRemainingRestrictedAreaTime() {
        double simTimeDelta;
        double d = simTimeDelta = this.simTimeCurrent > this.roundState.getSimTime() ? (double)(this.simTimeCurrent - this.roundState.getSimTime()) / 1000.0 : 0.0;
        return this.isRoundRunning() ? (this.isRestrictedAreaActivated() ? this.roundState.getRestrictedAreaTimeLeftUT() - simTimeDelta : 0.0) : Double.POSITIVE_INFINITY;
    }

    public boolean isSafeAreaApproachableByRunner() {
        return this.isRoundRunning() ? this.gameState.getFlag() == HSGameState.ROUND_RUNNING : false;
    }

    public UnrealId getSeekerId() {
        return this.seeker == null ? null : this.seeker.getBotId();
    }

    public Player getSeeker() {
        return this.getSeekerId() == null ? null : this.players.getPlayer(this.getSeekerId());
    }

    public HSGameConfig getGameConfig() {
        return this.gameConfig;
    }

    public Location getSafeArea() {
        return this.gameConfig == null ? null : this.gameConfig.getSafeArea();
    }

    public NavPoint getSafeAreaNearestNavPoint() {
        return this.gameConfig == null ? null : this.info.getNearestNavPoint((ILocated)this.gameConfig.getSafeArea());
    }

    public double getSafeAreaDistance(ILocated located) {
        if (located == null) {
            return Double.POSITIVE_INFINITY;
        }
        Location safeArea = this.getSafeArea();
        if (safeArea == null) {
            return Double.POSITIVE_INFINITY;
        }
        Location location = located.getLocation();
        if (location == null) {
            return Double.POSITIVE_INFINITY;
        }
        return safeArea.getDistance(location) - (double)this.gameConfig.getSafeAreaRadius();
    }

    public double getMySafeAreaDistance() {
        return this.getSafeAreaDistance((ILocated)this.info.getLocation());
    }

    public boolean isInSafeArea(ILocated located) {
        return this.getSafeAreaDistance(located) <= 0.0;
    }

    public boolean isMeInSafeArea() {
        return this.isInRestrictedArea((ILocated)this.info.getLocation());
    }

    public double getRestrictedAreaDistance(ILocated located) {
        if (located == null) {
            return Double.POSITIVE_INFINITY;
        }
        Location safeArea = this.getSafeArea();
        if (safeArea == null) {
            return Double.POSITIVE_INFINITY;
        }
        Location location = located.getLocation();
        if (location == null) {
            return Double.POSITIVE_INFINITY;
        }
        return safeArea.getDistance(location) - (double)this.gameConfig.getRestrictedAreaRadius();
    }

    public double getMyRestrictedAreaDistance() {
        return this.getRestrictedAreaDistance((ILocated)this.info.getLocation());
    }

    public boolean isInRestrictedArea(ILocated located) {
        return this.isInRestrictedArea(located, 0.0);
    }

    public boolean isMeInRestrictedArea() {
        return this.isInRestrictedArea((ILocated)this.info.getLocation());
    }

    public boolean isInRestrictedArea(ILocated located, double tolerance) {
        return this.getRestrictedAreaDistance(located) <= tolerance;
    }

    public boolean isMeInRestrictedArea(double tolerance) {
        return this.isInRestrictedArea((ILocated)this.info.getLocation(), tolerance);
    }

    public double getRemainingRoundTime() {
        double simTimeDelta = this.simTimeCurrent > this.roundState.getSimTime() ? (double)(this.simTimeCurrent - this.roundState.getSimTime()) / 1000.0 : 0.0;
        return this.isRoundRunning() ? this.roundState.getRoundTimeLeftUT() - simTimeDelta : Double.POSITIVE_INFINITY;
    }

    protected void beginMessage(BeginMessage event) {
        this.simTimeCurrent = event.getSimTime();
    }

    protected void playerUpdate(IWorldObjectEvent<PlayerMessage> event) {
        this.ensureRecord(((PlayerMessage)event.getObject()).getId()).setPlayer((Player)event.getObject());
    }

    protected void playerLeft(PlayerLeft event) {
        this.ensureRecord(event.getId()).setInGame(false);
    }

    protected void playerJoinsGame(PlayerJoinsGame event) {
        this.ensureRecord(event.getId());
    }

    protected void botKilled(BotKilled event) {
        this.alive = false;
    }

    protected void spawn(Spawn event) {
        this.alive = true;
    }

    protected void hsAssignSeeker(HSAssignSeeker event) {
        this.seeker = this.ensureRecord(event.getBotId());
        this.seeker.setSeekerForThisRound();
        if (this.seeker.getBotId() != this.getId()) {
            this.info.getBotName().setInfo("HS", HSBotState.RUNNER.name());
        } else {
            this.info.getBotName().setInfo("HS", HSBotState.SEEKER.name());
        }
    }

    protected void hsBotStateChanged(HSBotStateChanged event) {
        this.ensureRecord(event.getBotId());
        if (this.isRoundRunning()) {
            this.updateBotNameTag();
        }
    }

    protected void hsGameEnd(HSGameEnd event) {
        this.roundRunning.setFlag((Object)false);
        this.gameState.setFlag((Object)HSGameState.NOT_RUNNING);
        this.gameRunning.setFlag((Object)false);
        this.removeBotNameTag();
    }

    protected void hsGameStart(HSGameStart event) {
        this.resetHSGameData();
        this.gameConfig = new HSGameConfig(event);
        this.gameRunning.setFlag((Object)true);
        this.gameState.setFlag((Object)HSGameState.GAME_STARTED);
    }

    protected void hsPlayerScoreChanged(HSPlayerScoreChanged event) {
        if (event.getBotId() == null) {
            return;
        }
        HSBotRecord<Player> record = this.ensureRecord(event.getBotId());
        record.setScore(event.getScore());
        if (event.getBotId() == this.getId()) {
            ((UT2004Bot)this.agent).getBotName().setInfo("S", String.valueOf(event.getScore()));
        }
    }

    protected void hsRoundEnd(HSRoundEnd event) {
        this.roundRunning.setFlag((Object)false);
        this.gameState.setFlag((Object)HSGameState.ROUND_ENDED);
    }

    protected void hsRoundStart(HSRoundStart event) {
        this.gameState.setFlag((Object)HSGameState.ROUND_STARTING);
        this.updateBotNameTag();
    }

    protected void hsRoundState(HSRoundState event) {
        if (event.getGameStateEnum() == HSGameState.HIDING_TIME) {
            for (HSBotRecord<Player> record : this.records.values()) {
                if (!record.isInGame() || record.getBotId() == this.seeker.getBotId()) continue;
                record.setRunnerForThisRound();
            }
            this.updateBotNameTag();
            this.roundRunning.setFlag((Object)true);
        }
        this.roundState = event;
        this.gameState.setFlag((Object)event.getGameStateEnum());
    }

    protected void hsRunnerCaptured(HSRunnerCaptured event) {
        HSBotRecord<Player> record = this.ensureRecord(event.getBotId());
        record.runnerCapturedBySeeker(0, this.getSeekerId());
        if (this.seeker != null) {
            this.seeker.seekerCapturedRunner(0, event.getBotId());
        }
    }

    protected void hsRunnerFouled(HSRunnerFouled event) {
        HSBotRecord<Player> record = this.ensureRecord(event.getBotId());
        record.runnerFauled(0, this.getSeekerId());
    }

    protected void hsRunnerSafe(HSRunnerSafe event) {
        HSBotRecord<Player> record = this.ensureRecord(event.getBotId());
        record.runnerSafe(0, this.getSeekerId());
        if (this.seeker != null) {
            this.seeker.seekerLetRunnerEscape(0, event.getBotId());
        }
    }

    protected void hsRunnerSpotted(HSRunnerSpotted event) {
        HSBotRecord<Player> record = this.ensureRecord(event.getBotId());
        record.runnerSpottedBySeeker(0, this.getSeekerId());
        if (this.seeker != null) {
            this.seeker.seekerSpottedRunner(0, event.getBotId());
        }
    }

    protected void hsRunnerSurvived(HSRunnerSurvived event) {
        HSBotRecord<Player> record = this.ensureRecord(event.getBotId());
        record.runnerSurvived(0, this.getSeekerId());
        if (this.seeker != null) {
            this.seeker.seekerLetRunnerSurvive(0, event.getBotId());
        }
    }

    private HSBotRecord<Player> ensureRecord(UnrealId botId) {
        if (botId == null || botId == UT2004HSServer.SERVER_UNREAL_ID) {
            return null;
        }
        HSBotRecord<Player> record = this.records.get(botId);
        record.setInGame(true);
        return record;
    }

    private void deleteRecord(UnrealId botId) {
        this.records.remove(botId);
    }

    private void resetHSGameData() {
        this.records.clear();
        this.removeBotNameTag();
    }

    private void removeBotNameTag() {
        this.info.getBotName().deleteInfo("HS");
    }

    private void updateBotNameTag() {
        HSBotState myState = this.records.get(this.getId()).getBotState();
        if (myState != null) {
            this.info.getBotName().setInfo("HS", myState.name());
        }
    }

    protected void start(boolean startToPaused) {
        super.start(startToPaused);
        this.hsTranslator.enable();
        this.hsEvents.enableHSEvents();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.hsTranslator.disable();
        this.hsEvents.disableTagEvents();
    }
}

