/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.tournament;

import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSGameConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.util.Map;

public class UT2004HideAndSeekConfig
extends UT2004MatchConfig {
    protected HSGameConfig hsConfig = new HSGameConfig();
    protected boolean humanLikeLog = false;

    public UT2004HideAndSeekConfig() {
        this.getGb2004Ini().setDMFragLimit(999);
        this.getGb2004Ini().setDMTimeLimit(999);
        this.getUccConf().setGameType("BotDeathMatch");
        this.setMatchId("HideAndSeekMatch");
    }

    public HSGameConfig getHsConfig() {
        return this.hsConfig;
    }

    public void setHsConfig(HSGameConfig hsConfig) {
        this.hsConfig = hsConfig;
    }

    public UT2004HideAndSeekConfig clearBots() {
        super.clearBots();
        return this;
    }

    public UT2004HideAndSeekConfig clearNativeBots() {
        super.clearNativeBots();
        return this;
    }

    public UT2004HideAndSeekConfig setOutputDirectory(File outputDirectory) {
        super.setOutputDirectory(outputDirectory);
        return this;
    }

    public UT2004HideAndSeekConfig setUccConf(UCCWrapperConf uccConf) {
        super.setUccConf(uccConf);
        return this;
    }

    public UT2004HideAndSeekConfig setBots(Map<IToken, UT2004BotConfig> bots) {
        super.setBots(bots);
        return this;
    }

    public UT2004HideAndSeekConfig setNativeBots(Map<IToken, UT2004NativeBotConfig> nativeBots) {
        super.setNativeBots(nativeBots);
        return this;
    }

    public UT2004HideAndSeekConfig addBot(UT2004BotConfig ... bots) {
        super.addBot(bots);
        return this;
    }

    public UT2004MatchConfig setBot(UT2004BotConfig ... bots) {
        super.setBot(bots);
        return this;
    }

    public UT2004HideAndSeekConfig addNativeBot(UT2004NativeBotConfig ... bots) {
        throw new RuntimeException("Tag! game cannot be played by native bots.");
    }

    public UT2004HideAndSeekConfig setNativeBot(UT2004NativeBotConfig ... bots) {
        throw new RuntimeException("Tag! game cannot be played by native bots.");
    }

    public UT2004HideAndSeekConfig setHumanLikeLogEnabled(boolean humanLikeLog) {
        super.setHumanLikeLogEnabled(humanLikeLog);
        return this;
    }

    protected void validateInner() {
        super.validateInner();
        if (this.hsConfig == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("hsConfig is null!");
            return;
        }
        if (this.hsConfig.isFixedSeeker() && (this.hsConfig.getFixedSeekerName() == null || this.hsConfig.getFixedSeekerName().isEmpty())) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("Fixed seeker configured as TRUE, but no name specified.");
        }
        if (this.hsConfig.getTargetMap() == null || this.hsConfig.getTargetMap().isEmpty()) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("No targetMap specified.");
        }
        if (this.hsConfig.getHideTimeUT() + this.hsConfig.getRestrictedAreaTimeUT() >= this.hsConfig.getRoundTimeUT()) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("HideTime + RestrictedAreaTime == " + (this.hsConfig.getHideTimeUT() + this.hsConfig.getRestrictedAreaTimeUT()) + " >= " + this.hsConfig.getRoundTimeUT() + " ==  RoundTime, invalid. HideTime and RestrictedTime are included within RoundTime.");
        }
        if (this.hsConfig.getRoundCount() <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("RoundCount == " + this.hsConfig.getRoundCount() + " <= 0, invalid. There must be at least 1 round to be played.");
        }
        if (this.hsConfig.getSafeArea() == null) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("SafeArea not specified, is null.");
        }
        if (this.hsConfig.getSafeAreaRadius() < 25) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("SafeAreaRadius == " + this.hsConfig.getSafeAreaRadius() + " < 25, invalid, UT2004 sensor snapshots are not that precise to be able to handle small areas.");
        }
        if (this.hsConfig.getRestrictedAreaRadius() < 25) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("RestrictedAreaRadius == " + this.hsConfig.getRestrictedAreaRadius() + " < 25, invalid, UT2004 sensor snapshots are not that precise to be able to handle small areas.");
        }
        if (this.hsConfig.getSafeAreaRadius() > this.hsConfig.getRestrictedAreaRadius()) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("RestrictedAreaRadius == " + this.hsConfig.getRestrictedAreaRadius() + " < " + this.hsConfig.getSafeAreaRadius() + " == SafeAreaRadius, invalid, restricted area must be greater than safe area.");
        }
        if ((double)this.hsConfig.getSpawnRadiusForRunners() < 25.0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("SpawnRadiusForRunners == " + this.hsConfig.getSpawnRadiusForRunners() + " < " + 25.0 + " == UnrealUtils.CHARACTER_COLLISION_RADIUS, runners won't have enough place for spawning.");
        }
    }
}

