/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.ut2004;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.sposh.context.IUT2004Context;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.exceptions.StateInstantiationException;
import cz.cuni.amis.pogamut.sposh.executor.IAction;
import cz.cuni.amis.pogamut.sposh.executor.ISense;
import cz.cuni.amis.pogamut.sposh.executor.StateWorkExecutor;
import cz.cuni.amis.pogamut.sposh.ut2004.SposhLogicController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

@AgentScoped
public abstract class StateSposhLogicController<BOT extends UT2004Bot, CONTEXT extends IUT2004Context>
extends SposhLogicController<BOT, StateWorkExecutor> {
    protected CONTEXT context;

    @Override
    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.context = this.createContext();
        this.getWorkExecutor();
    }

    public void finishControllerInitialization() {
        super.finishControllerInitialization();
        this.context.finishInitialization();
    }

    public final CONTEXT getContext() {
        return this.context;
    }

    protected void customPrimitiveInstantiation(StateWorkExecutor executor, Set<String> actions, Set<String> senses) {
    }

    private Class getActionClass(String actionName) {
        try {
            return Class.forName(actionName);
        }
        catch (ClassNotFoundException ex) {
            throw new StateInstantiationException("Unable to find state class for action \"" + actionName + "\"", (Exception)ex);
        }
    }

    private Class getSenseClass(String senseName) {
        try {
            return Class.forName(senseName);
        }
        catch (ClassNotFoundException ex) {
            throw new StateInstantiationException("Unable to find state class for sense \"" + senseName + "\"", (Exception)ex);
        }
    }

    private <T> T instantiatePrimitive(Class<T> cls) {
        String name = cls.getName();
        try {
            Constructor<?>[] constructors;
            Constructor<?> primitiveConstructor = null;
            Constructor<?>[] constructorArray = constructors = cls.getConstructors();
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] constructorParameters = constructor.getParameterTypes();
                if (constructorParameters.length == 1 && constructorParameters[0].isAssignableFrom(this.getContext().getClass())) {
                    primitiveConstructor = constructor;
                }
                ++n2;
            }
            if (primitiveConstructor == null) {
                throw new StateInstantiationException("Primitive \"" + name + "\" doesn't have a constructor that has exactly one parameter of class " + this.getContext().getClass().getName());
            }
            return primitiveConstructor.newInstance(this.getContext());
        }
        catch (InstantiationException ex) {
            throw new StateInstantiationException("Unable to instantiate primitive \"" + name + "\" (" + ex.getMessage() + ")", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new StateInstantiationException("Illegal access protection for primitive \"" + name + "\"", (Exception)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new StateInstantiationException("Primitive \"" + name + "\" doesn't accept bot class (" + this.bot.getClass().getName() + ") in the constructor.", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            throw new StateInstantiationException("Constructor of primitive \"" + name + "\" has thrown an exception (" + ex.getMessage() + ")", (Exception)ex);
        }
    }

    private Set<String> getActionNames() {
        HashSet<String> actionNames = new HashSet<String>();
        for (PoshEngine engine : this.getEngines()) {
            Set engineActions = engine.getPlan().getActionsNames();
            actionNames.addAll(engineActions);
        }
        return actionNames;
    }

    private Set<String> getSensesNames() {
        HashSet<String> senseNames = new HashSet<String>();
        for (PoshEngine engine : this.getEngines()) {
            Set engineSenses = engine.getPlan().getSensesNames();
            senseNames.addAll(engineSenses);
        }
        return senseNames;
    }

    @Override
    protected StateWorkExecutor createWorkExecutor() {
        Class cls;
        StateWorkExecutor executor = new StateWorkExecutor((Logger)this.bot.getLogger().getCategory("SPOSH"));
        Set<String> actions = this.getActionNames();
        Set<String> senses = this.getSensesNames();
        for (String senseName : senses) {
            if (!actions.contains(senseName)) continue;
            throw new StateInstantiationException("List of senses and " + senseName);
        }
        this.customPrimitiveInstantiation(executor, Collections.unmodifiableSet(actions), Collections.unmodifiableSet(senses));
        for (String name : actions) {
            if (executor.isNameUsed(name)) {
                throw new StateInstantiationException("Action instantiation: Primitive with name \"" + name + "\" is already in has already used in the executor.");
            }
            cls = this.getActionClass(name);
            IAction action = (IAction)this.instantiatePrimitive(cls);
            executor.addAction(name, action);
        }
        for (String name : senses) {
            if (executor.isNameUsed(name)) {
                throw new StateInstantiationException("Sense instantiation: Primitive with name \"" + name + "\" is already in has already used in the executor.");
            }
            cls = this.getSenseClass(name);
            ISense sense = (ISense)this.instantiatePrimitive(cls);
            executor.addSense(name, sense);
        }
        return executor;
    }

    @Override
    protected List<String> getPlans() throws IOException {
        return Arrays.asList(this.getPlan());
    }

    protected abstract String getPlan() throws IOException;

    protected abstract CONTEXT createContext();
}

