/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.context;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.sposh.JavaBehaviour;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AdrenalineCombo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.CTF;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.Visibility;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004AStar;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004Behaviour<BOT extends UT2004Bot>
extends JavaBehaviour<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected LogCategory user = null;
    protected LogCategory log = null;
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected ItemDescriptors descriptors;
    protected Items items;
    protected Senses senses;
    protected Weaponry weaponry;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected CompleteBotCommandsWrapper body;
    protected ImprovedShooting shoot;
    protected AdvancedLocomotion move;
    protected UT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected WeaponPrefs weaponPrefs;
    protected NavigationGraphBuilder navBuilder;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected UT2004GetBackToNavGraph getBackToNavGraph;
    protected UT2004RunStraight runStraight;
    protected UT2004Navigation navigation;
    protected Visibility visibility;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected IVisionWorldView world;
    protected NavPoints navPoints;
    protected UT2004AStar aStar;
    protected CTF ctf;
    protected AdrenalineCombo combo;
    protected IAct act;

    public UT2004Behaviour(String name, BOT bot) {
        super(name, bot);
        this.log = bot.getLogger().getCategory("User");
        this.log.setLevel(Level.ALL);
        this.user = this.log;
    }

    protected void initializeBehaviour(BOT bot) {
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UT2004AStarPathPlanner(bot);
        this.fwMap = new FloydWarshallMap(bot);
        this.aStar = new UT2004AStar(bot);
        this.pathExecutor = new UT2004PathExecutor(bot, (IUT2004PathNavigator)new LoqueNavigator(bot, (Logger)bot.getLog()));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph(bot, this.info, this.move);
        this.runStraight = new UT2004RunStraight(bot, this.info, this.move);
        this.navigation = new UT2004Navigation(bot, this.pathExecutor, (IPathPlanner)this.fwMap, (IUT2004GetBackToNavGraph)this.getBackToNavGraph, (IUT2004RunStraight)this.runStraight);
    }

    protected void initializeModules(BOT bot) {
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.game = new Game(bot);
        this.navPoints = new NavPoints(bot);
        this.players = new Players(bot);
        this.descriptors = new ItemDescriptors(bot);
        this.config = new AgentConfig(bot);
        this.raycasting = new Raycasting(bot);
        this.stats = new AgentStats(bot);
        this.navBuilder = new NavigationGraphBuilder(bot);
        this.info = new AgentInfo(bot, this.game);
        this.visibility = new Visibility(bot, this.info);
        this.ctf = new CTF(bot, this.info);
        this.weaponry = new Weaponry(bot, this.descriptors);
        this.items = new Items(bot, this.info, this.game, this.weaponry, null);
        this.senses = new Senses(bot, this.info, this.players);
        this.body = new CompleteBotCommandsWrapper(bot, this.weaponry, null);
        this.shoot = this.body.getImprovedShooting();
        this.move = this.body.getLocomotion();
        this.weaponPrefs = new WeaponPrefs(this.weaponry, bot);
        this.combo = new AdrenalineCombo(bot, this.info);
    }

    protected void prepareBehaviour(BOT bot) {
    }

    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    }

    public void finishBehaviourInitialization() {
        if (this.navBuilder.isUsed()) {
            this.log.info("Navigation graph has been altered by 'navBuilder', triggering recomputation of Floyd-Warshall path matrix...");
            Level oldLevel = this.fwMap.getLog().getLevel();
            this.fwMap.getLog().setLevel(Level.FINER);
            this.fwMap.refreshPathMatrix();
            this.fwMap.getLog().setLevel(oldLevel);
        }
    }

    public void botKilled(BotKilled event) {
    }

    public IVisionWorldView getWorldView() {
        return ((UT2004Bot)this.bot).getWorldView();
    }

    public IAct getAct() {
        return ((UT2004Bot)this.bot).getAct();
    }

    public UT2004GetBackToNavGraph getGetBackToNavGraph() {
        return this.getBackToNavGraph;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Random getRandom() {
        return this.random;
    }

    public LogCategory getLog() {
        return this.log;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public Players getPlayers() {
        return this.players;
    }

    public ItemDescriptors getDescriptors() {
        return this.descriptors;
    }

    public Items getItems() {
        return this.items;
    }

    public Senses getSensesModule() {
        return this.senses;
    }

    public Weaponry getWeaponry() {
        return this.weaponry;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public CompleteBotCommandsWrapper getBody() {
        return this.body;
    }

    public ImprovedShooting getShoot() {
        return this.shoot;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public UT2004PathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public WeaponPrefs getWeaponPrefs() {
        return this.weaponPrefs;
    }

    public NavigationGraphBuilder getNavBuilder() {
        return this.navBuilder;
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public UT2004RunStraight getRunStraight() {
        return this.runStraight;
    }

    public UT2004Navigation getNavigation() {
        return this.navigation;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public NavPoints getNavPoints() {
        return this.navPoints;
    }

    public UT2004AStar getaStar() {
        return this.aStar;
    }

    public CTF getCtf() {
        return this.ctf;
    }

    public AdrenalineCombo getCombo() {
        return this.combo;
    }
}

