package cz.cuni.amis.pogamut.sposh.ut2004.actions;

import cz.cuni.amis.pogamut.sposh.context.Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;

/**
 * Action that is not doing anything for 1 cycle.
 * @author Jimmy
 */
@PrimitiveInfo(name="doNothing", description="This action doesn't do anything.")
public class DoNothing extends StateAction<Context>{

	public DoNothing(Context ctx) {
        super("doNothing", ctx);
    }

    @Override
    public void init(VariableContext ctx) {
    }

    @Override
    public ActionResult run(VariableContext ctx) {
    	return ActionResult.RUNNING_ONCE;
    }

    @Override
    public void done(VariableContext ctx) {
    }

}
