// extend UIAction if this action should be UI Kismet Action instead of a Level Kismet Action
class SeqAction_DoorStateChanged extends SequenceAction;

var() string DoorFrom;
var() string DoorTo;

event Activated()
{

	local bool opened;

	if(InputLinks[0].bHasImpulse){
//		`log("Open " $ DoorName);
		opened = true;
	}
	else
	if (InputLinks[1].bHasImpulse)
	{
		opened = false;
//		`log("Close " $ DoorName);
	}

	class'SpyVsSpyBotConnection'.static.SendNotifyDoorStateChanged(DoorFrom, DoorTo, opened);	



}

defaultproperties
{
	ObjName="SeqAction_DoorStateChanged"
	ObjCategory="GameBotsUDK Actions"

	InputLinks.Empty
	InputLinks(0) = (LinkDesc="Open")
	InputLinks(1) = (LinkDesc="Close")

	VariableLinks.Empty
}
