/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut3.communication.messages;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.utils.maps.HashMapSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UT3ItemType
extends ItemType {
    private static final long serialVersionUID = 6128208226173615461L;
    protected static Map<String, ItemType> protos = new HashMap<String, ItemType>();
    public static final HashMapSet<UT3Group, ItemType> GROUPS = new HashMapSet();
    private ItemType.Category category;
    private UT3Group group;
    private String name;
    public static final UT3ItemType TRANSLOCATOR = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.TRANSLOCATOR, new String[]{"UTGame.UTWeap_Translocator_Content", "Translocator", "Translocator.WeaponPickup"});
    public static final UT3ItemType TRANSLOCATOR_PROJECTILE = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.TRANSLOCATOR, new String[]{"UTProj_TransDisc", "UT_Proj_TransDisc_ContentBlue", "UT_Proj_TransDisc_ContentRed"});
    public static final UT3ItemType IMPACT_HAMMER = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.IMPACT_HAMMER, new String[]{"UTGame.UTWeap_ImpactHammer", "ImpactHammer", "ImpactHammer.WeaponPickup"});
    public static final UT3ItemType IMPACT_HAMMER_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.IMPACT_HAMMER, new String[]{"ImpactHammerAmmo", "ImpactHammerAmmo.AmmoPickup"});
    public static final UT3ItemType ENFORCER = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.ENFORCER, new String[]{"UTGame.UTWeap_Enforcer", "Enforcer", "Enforcer.WeaponPickup"});
    public static final UT3ItemType ENFORCER_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.ENFORCER, new String[]{"GameBotsUT3.GBAmmo_Enforcer", "EnforcerAmmo", "EnforcerAmmo.AmmoPickup"});
    public static final UT3ItemType BIO_RIFLE = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.BIO_RIFLE, new String[]{"UTGameContent.UTWeap_BioRifle_Content", "BioRifle", "BioRifle.WeaponPickup"});
    public static final UT3ItemType BIO_RIFLE_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.BIO_RIFLE, new String[]{"GameBotsUT3.GBAmmo_BioRifle_Content", "BioRifleAmmo", "BioRifleAmmo.AmmoPickup"});
    public static final UT3ItemType BIO_RIFLE_PROJECTILE = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.BIO_RIFLE, new String[]{"UTProj_BioShot", "UTProj_BioGlob", "UTProj_BioGlobling"});
    public static final UT3ItemType SHOCK_RIFLE = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.SHOCK_RIFLE, new String[]{"UTGame.UTWeap_ShockRifle", "ShockRifle", "ShockRifle.WeaponPickup"});
    public static final UT3ItemType SHOCK_RIFLE_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.SHOCK_RIFLE, new String[]{"GameBotsUT3.GBAmmo_ShockRifle", "ShockRifleAmmo", "ShockRifleAmmo.AmmoPickup"});
    public static final UT3ItemType SHOCK_RIFLE_PROJECTILE = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.SHOCK_RIFLE, new String[]{"UTProj_ShockBall", "UTProj_HeroShockBall"});
    public static final UT3ItemType LINK_GUN = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.LINK_GUN, new String[]{"UTGame.UTWeap_LinkGun", "LinkGun", "LinkGun.WeaponPickup"});
    public static final UT3ItemType LINK_GUN_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.LINK_GUN, new String[]{"GameBotsUT3.GBAmmo_LinkGun", "LinkGunAmmo", "LinkGunAmmo.AmmoPickup"});
    public static final UT3ItemType LINK_GUN_PROJECTILE = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.LINK_GUN, new String[]{"XWeapons.LinkProjectile"});
    public static final UT3ItemType STINGER_MINIGUN = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.STINGER_MINIGUN, new String[]{"UTGame.UTWeap_Stinger", "Stinger", "Stinger.WeaponPickup"});
    public static final UT3ItemType STINGER_MINIGUN_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.STINGER_MINIGUN, new String[]{"GameBotsUT3.GBAmmo_Stinger", "StingerAmmo", "StingerAmmo.AmmoPickup"});
    public static final UT3ItemType STINGER_MINIGUN_SHARD = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.STINGER_MINIGUN, new String[]{"UTProj_StingerShard"});
    public static final UT3ItemType FLAK_CANNON = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.FLAK_CANNON, new String[]{"UTGame.UTWeap_FlakCannon", "FlakCannon", "FlakCannon.WeaponPickup"});
    public static final UT3ItemType FLAK_CANNON_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.FLAK_CANNON, new String[]{"GameBotsUT3.GBAmmo_FlakCannon", "FlakCannonAmmo", "FlakCannonAmmo.AmmoPickup"});
    public static final UT3ItemType FLAK_CANNON_CHUNK = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.FLAK_CANNON, new String[]{"UTProj_FlakShard", "UTProj_FlakShardMain"});
    public static final UT3ItemType FLAK_CANNON_SHELL = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.FLAK_CANNON, new String[]{"UTProj_FlakShell"});
    public static final UT3ItemType AVRIL = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.AVRIL, new String[]{"UTGameContent.UTWeap_Avril_Content", "Avril", "Avril.WeaponPickup"});
    public static final UT3ItemType AVRIL_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.AVRIL, new String[]{"GameBotsUT3.GBAmmo_AVRiL", "AVRiLAmmo", "AVRiLAmmo.AmmoPickup"});
    public static final UT3ItemType ROCKET_LAUNCHER = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.ROCKET_LAUNCHER, new String[]{"UTGame.UTWeap_RocketLauncher", "RocketLauncher", "RocketLauncher.WeaponPickup"});
    public static final UT3ItemType ROCKET_LAUNCHER_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.ROCKET_LAUNCHER, new String[]{"GameBotsUT3.RocketLauncher", "RocketLauncherAmmo", "RocketLauncherAmmo.AmmoPickup"});
    public static final UT3ItemType ROCKET_LAUNCHER_PROJECTILE = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.ROCKET_LAUNCHER, new String[]{"UTProj_Rocket", "UTProj_HeroRocket", "UTProj_LoadedRocket", "UTProj_SeekingRocket"});
    public static final UT3ItemType SNIPER_RIFLE = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.SNIPER_RIFLE, new String[]{"UTGame.UTWeap_SniperRifle", "SniperRifle", "SniperRifle.WeaponPickup"});
    public static final UT3ItemType SNIPER_RIFLE_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.SNIPER_RIFLE, new String[]{"GameBotsUT3.GBAmmo_SniperRifle", "SniperRifleAmmo", "SniperRifleAmmo.AmmoPickup"});
    public static final UT3ItemType REDEEMER = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.REDEEMER, new String[]{"UTGameContent.UTWeap_Redeemer_Content", "Redeemer", "Redeemer.WeaponPickup"});
    public static final UT3ItemType REDEEMER_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.REDEEMER, new String[]{"UTGameContent.UTAmmo_Redeemer_Content", "RedeemerAmmo", "RedeemerAmmo.AmmoPickup"});
    public static final UT3ItemType REDEEMER_PROJECTILE = UT3ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT3Group.REDEEMER, new String[]{"UTProj_Redeemer", "UTProj_RedeemerRed"});
    public static final UT3ItemType MEDIUM_HEALTH = UT3ItemType.MakePrototype(ItemType.Category.HEALTH, UT3Group.MEDIUM_HEALTH, new String[]{"UTGame.UTPickup_MediumHealth", "MediumHealth", "MediumHealth.HealthPickup"});
    public static final UT3ItemType HEALTH_VIAL = UT3ItemType.MakePrototype(ItemType.Category.HEALTH, UT3Group.HEALTH_VIAL, new String[]{"UTGame.UTPickup_HealthVial", "HealthVial", "HealthVial.HealthPickup"});
    public static final UT3ItemType SUPER_HEALTH_PACK = UT3ItemType.MakePrototype(ItemType.Category.HEALTH, UT3Group.SUPER_HEALTH, new String[]{"UTGame.UTPickup_SuperHealth", "SuperHealth", "SuperHealth.HealthPickup"});
    public static final UT3ItemType ARMOR_HELMET = UT3ItemType.MakePrototype(ItemType.Category.ARMOR, UT3Group.ARMOR_HELMET, new String[]{"UTGame.UTArmorHelmet", "Helmet", "Helmet.ArmorPickup"});
    public static final UT3ItemType ARMOR_SHIELD_BELT = UT3ItemType.MakePrototype(ItemType.Category.ARMOR, UT3Group.ARMOR_SHIELD_BELT, new String[]{"UTGame.UTArmor_ShieldBelt", "ShieldBelt", "ShieldBelt.ArmorPickup"});
    public static final UT3ItemType ARMOR_THIGHPADS = UT3ItemType.MakePrototype(ItemType.Category.ARMOR, UT3Group.ARMOR_THIGHPADS, new String[]{"UTGame.UTArmor_Thighpads", "Thighpads", "Thighpads.ArmorPickup"});
    public static final UT3ItemType ARMOR_VEST = UT3ItemType.MakePrototype(ItemType.Category.ARMOR, UT3Group.ARMOR_VEST, new String[]{"UTGame.UTArmor_Vest", "Vest", "Vest.ArmorPickup"});
    public static final UT3ItemType U_DAMAGE_PACK = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.UDAMAGE, new String[]{"UTGameContent.UTUDamage", "UDamage", "UDamage.Pickup"});
    public static final UT3ItemType BERSERK_PACK = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.BERSERK, new String[]{"UTGameContent.UTBerserk", "Berserk", "Berserk.Pickup"});
    public static final UT3ItemType JUMP_BOOTS = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.JUMP_BOOTS, new String[]{"UTGameContent.UTJumpBoots", "JumpBoots", "JumpBoots.Pickup"});
    public static final UT3ItemType XRAY_VOLUME = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.XRAY_VOLUME, new String[]{"UT3Gold.UTDeployableXRayVolume", "UTDeployableXRayVolume", "UTDeployableXRayVolume.WeaponPickup"});
    public static final UT3ItemType XRAY_VOLUME_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.XRAY_VOLUME, new String[]{"UTDeployableXRayVolumeAmmo", "UTDeployableXRayVolume.AmmoPickup"});
    public static final UT3ItemType SPIDERMINE_TRAP = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.SPIDERMINE_TRAP, new String[]{"UTGameContent.UTDeployableSpiderMineTrap", "UTDeployableSpiderMineTrap", "UTDeployableSpiderMineTrap.WeaponPickup"});
    public static final UT3ItemType SPIDERMINE_TRAP_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.SPIDERMINE_TRAP, new String[]{"UTDeployableSpiderMineTrapAmmo", "UTDeployableSpiderMineTrap.AmmoPickup"});
    public static final UT3ItemType ENERGY_SHIELD = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.ENERGY_SHIELD, new String[]{"UTGameContent.UTDeployableEnergyShield", "UTDeployableEnergyShield", "UTDeployableEnergyShield.WeaponPickup"});
    public static final UT3ItemType ENERGY_SHIELD_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.ENERGY_SHIELD, new String[]{"UTDeployableEnergyShieldAmmo", "UTDeployableEnergyShield.AmmoPickup"});
    public static final UT3ItemType EMP_MINE = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.EMP_MINE, new String[]{"EMPMine", "EMPMine.WeaponPickup", "UTDeployableEMPMine"});
    public static final UT3ItemType EMP_MINE_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.EMP_MINE, new String[]{"UTGameContent.UTDeployableEMPMine", "UTDeployableEMPMineAmmo", "UTDeployableEMPMine.AmmoPickup"});
    public static final UT3ItemType LINK_GENERATOR = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.LINK_GENERATOR, new String[]{"UTGameContent.UTDeployableLinkGenerator", "UTDeployableLinkGenerator", "UTDeployableLinkGenerator.WeaponPickup"});
    public static final UT3ItemType LINK_GENERATOR_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.LINK_GENERATOR, new String[]{"UTDeployableLinkGeneratorAmmo", "UTDeployableLinkGenerator.AmmoPickup"});
    public static final UT3ItemType SHAPED_CHARGE = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.SHAPED_CHARGE, new String[]{"UTGameContent.UTDeployableShapedCharge", "UTDeployableShapedCharge", "UTDeployableShapedCharge.WeaponPickup"});
    public static final UT3ItemType SHAPED_CHARGE_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.SHAPED_CHARGE, new String[]{"UTDeployableShapedChargeAmmo", "ShapedCharge.AmmoPickup"});
    public static final UT3ItemType SLOW_VOLUME = UT3ItemType.MakePrototype(ItemType.Category.WEAPON, UT3Group.SLOW_VOLUME, new String[]{"UTGameContent.UTDeployableSlowVolume", "UTDeployableSlowVolume", "UTDeployableSlowVolume.WeaponPickup"});
    public static final UT3ItemType SLOW_VOLUME_CONTENT = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.SLOW_VOLUME, new String[]{"UTSlowVolume_Content"});
    public static final UT3ItemType SLOW_VOLUME_AMMO = UT3ItemType.MakePrototype(ItemType.Category.AMMO, UT3Group.SLOW_VOLUME, new String[]{"UTDeployableSlowVolumeAmmo", "UTDeployableSlowVolume.AmmoPickup"});
    public static final UT3ItemType SLOW_FIELD = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.SLOW_FIELD, new String[]{"SlowField", "SlowField.Pickup"});
    public static final UT3ItemType INVISIBILITY = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.INVISIBILITY, new String[]{"Invisibility", "Invisibility.Pickup"});
    public static final UT3ItemType INVULNERABILITY = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.INVULNERABILITY, new String[]{"Invulnerability", "Invulnerability.Pickup"});
    public static final UT3ItemType WEAPON_LOCKER = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.WEAPON_LOCKER, new String[]{"WeaponLocker", "WeaponLocker.Pickup"});
    public static final UT3ItemType KEY = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.KEY, new String[]{"UnrealGame.KeyPickup"});
    public static final UT3ItemType NONE = UT3ItemType.MakePrototype(ItemType.Category.OTHER, UT3Group.NONE, new String[]{"None", "NONE", "none"});

    public static UT3ItemType getWeaponForAmmo(ItemType itemType) {
        if (itemType == null) {
            return NONE;
        }
        Set mySet = GROUPS.get((Object)itemType.getGroup());
        if (mySet != null) {
            for (ItemType type : mySet) {
                if (type.getGroup() != itemType.getGroup() || type.getCategory() != ItemType.Category.WEAPON) continue;
                return (UT3ItemType)type;
            }
        }
        return NONE;
    }

    public static UT3ItemType getAmmoForWeapon(ItemType itemType) {
        if (itemType == null) {
            return NONE;
        }
        Set mySet = GROUPS.get((Object)itemType.getGroup());
        if (mySet != null) {
            for (ItemType type : mySet) {
                if (type.getGroup() != itemType.getGroup() || type.getCategory() != ItemType.Category.AMMO) continue;
                return (UT3ItemType)type;
            }
        }
        return NONE;
    }

    public String toString() {
        return "ItemType[name = " + this.name + ", category = " + this.category + ", group = " + (Object)((Object)this.group) + "]";
    }

    public ItemType.Category getCategory() {
        return this.category;
    }

    public UT3Group getGroup() {
        return this.group;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof UT3ItemType && this.category == ((UT3ItemType)((Object)obj)).getCategory() && this.group == ((UT3ItemType)((Object)obj)).getGroup() && this.name == ((UT3ItemType)((Object)obj)).getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int compareTo(ItemType o) {
        if (o == null) {
            return 1;
        }
        if (this.getName() == null) {
            if (o.getName() == null) {
                return 0;
            }
            return 1;
        }
        if (o.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public UT3ItemType(String name) {
        this.name = name;
        this.category = ItemType.Category.OTHER;
        this.group = UT3Group.OTHER;
    }

    private UT3ItemType(String name, ItemType.Category category, UT3Group group) {
        this.name = name;
        this.category = category;
        this.group = group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UT3ItemType MakePrototype(ItemType.Category category, UT3Group group, String[] utNames) {
        UT3ItemType type;
        Map<String, ItemType> map = protos;
        synchronized (map) {
            type = new UT3ItemType(utNames[0], category, group);
            for (String utName : utNames) {
                protos.put(utName, type);
            }
            if (category != null) {
                CATEGORIES.get((Object)category).add(type);
            }
            if (group != null) {
                GROUPS.get((Object)group).add(type);
            }
        }
        return type;
    }

    public static UT3ItemType getWeaponItemType(UnrealId id) {
        if (id == null) {
            return null;
        }
        return UT3ItemType.getWeaponItemType(id.getStringId());
    }

    public static UT3ItemType getWeaponItemType(String str) {
        if ((str = str.toLowerCase()).contains("enforcer")) {
            return ENFORCER;
        }
        if (str.contains("impacthammer")) {
            return IMPACT_HAMMER;
        }
        if (str.contains("flakcannon")) {
            return FLAK_CANNON;
        }
        if (str.contains("biorifle")) {
            return BIO_RIFLE;
        }
        if (str.contains("shockrifle")) {
            return SHOCK_RIFLE;
        }
        if (str.contains("linkgun")) {
            return LINK_GUN;
        }
        if (str.contains("sniperrifle")) {
            return SNIPER_RIFLE;
        }
        if (str.contains("rocketlauncher")) {
            return ROCKET_LAUNCHER;
        }
        if (str.contains("minigun")) {
            return STINGER_MINIGUN;
        }
        if (str.contains("translocator")) {
            return TRANSLOCATOR;
        }
        if (str.contains("translauncher")) {
            return TRANSLOCATOR;
        }
        if (str.contains("xrayvolume")) {
            return XRAY_VOLUME;
        }
        if (str.contains("spiderminetrap")) {
            return SPIDERMINE_TRAP;
        }
        if (str.contains("energyshield")) {
            return ENERGY_SHIELD;
        }
        if (str.contains("empmine")) {
            return EMP_MINE;
        }
        if (str.contains("linkgenerator")) {
            return LINK_GENERATOR;
        }
        if (str.contains("shapedcharge")) {
            return SHAPED_CHARGE;
        }
        if (str.contains("slowvolume")) {
            return SLOW_VOLUME;
        }
        return null;
    }

    public static boolean isDeployable(ItemType item) {
        return item == EMP_MINE || item == ENERGY_SHIELD || item == LINK_GENERATOR || item == SHAPED_CHARGE || item == SLOW_VOLUME || item == SPIDERMINE_TRAP || item == XRAY_VOLUME;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemType getItemType(String utName) {
        ItemType type;
        Map<String, ItemType> map = protos;
        synchronized (map) {
            type = protos.get(utName);
            if (type != null) {
                return type;
            }
            type = new UT3ItemType(utName);
            protos.put(utName, type);
        }
        return type;
    }

    public static enum UT3Group implements ItemType.Group
    {
        TRANSLOCATOR("Translocator"),
        IMPACT_HAMMER("ImpactHammer"),
        ENFORCER("Enforcer"),
        BIO_RIFLE("BioRifle"),
        SHOCK_RIFLE("ShockRifle"),
        LINK_GUN("LinkGun"),
        STINGER_MINIGUN("Stinger"),
        FLAK_CANNON("FlakCannon"),
        ROCKET_LAUNCHER("RocketLauncher"),
        AVRIL("Avril"),
        SNIPER_RIFLE("SniperRifle"),
        REDEEMER("Redeemer"),
        WEAPON_LOCKER("WeaponLocker"),
        SLOW_FIELD("SlowField"),
        MEDIUM_HEALTH("MediumHealth"),
        HEALTH_VIAL("HealthVial"),
        SUPER_HEALTH("SuperHealth"),
        ARMOR_HELMET("Helmet"),
        ARMOR_VEST("Vest"),
        ARMOR_THIGHPADS("Thighpads"),
        ARMOR_SHIELD_BELT("ShieldBelt"),
        JUMP_BOOTS("JumpBoots"),
        UDAMAGE("UDamage"),
        BERSERK("Berserk"),
        INVULNERABILITY("Invulnerability"),
        INVISIBILITY("Invisibility"),
        KEY("Key"),
        OTHER("Unknown"),
        XRAY_VOLUME("XRayVolume"),
        SPIDERMINE_TRAP("SpiderMineTrap"),
        ENERGY_SHIELD("EnergyShield"),
        EMP_MINE("EMPMine"),
        LINK_GENERATOR("LinkGenerator"),
        SHAPED_CHARGE("ShapedCharge"),
        SLOW_VOLUME("SlowVolume"),
        NONE("None");

        public String name;

        private UT3Group(String name) {
            this.name = name;
        }

        public Set<ItemType> getTypes() {
            return GROUPS.get((Object)this);
        }

        public String getName() {
            return this.name;
        }
    }
}

