package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;
 		
 		// --- IMPORTS FROM /messages/settings/javasettings/javaimport BEGIN
			import java.util.*;import javax.vecmath.*;import cz.cuni.amis.pogamut.base.communication.messages.*;import cz.cuni.amis.pogamut.base.communication.worldview.*;import cz.cuni.amis.pogamut.base.communication.worldview.event.*;import cz.cuni.amis.pogamut.base.communication.worldview.object.*;import cz.cuni.amis.pogamut.multi.communication.worldview.object.*;import cz.cuni.amis.pogamut.base.communication.translator.event.*;import cz.cuni.amis.pogamut.multi.communication.translator.event.*;import cz.cuni.amis.pogamut.base3d.worldview.object.*;import cz.cuni.amis.pogamut.base3d.worldview.object.event.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.*;import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.objects.*;import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.*;import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;import cz.cuni.amis.utils.exception.*;import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult.Result;import cz.cuni.amis.utils.SafeEquals;import cz.cuni.amis.pogamut.base.agent.*;import cz.cuni.amis.pogamut.multi.agent.*;import cz.cuni.amis.pogamut.multi.communication.worldview.property.*;import cz.cuni.amis.pogamut.ut2004multi.communication.worldview.property.*;import cz.cuni.amis.utils.token.*;import cz.cuni.amis.utils.*;
		// --- IMPORTS FROM /messages/settings/javasettings/javaimport END
		
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] BEGIN
				
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name='all'] END
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=base]+classtype[@name=message] BEGIN
		
		// --- IMPORTS FROM extra/code/java/javapart/classcategory[@name=base]+classtype[@name=message] END
    
 		/**
         *  
             				Implementation of the GameBots2004 message UPD contains also its Local/Shared/Static subpart class definitions..  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
         */
 	public class LocationUpdateMessage   
  				extends 
  				LocationUpdate
  						implements IWorldObjectUpdatedEvent, ICompositeWorldObjectUpdatedEvent
  						
	    {
 	
    	
    	
    	/**
    	 * Parameter-less contructor for the message.
    	 */
		public LocationUpdateMessage()
		{
		}
	
    	
    	
    	
    	/**
		 * Creates new instance of the message LocationUpdate.
		 * 
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
		 * Corresponding GameBots message
		 *   
		 *   is
		 *   UPD.
		 * 
 	  	 * 
		 *   
		 *     @param Id Unique Id of this update message instance.
		 *   
		 * 
		 *   
		 *     @param Loc 
			An absolute location of the bot.
		
		 *   
		 * 
		 *   
		 *     @param Vel 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		
		 *   
		 * 
		 *   
		 *     @param Rot 
			Which direction the bot is facing in absolute terms.
		
		 *   
		 * 
		 */
		public LocationUpdateMessage(
			UnrealId Id,  Location Loc,  Velocity Vel,  Rotation Rot
		) {
			
					this.Id = Id;
				
					this.Loc = Loc;
				
					this.Vel = Vel;
				
					this.Rot = Rot;
				
		}
    
		/**
		 * Cloning constructor from the full message.
		 *
		 * @param original
		 */
		public LocationUpdateMessage(LocationUpdateMessage original) {		
			
					this.Id = original.getId()
 	;
				
					this.Loc = original.getLoc()
 	;
				
					this.Vel = original.getVel()
 	;
				
					this.Rot = original.getRot()
 	;
				
				this.TeamId = original.getTeamId();
			
			this.SimTime = original.getSimTime();
		}
		
    				
    					protected ITeamId TeamId;
    					
    					/**
    					 * Used by Yylex to slip corretn TeamId.
    					 */
    					protected void setTeamId(ITeamId TeamId) {
    					    this.TeamId = TeamId;
    					}
    				
    					public ITeamId getTeamId() {
							return TeamId;
						}
    	
    					
    					
    	
	    /**
         * Unique Id of this update message instance. 
         */
        protected
         UnrealId Id =
       	null;
	
    						
    						/**
		 					 * Whether property 'Id' was received from GB2004.
		 					 */
							protected boolean Id_Set = false;
							
    						@Override
		    				
 		/**
         * Unique Id of this update message instance. 
         */
        public  UnrealId getId()
 	 {
		    					return Id;
		    				}
		    			
    	
	    /**
         * 
			An absolute location of the bot.
		 
         */
        protected
         Location Loc =
       	null;
	
    						
    						/**
		 					 * Whether property 'Loc' was received from GB2004.
		 					 */
							protected boolean Loc_Set = false;
							
    						@Override
		    				
 		/**
         * 
			An absolute location of the bot.
		 
         */
        public  Location getLoc()
 	 {
		    					return Loc;
		    				}
		    			
    	
	    /**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        protected
         Velocity Vel =
       	null;
	
    						
    						/**
		 					 * Whether property 'Vel' was received from GB2004.
		 					 */
							protected boolean Vel_Set = false;
							
    						@Override
		    				
 		/**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        public  Velocity getVel()
 	 {
		    					return Vel;
		    				}
		    			
    	
	    /**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        protected
         Rotation Rot =
       	null;
	
    						
    						/**
		 					 * Whether property 'Rot' was received from GB2004.
		 					 */
							protected boolean Rot_Set = false;
							
    						@Override
		    				
 		/**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        public  Rotation getRot()
 	 {
		    					return Rot;
		    				}
		    			
		    			
		    			private LocationUpdateLocal localPart = null;
		    			
		    			@Override
						public LocationUpdateLocal 
						getLocal() {
							if (localPart != null) return localPart;
							return localPart = new 
								LocationUpdateLocalMessage();
						}
					
						private LocationUpdateShared sharedPart = null;
					
						@Override
						public LocationUpdateShared 
						getShared() {
							if (sharedPart != null) return sharedPart;							
							return sharedPart = new 
								LocationUpdateSharedMessage();
						}
					
						private LocationUpdateStatic staticPart = null; 
					
						@Override
						public LocationUpdateStatic 
						getStatic() {
							if (staticPart != null) return staticPart;
							return staticPart = new 
								LocationUpdateStaticMessage();
						}
    				
 		/**
         *  
            				Implementation of the local part of the GameBots2004 message UPD, used
            				to facade UPDMessage.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
         */
 	public class LocationUpdateLocalMessage 
	  					extends
  						LocationUpdateLocal
	    {
 	
		    			@Override
		    			public 
		    			LocationUpdateLocalMessage clone() {
		    				return this;
		    			}
		    			
		    				public LocationUpdateLocalMessage getLocal() {
								return this;
					    	}
							public ISharedWorldObject getShared() {
							 	throw new UnsupportedOperationException("Could not return LOCAL as SHARED");
							}
							public IStaticWorldObject getStatic() {
							    throw new UnsupportedOperationException("Could not return LOCAL as STATIC");
							}
		    			
 		/**
         * Unique Id of this update message instance. 
         */
        public  UnrealId getId()
 	 {
				    					return Id;
				    				}
				    			
 		/**
         * 
			An absolute location of the bot.
		 
         */
        public  Location getLoc()
 	 {
				    					return Loc;
				    				}
				    			
 		/**
         * 
			Absolute velocity of the bot as a vector of movement per one
			game second.
		 
         */
        public  Velocity getVel()
 	 {
				    					return Vel;
				    				}
				    			
 		/**
         * 
			Which direction the bot is facing in absolute terms.
		 
         */
        public  Rotation getRot()
 	 {
				    					return Rot;
				    				}
				    			
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
		              			"Loc = " + String.valueOf(getLoc()
 	) + " | " + 
		              		
		              			"Vel = " + String.valueOf(getVel()
 	) + " | " + 
		              		
		              			"Rot = " + String.valueOf(getRot()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
		              			"<b>Loc</b> = " + String.valueOf(getLoc()
 	) + " <br/> " + 
		              		
		              			"<b>Vel</b> = " + String.valueOf(getVel()
 	) + " <br/> " + 
		              		
		              			"<b>Rot</b> = " + String.valueOf(getRot()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=local+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=local+classtype[@name=message]) ---        	            	
 	
		}
 	
 		/**
         *  
            				Implementation of the static part of the GameBots2004 message UPD, used
            				to facade UPDMessage.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
         */
 	public class LocationUpdateStaticMessage 
	  					extends
  						LocationUpdateStatic
	    {
 	
		    			@Override
		    			public 
		    			LocationUpdateStaticMessage clone() {
		    				return this;
		    			}
		    			
 		/**
         * Unique Id of this update message instance. 
         */
        public  UnrealId getId()
 	 {
				    					return Id;
				    				}
				    			
 		
 		@Override
 		public boolean isDifferentFrom(IStaticWorldObject other)
 		{
 			if (other == null) //early fail
 			{
 				return true;
 			}
 			else if (other == this) //early out
 			{
 				return false;
 			}
 			else
 			{
 				LocationUpdateStatic obj = (LocationUpdateStatic) other;

 				
 						if ( !(
 	 			AdvancedEquals.equalsOrNull(this.getId()
 	, obj.getId()
 	)
 	 		) )
						{
							System.out.println("!!!!!PROPERTY UPDATE ERROR!!!! on property Id on object class LocationUpdateStatic");
							return true;
						}
 					
 			}
 			return false;
 		}
 	 
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=static+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=static+classtype[@name=message]) ---        	            	
 	
		}
 	
 		/**
         *  
            				Implementation of the shared part of the GameBots2004 message UPD, used
            				to facade UPDMessage.  
            			
         *
         *  <p></p><p></p>
         *  Complete message documentation:               
         *  
		"Synchronous" message. Arrives outside sync. batch. The frequency of this message is configured through locUpdateMultiplier variable in GameBots2004.ini file. It gets exported N times faster than regular sync. batch where N equals locUpdateMultiplier. Holds information about Location, Velocity and Rotation of the bot and should help us to create more robust navigation.
	
         */
 	public class LocationUpdateSharedMessage 
	  					extends
  						LocationUpdateShared
	    {
 	
    	
    	
		public LocationUpdateSharedMessage()
		{
			
		}		
    
		    			@Override
		    			public 
		    			LocationUpdateSharedMessage clone() {
		    				return this;
		    			}
		    			
		
		
		
		protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap<PropertyId, ISharedProperty>(
			0
		);
		
		@Override
		public ISharedProperty getProperty(PropertyId id) {
			return propertyMap.get(id);
		}

		@Override
		public Map<PropertyId, ISharedProperty> getProperties() {
			return propertyMap;
		}
	
		
		
 		/**
         * Unique Id of this update message instance. 
         */
        public  UnrealId getId()
 	 {
  			return Id;
  		}
  		
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=shared+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=shared+classtype[@name=message]) ---        	            	
 	
		}
 	
    	
    	
 	
		@Override
		public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject object) {
			if (object == null)
			{
				return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, this);
			}
			if (!( object instanceof LocationUpdateMessage) ) {
				throw new PogamutException("Can't update different class than LocationUpdateMessage, got class " + object.getClass().getSimpleName() + "!", this);		
			}
			LocationUpdateMessage toUpdate = (LocationUpdateMessage)object;
			
			boolean updated = false;
			
			// UPDATING LOCAL PROPERTIES
			
	            if (!SafeEquals.equals(toUpdate.Loc, getLoc()
 	)) {
					toUpdate.Loc=getLoc()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Vel, getVel()
 	)) {
					toUpdate.Vel=getVel()
 	;
					updated = true;
				}
			
				if (!SafeEquals.equals(toUpdate.Rot, getRot()
 	)) {
					toUpdate.Rot=getRot()
 	;
					updated = true;
				}
			
         	
         	// UPDATING SHARED PROPERTIES
         	
         	
         	// UPDATE TIME
         	toUpdate.SimTime = SimTime;
			
			if (updated) {
				return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.UPDATED, toUpdate);
			} else {
				return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.SAME, toUpdate);
			}
		}
		
		@Override
		public ILocalWorldObjectUpdatedEvent getLocalEvent() {
			return new LocationUpdateLocalImpl.LocationUpdateLocalUpdate
    (this.getLocal(), SimTime);
		}

		@Override
		public ISharedWorldObjectUpdatedEvent getSharedEvent() {
			return new LocationUpdateSharedImpl.LocationUpdateSharedUpdate
    (this.getShared(), SimTime, this.getTeamId());
		}

		@Override
		public IStaticWorldObjectUpdatedEvent getStaticEvent() {
			return new LocationUpdateStaticImpl.LocationUpdateStaticUpdate
    (this.getStatic(), SimTime);
		}
 	
 		
 	    public String toString() {
            return
            	super.toString() + "[" +
            	
		              			"Id = " + String.valueOf(getId()
 	) + " | " + 
		              		
		              			"Loc = " + String.valueOf(getLoc()
 	) + " | " + 
		              		
		              			"Vel = " + String.valueOf(getVel()
 	) + " | " + 
		              		
		              			"Rot = " + String.valueOf(getRot()
 	) + " | " + 
		              		
				"]";           		
        }
 	
 		
 		public String toHtmlString() {
 			return super.toString() + "[<br/>" +
            	
		              			"<b>Id</b> = " + String.valueOf(getId()
 	) + " <br/> " + 
		              		
		              			"<b>Loc</b> = " + String.valueOf(getLoc()
 	) + " <br/> " + 
		              		
		              			"<b>Vel</b> = " + String.valueOf(getVel()
 	) + " <br/> " + 
		              		
		              			"<b>Rot</b> = " + String.valueOf(getRot()
 	) + " <br/> " + 
		              		
				"<br/>]";     
		}
 	
 		
 		// --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=all]) ---
        	
		// --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=all]) ---
		
	    // --- Extra Java from XML BEGIN (extra/code/java/javapart/classcategory[@name=base+classtype[@name=message]) ---
	        
	    // --- Extra Java from XML END (extra/code/java/javapart/classcategory[@name=base+classtype[@name=message]) ---        	            	
 	
		}
 	