/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import org.junit.Assert;

public class EventWrapperWithCallCountConverter
implements Converter {
    private WorldViewTestContext ctx;

    public EventWrapperWithCallCountConverter(WorldViewTestContext ctx) {
        this.ctx = ctx;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        EventWrapperWithCallCount wrapper_with_count = (EventWrapperWithCallCount)value;
        writer.addAttribute("count", Integer.toString(wrapper_with_count.getExpectedNumberOfCalls()));
        writer.startNode("Wrapper");
        writer.addAttribute("class", wrapper_with_count.getEventWrapper().getClass().getName());
        context.convertAnother((Object)wrapper_with_count.getEventWrapper());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        int expectedNumberOfCalls = Integer.parseInt(reader.getAttribute("count"));
        reader.moveDown();
        String eventWrapperClassName = reader.getAttribute("class");
        try {
            EventWrapper wrapper = (EventWrapper)context.convertAnother((Object)this, Class.forName(eventWrapperClassName));
            EventWrapperWithCallCount wrapper_with_count = new EventWrapperWithCallCount(this.ctx, wrapper, expectedNumberOfCalls);
            reader.moveUp();
            return wrapper_with_count;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)("Could not find sub-class of EventWrapper: " + eventWrapperClassName + ", referenced in plan"));
            reader.moveUp();
            return null;
        }
    }

    public boolean canConvert(Class clazz) {
        return EventWrapperWithCallCount.class.isAssignableFrom(clazz);
    }
}

