package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import org.junit.Assert;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;

/**
 * Abstract class for object based event listener wrappers (B, C, D, E level). 
 * @author Radek 'Black_Hand' Pibil
 *
 * @param <OBJECT>
 */
public abstract class AbstractObjectEventWrapper<OBJECT extends IWorldObject> extends EventWrapper {

	/**
	 * Constructs and ObjectClassEventWrapper.
	 * @param expectedEvent
	 * @param level
	 * @param reactObjectClass
	 */
	public AbstractObjectEventWrapper(
			WorldViewTestContext ctx,
			IWorldEvent expectedEvent,
			ListenerLevel level) {
				
		super(ctx, expectedEvent, level);
		
		Assert.assertTrue("Use simply EventWrapper, if you wish to register a class A listener.",
				level != ListenerLevel.A);
	
		setListenerWrapper();
	}
	
	/**
	 * Override this method to set the correct listenerWrapper
	 */
	protected abstract void setListenerWrapper();
	
}